/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.ext;

import java.util.Date;
import java.util.EventListener;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.basic.AbstractOpenMenuJob;
import org.eclipse.scout.rt.ui.rap.ext.IDropDownButtonForPatch;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.util.BrowserInfo;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class DropDownButton
extends Button
implements IDropDownButtonForPatch {
    private static final long serialVersionUID = 1L;
    private Rectangle m_buttonArea = new Rectangle(1, 1, 13, 17);
    private Rectangle m_dropDownArea = new Rectangle(14, 1, 10, 17);
    private EventListenerList m_eventListeners = new EventListenerList();
    private Point m_mouseDownPosition;
    private boolean m_dropdownEnabled = true;
    private boolean m_buttonEnabled = true;
    private String m_originalVariant = "";

    public DropDownButton(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.addListener(31, new Listener(){
            private static final long serialVersionUID = 1L;

            public void handleEvent(Event e) {
                switch (e.detail) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: {
                        e.doit = true;
                    }
                }
            }
        });
        this.getUiEnvironment().addKeyStroke((Control)this, new P_KeyStroke(32), false);
        this.getUiEnvironment().addKeyStroke((Control)this, new P_KeyStroke(13), false);
        this.getUiEnvironment().addKeyStroke((Control)this, new P_KeyStroke(0x1000002), false);
        this.addFocusListener((FocusListener)new FocusAdapter(){
            private static final long serialVersionUID = 1L;

            public void focusGained(FocusEvent e) {
                DropDownButton.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                DropDownButton.this.redraw();
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){
            private static final long serialVersionUID = 1L;
            private long m_mouseDownTime = 0L;
            private P_OpenMenuJob m_openMenuJob;
            {
                this.m_openMenuJob = new P_OpenMenuJob((Control)DropDownButton.this);
            }

            public void mouseDown(MouseEvent event) {
                DropDownButton.this.m_mouseDownPosition = new Point(event.x, event.y);
                if (DropDownButton.this.isDropdownEnabled()) {
                    this.m_mouseDownTime = new Date().getTime();
                    this.m_openMenuJob.startOpenJob(DropDownButton.this.m_mouseDownPosition);
                }
                DropDownButton.this.redraw();
            }

            public void mouseUp(MouseEvent event) {
                if (event.button == 1) {
                    long mouseUpTime;
                    BrowserInfo browserInfo = RwtUtility.getBrowserInfo();
                    if ((browserInfo.isTablet() || browserInfo.isMobile()) && (mouseUpTime = new Date().getTime()) - this.m_mouseDownTime <= 500L) {
                        this.m_openMenuJob.stopOpenJob();
                    }
                    DropDownButton.this.handleSelectionInternal(event);
                }
                DropDownButton.this.m_mouseDownPosition = null;
                DropDownButton.this.redraw();
            }
        });
        this.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent e) {
                DropDownButton.this.getUiEnvironment().removeKeyStrokes((Control)DropDownButton.this);
            }
        });
    }

    @Override
    public boolean forceFocus() {
        if ((this.getStyle() & 0x80000) != 0) {
            return false;
        }
        return super.forceFocus();
    }

    protected void handleSelectionInternal(MouseEvent event) {
        Point pt = new Point(event.x, event.y);
        if (this.m_buttonArea.contains(pt)) {
            Event e = new Event();
            e.button = event.button;
            e.count = 1;
            e.data = event.data;
            e.display = event.display;
            e.stateMask = event.stateMask;
            e.time = event.time;
            e.widget = event.widget;
            e.x = event.x;
            e.y = event.y;
            this.fireSelectionEvent(new SelectionEvent(e));
        } else if (this.m_dropDownArea.contains(pt) && this.isDropdownEnabled() && this.getMenu() != null) {
            this.getMenu().setLocation(this.toDisplay(event.x, event.y));
            this.getMenu().setVisible(true);
        }
    }

    @Override
    public void fireSelectionEvent(SelectionEvent e) {
        if (this.isButtonEnabled()) {
            SelectionListener[] selectionListenerArray = (SelectionListener[])this.m_eventListeners.getListeners(SelectionListener.class);
            int n = selectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SelectionListener l = selectionListenerArray[n2];
                l.widgetSelected(e);
                ++n2;
            }
        }
    }

    @Override
    public void addSelectionListener(SelectionListener listener) {
        this.m_eventListeners.add(SelectionListener.class, (EventListener)listener);
    }

    @Override
    public void removeSelectionListener(SelectionListener listener) {
        this.m_eventListeners.remove(SelectionListener.class, (EventListener)listener);
    }

    @Override
    public void setDropdownEnabled(boolean enabled) {
        this.m_dropdownEnabled = enabled;
        if (!StringUtility.hasText((String)this.m_originalVariant)) {
            this.m_originalVariant = (String)this.getData("org.eclipse.rwt.themeVariant");
        }
        String customVariant = this.m_dropdownEnabled ? String.valueOf(this.m_originalVariant) + "_menu" : this.m_originalVariant;
        this.setData("org.eclipse.rwt.themeVariant", customVariant);
        super.setEnabled(this.isButtonEnabled());
        this.redraw();
    }

    @Override
    public boolean isDropdownEnabled() {
        return this.m_dropdownEnabled;
    }

    @Override
    public void setButtonEnabled(boolean enabled) {
        this.m_buttonEnabled = enabled;
        super.setEnabled(this.isButtonEnabled());
        this.redraw();
    }

    @Override
    public boolean isButtonEnabled() {
        return this.m_buttonEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_buttonEnabled = enabled;
        this.m_dropdownEnabled = enabled;
        this.redraw();
    }

    protected void checkSubclass() {
    }

    private IRwtEnvironment getUiEnvironment() {
        return (IRwtEnvironment)this.getDisplay().getData(IRwtEnvironment.class.getName());
    }

    private class P_KeyStroke
    extends RwtKeyStroke {
        public P_KeyStroke(int keyCode) {
            super(keyCode);
        }

        @Override
        public void handleUiAction(Event e) {
            switch (e.keyCode) {
                case 13: 
                case 32: {
                    SelectionEvent selEvent = new SelectionEvent(e);
                    DropDownButton.this.fireSelectionEvent(selEvent);
                    break;
                }
                case 0x1000002: {
                    if (!DropDownButton.this.isDropdownEnabled() || DropDownButton.this.getMenu() == null) break;
                    DropDownButton.this.getMenu().setLocation(DropDownButton.this.toDisplay(e.x, e.y));
                    DropDownButton.this.getMenu().setVisible(true);
                    break;
                }
            }
        }
    }

    private final class P_OpenMenuJob
    extends AbstractOpenMenuJob {
        public P_OpenMenuJob(Control UiField) {
            super(UiField);
        }

        @Override
        public void showMenu(Point pt) {
            DropDownButton.this.getMenu().setLocation(pt);
            DropDownButton.this.getMenu().setVisible(true);
        }

        @Override
        public boolean openMenuCheck() {
            return DropDownButton.this.isDropdownEnabled() && !DropDownButton.this.isDisposed() && DropDownButton.this.getMenu() != null && !DropDownButton.this.getMenu().isDisposed();
        }
    }
}

