/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.ext;

import java.util.EventListener;
import org.eclipse.rwt.widgets.FileUpload;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.ext.IDropDownFileUploadForPatch;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class DropDownFileUpload
extends FileUpload
implements IDropDownFileUploadForPatch {
    private static final long serialVersionUID = 1L;
    private Rectangle m_buttonArea = new Rectangle(1, 1, 13, 17);
    private Rectangle m_dropDownArea = new Rectangle(14, 1, 10, 17);
    private EventListenerList m_eventListeners = new EventListenerList();
    private boolean m_dropdownEnabled = true;
    private boolean m_buttonEnabled = true;
    private String m_originalVariant = "";

    public DropDownFileUpload(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.addListener(31, new Listener(){
            private static final long serialVersionUID = 1L;

            public void handleEvent(Event e) {
                switch (e.detail) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: {
                        e.doit = true;
                    }
                }
            }
        });
        this.getUiEnvironment().addKeyStroke((Control)this, new P_KeyStroke(32), false);
        this.getUiEnvironment().addKeyStroke((Control)this, new P_KeyStroke(13), false);
        this.getUiEnvironment().addKeyStroke((Control)this, new P_KeyStroke(0x1000002), false);
        this.addFocusListener((FocusListener)new FocusAdapter(){
            private static final long serialVersionUID = 1L;

            public void focusGained(FocusEvent e) {
                DropDownFileUpload.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                DropDownFileUpload.this.redraw();
            }
        });
        super.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                DropDownFileUpload.this.handleSelectionInternal(e);
                DropDownFileUpload.this.redraw();
            }
        });
        this.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent e) {
                DropDownFileUpload.this.getUiEnvironment().removeKeyStrokes((Control)DropDownFileUpload.this);
            }
        });
    }

    @Override
    public boolean forceFocus() {
        if ((this.getStyle() & 0x80000) != 0) {
            return false;
        }
        return super.forceFocus();
    }

    protected void handleSelectionInternal(SelectionEvent event) {
        this.fireSelectionEvent(event);
    }

    @Override
    public void fireSelectionEvent(SelectionEvent e) {
        if (this.isButtonEnabled()) {
            SelectionListener[] selectionListenerArray = (SelectionListener[])this.m_eventListeners.getListeners(SelectionListener.class);
            int n = selectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SelectionListener l = selectionListenerArray[n2];
                l.widgetSelected(e);
                ++n2;
            }
        }
    }

    @Override
    public void addSelectionListener(SelectionListener listener) {
        this.m_eventListeners.add(SelectionListener.class, (EventListener)listener);
    }

    @Override
    public void removeSelectionListener(SelectionListener listener) {
        this.m_eventListeners.remove(SelectionListener.class, (EventListener)listener);
    }

    @Override
    public void setDropdownEnabled(boolean enabled) {
        this.m_dropdownEnabled = enabled;
        if (!StringUtility.hasText((String)this.m_originalVariant)) {
            this.m_originalVariant = (String)this.getData("org.eclipse.rwt.themeVariant");
        }
        String customVariant = this.m_dropdownEnabled ? String.valueOf(this.m_originalVariant) + "_menu" : this.m_originalVariant;
        this.setData("org.eclipse.rwt.themeVariant", customVariant);
        super.setEnabled(this.isButtonEnabled());
        this.redraw();
    }

    @Override
    public boolean isDropdownEnabled() {
        return this.m_dropdownEnabled;
    }

    @Override
    public void setButtonEnabled(boolean enabled) {
        this.m_buttonEnabled = enabled;
        super.setEnabled(this.isButtonEnabled());
        this.redraw();
    }

    @Override
    public boolean isButtonEnabled() {
        return this.m_buttonEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_buttonEnabled = enabled;
        this.m_dropdownEnabled = enabled;
        this.redraw();
    }

    protected void checkSubclass() {
    }

    private IRwtEnvironment getUiEnvironment() {
        return (IRwtEnvironment)this.getDisplay().getData(IRwtEnvironment.class.getName());
    }

    private class P_KeyStroke
    extends RwtKeyStroke {
        public P_KeyStroke(int keyCode) {
            super(keyCode);
        }

        @Override
        public void handleUiAction(Event e) {
            switch (e.keyCode) {
                case 13: 
                case 32: {
                    SelectionEvent selEvent = new SelectionEvent(e);
                    DropDownFileUpload.this.fireSelectionEvent(selEvent);
                    break;
                }
                case 0x1000002: {
                    if (!DropDownFileUpload.this.isDropdownEnabled() || DropDownFileUpload.this.getMenu() == null) break;
                    DropDownFileUpload.this.getMenu().setLocation(DropDownFileUpload.this.toDisplay(e.x, e.y));
                    DropDownFileUpload.this.getMenu().setVisible(true);
                    break;
                }
            }
        }
    }
}

