/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields;

import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.ui.rap.ext.TextEx;
import org.eclipse.scout.rt.ui.rap.ext.custom.StyledText;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFieldComposite;
import org.eclipse.swt.widgets.Control;

public abstract class RwtScoutValueFieldComposite<T extends IValueField<?>>
extends RwtScoutFieldComposite<T> {
    @Override
    protected void attachScout() {
        super.attachScout();
        this.setValueFromScout();
        this.setDisplayTextFromScout(((IValueField)this.getScoutObject()).getDisplayText());
        if (this.getOnFieldLabelDecorator() != null) {
            this.setOnFieldLabelFromScout(((IValueField)this.getScoutObject()).getDisplayText(), ((IValueField)this.getScoutObject()).getLabel());
        }
    }

    protected void setValueFromScout() {
    }

    protected void setDisplayTextFromScout(String s) {
    }

    public void setOnFieldLabelFromScout(String text, String label) {
        if (text == null || text.length() == 0) {
            if (this.getUiField() != null && this.getUiField() instanceof StyledText) {
                Integer length = (Integer)((IValueField)this.getScoutObject()).getCustomProperty("maxLength");
                if (length != null && label.length() > 0 && length < label.length()) {
                    ((StyledText)this.getUiField()).setTextLimit(label.length());
                }
                ((TextEx)this.getUiField()).setOnFieldLabel(label);
                this.getUiField().setData("org.eclipse.rwt.themeVariant", (Object)"onFieldLabel");
            }
        } else if (this.getUiField() instanceof Control) {
            Integer length = (Integer)((IValueField)this.getScoutObject()).getCustomProperty("maxLength");
            if (length != null) {
                ((TextEx)this.getUiField()).setTextLimit(length);
            }
            this.getUiField().setData("org.eclipse.rwt.themeVariant", null);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("displayText")) {
            String displayText = (String)newValue;
            this.setDisplayTextFromScout(displayText);
            if (this.getOnFieldLabelDecorator() != null && StringUtility.hasText((String)displayText) && CompareUtility.notEquals((Object)displayText, (Object)((IValueField)this.getScoutObject()).getLabel())) {
                this.setOnFieldLabelFromScout(displayText, ((IValueField)this.getScoutObject()).getLabel());
            }
        } else if (name.equals("value")) {
            this.setValueFromScout();
        }
    }
}

