/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.stringfield;

import java.beans.PropertyChangeEvent;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.IDNDSupport;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.ext.StyledTextEx;
import org.eclipse.scout.rt.ui.rap.ext.custom.StyledText;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.form.fields.AbstractRwtScoutDndSupport;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.stringfield.IRwtScoutStringField;
import org.eclipse.scout.rt.ui.rap.internal.TextFieldEditableSupport;
import org.eclipse.scout.rt.ui.rap.keystroke.IRwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class RwtScoutStringField
extends RwtScoutValueFieldComposite<IStringField>
implements IRwtScoutStringField {
    public static final int DEFAULT_CASE = 0;
    public static final int UPPER_CASE = 1;
    public static final int LOWER_CASE = 2;
    private int m_characterType = -1;
    private MouseListener m_linkTrigger;
    private boolean m_validateOnAnyKey;
    private boolean m_linkDecoration;
    private TextFieldEditableSupport m_editableSupport;

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        int style = 2048;
        if (((IStringField)this.getScoutObject()).isInputMasked()) {
            style |= 0x400000;
        }
        style = ((IStringField)this.getScoutObject()).isMultilineText() ? (style |= 0x202) : (style |= 4);
        if (((IStringField)this.getScoutObject()).isWrapText()) {
            style |= 0x40;
        }
        StyledText textField = this.getUiEnvironment().getFormToolkit().createStyledText(container, style);
        textField.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent e) {
            }
        });
        this.setUiContainer(container);
        this.setUiLabel(label);
        this.setUiField((Control)textField);
        this.addDefaultUiListeners(textField);
        LogicalGridLayout layout = new LogicalGridLayout(1, 0);
        this.getUiContainer().setLayout((Layout)layout);
    }

    protected void addDefaultUiListeners(StyledText textField) {
        textField.addModifyListener(new P_RwtTextListener());
        textField.addSelectionListener((SelectionListener)new P_RwtTextSelectionListener());
        textField.addVerifyListener(new P_TextVerifyListener());
        textField.addFocusListener(new P_RwtTextFocsListener());
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IStringField f = (IStringField)this.getScoutObject();
        this.setDecorationLinkFromScout(f.isDecorationLink());
        this.setFormatFromScout(f.getFormat());
        this.setMaxLengthFromScout(f.getMaxLength());
        this.setValidateOnAnyKeyFromScout(f.isValidateOnAnyKey());
        this.setSelectionFromScout(f.getSelectionStart(), f.getSelectionEnd());
        this.setTextWrapFromScout(f.isWrapText());
        this.attachDndSupport();
    }

    protected void attachDndSupport() {
        if (UiDecorationExtensionPoint.getLookAndFeel().isDndSupportEnabled()) {
            new P_DndSupport((IPropertyObserver)this.getScoutObject(), (IDNDSupport)this.getScoutObject(), (Control)this.getUiField());
        }
    }

    @Override
    public StyledTextEx getUiField() {
        return (StyledTextEx)super.getUiField();
    }

    @Override
    protected void setFieldEnabled(Control swtField, boolean enabled) {
        if (this.m_editableSupport == null) {
            this.m_editableSupport = new TextFieldEditableSupport(this.getUiField());
        }
        this.m_editableSupport.setEditable(enabled);
    }

    @Override
    protected IRwtKeyStroke[] getUiKeyStrokes() {
        if (((IStringField)this.getScoutObject()).isMultilineText()) {
            return new IRwtKeyStroke[]{new RwtKeyStroke(13, 0, false){

                @Override
                public void handleUiAction(Event e) {
                    e.doit = false;
                }
            }};
        }
        return super.getUiKeyStrokes();
    }

    protected void setDecorationLinkFromScout(boolean b) {
        if (this.m_linkDecoration != b) {
            this.m_linkDecoration = b;
            if (this.m_linkDecoration) {
                this.m_linkTrigger = new P_RwtLinkTrigger();
                this.getUiField().addMouseListener(this.m_linkTrigger);
                this.getUiField().setCursor(this.getUiField().getDisplay().getSystemCursor(21));
                this.setForegroundFromScout(((IStringField)this.getScoutObject()).getForegroundColor());
            } else {
                this.getUiField().removeMouseListener(this.m_linkTrigger);
                this.m_linkTrigger = null;
                this.getUiField().setCursor(null);
                this.setForegroundFromScout(((IStringField)this.getScoutObject()).getForegroundColor());
            }
        }
    }

    @Override
    protected void setForegroundFromScout(String scoutColor) {
        if (scoutColor == null && this.m_linkDecoration) {
            scoutColor = "0000FF";
        }
        super.setForegroundFromScout(scoutColor);
    }

    protected void setFormatFromScout(String s) {
        this.m_characterType = "A".equals(s) ? 1 : ("a".equals(s) ? 2 : 0);
    }

    protected void setMaxLengthFromScout(int n) {
        this.getUiField().setTextLimit(n);
    }

    protected void setDoInsertFromScout(String s) {
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        if (this.m_validateOnAnyKey && this.getUiField().isFocusControl()) {
            return;
        }
        StyledTextEx field = this.getUiField();
        String oldText = field.getText();
        if (s == null) {
            s = "";
        }
        if (oldText == null) {
            oldText = "";
        }
        if (oldText.equals(s)) {
            return;
        }
        int cfr_ignored_0 = field.getSelection().x;
        int cfr_ignored_1 = field.getSelection().y;
        field.setText(s);
        field.getText().length();
    }

    protected void setValidateOnAnyKeyFromScout(boolean b) {
        this.m_validateOnAnyKey = b;
    }

    protected void setSelectionFromScout(int startIndex, int endIndex) {
        StyledTextEx field = this.getUiField();
        int start = field.getSelection().x;
        int end = field.getSelection().y;
        if (startIndex < 0) {
            startIndex = start;
        }
        if (endIndex < 0) {
            endIndex = end;
        }
        field.setSelection(startIndex, endIndex);
    }

    protected void setTextWrapFromScout(boolean booleanValue) {
        ((IStringField)this.getScoutObject()).isMultilineText();
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("decorationLink")) {
            this.setDecorationLinkFromScout((Boolean)newValue);
        } else if (name.equals("maxLength")) {
            this.setMaxLengthFromScout(((Number)newValue).intValue());
        } else if (name.equals("insertText")) {
            this.setDoInsertFromScout((String)newValue);
        } else if (name.equals("validateOnAnyKey")) {
            this.setValidateOnAnyKeyFromScout((Boolean)newValue);
        } else if (name.equals("selectionStart")) {
            IStringField f = (IStringField)this.getScoutObject();
            this.setSelectionFromScout(f.getSelectionStart(), f.getSelectionEnd());
        } else if (name.equals("selectionEnd")) {
            IStringField f = (IStringField)this.getScoutObject();
            this.setSelectionFromScout(f.getSelectionStart(), f.getSelectionEnd());
        } else if (name.equals("wrapText")) {
            this.setTextWrapFromScout((Boolean)newValue);
        }
    }

    protected void handleUiLinkTrigger() {
        final String text = this.getUiField().getText();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IStringField)RwtScoutStringField.this.getScoutObject()).getUIFacade().fireLinkActionFromUI(text);
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    protected void setSelectionFromUi(final int startIndex, final int endIndex) {
        if (this.getUpdateUiFromScoutLock().isAcquired()) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    RwtScoutStringField.this.addIgnoredScoutEvent(PropertyChangeEvent.class, "selectionStart");
                    RwtScoutStringField.this.addIgnoredScoutEvent(PropertyChangeEvent.class, "selectionEnd");
                    ((IStringField)RwtScoutStringField.this.getScoutObject()).getUIFacade().setSelectionFromUI(startIndex, endIndex);
                }
                finally {
                    RwtScoutStringField.this.removeIgnoredScoutEvent(PropertyChangeEvent.class, "selectionStart");
                    RwtScoutStringField.this.removeIgnoredScoutEvent(PropertyChangeEvent.class, "selectionEnd");
                }
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    @Override
    protected void handleUiInputVerifier(boolean doit) {
        if (!doit) {
            return;
        }
        final String text = this.getUiField().getText();
        if (CompareUtility.equals((Object)text, (Object)((IStringField)this.getScoutObject()).getDisplayText()) && ((IStringField)this.getScoutObject()).getErrorStatus() == null) {
            return;
        }
        final Holder result = new Holder(Boolean.class, (Object)false);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((IStringField)RwtScoutStringField.this.getScoutObject()).getUIFacade().setTextFromUI(text);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getUiEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {}
        doit = (Boolean)result.getValue();
        this.getUiEnvironment().dispatchImmediateUiJobs();
    }

    @Override
    protected void handleUiFocusGained() {
        super.handleUiFocusGained();
        if (this.isSelectAllOnFocusEnabled()) {
            this.getUiField().setSelection(0, this.getUiField().getText().length());
        }
    }

    @Override
    protected boolean isSelectAllOnFocusEnabled() {
        return super.isSelectAllOnFocusEnabled() && ((IStringField)this.getScoutObject()).isSelectAllOnFocus();
    }

    private class P_DndSupport
    extends AbstractRwtScoutDndSupport {
        public P_DndSupport(IPropertyObserver scoutObject, IDNDSupport scoutDndSupportable, Control control) {
            super(scoutObject, scoutDndSupportable, control, RwtScoutStringField.this.getUiEnvironment());
        }

        @Override
        protected TransferObject handleUiDragRequest() {
            final Holder result = new Holder(TransferObject.class, null);
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    TransferObject scoutTransferable = ((IStringField)RwtScoutStringField.this.getScoutObject()).getUIFacade().fireDragRequestFromUI();
                    result.setValue((Object)scoutTransferable);
                }
            };
            JobEx job = this.getUiEnvironment().invokeScoutLater(t, 2345L);
            try {
                job.join(2345L);
            }
            catch (InterruptedException interruptedException) {}
            return (TransferObject)result.getValue();
        }

        @Override
        protected void handleUiDropAction(DropTargetEvent event, final TransferObject scoutTransferObject) {
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    if (((IStringField)RwtScoutStringField.this.getScoutObject()).isEnabled()) {
                        ((IStringField)RwtScoutStringField.this.getScoutObject()).getUIFacade().fireDropActionFromUi(scoutTransferObject);
                    }
                }
            };
            this.getUiEnvironment().invokeScoutLater(job, 200L);
        }
    }

    private class P_RwtLinkTrigger
    extends MouseAdapter {
        private static final long serialVersionUID = 1L;

        private P_RwtLinkTrigger() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            RwtScoutStringField.this.handleUiLinkTrigger();
        }
    }

    public class P_RwtTextFocsListener
    implements FocusListener {
        private static final long serialVersionUID = 1L;

        public void focusGained(FocusEvent event) {
        }

        public void focusLost(FocusEvent event) {
            RwtScoutStringField.this.handleUiInputVerifier(true);
        }
    }

    private class P_RwtTextListener
    implements ModifyListener {
        private static final long serialVersionUID = 1L;

        private P_RwtTextListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (RwtScoutStringField.this.m_validateOnAnyKey) {
                if (RwtScoutStringField.this.getOnFieldLabelDecorator() != null && e.getSource() instanceof StyledText && (StringUtility.isNullOrEmpty((String)((StyledText)((Object)e.getSource())).getText()) || CompareUtility.equals((Object)((StyledText)((Object)e.getSource())).getText(), (Object)((IStringField)RwtScoutStringField.this.getScoutObject()).getInitialLabel()))) {
                    return;
                }
                if (RwtScoutStringField.this.getUpdateUiFromScoutLock().isReleased()) {
                    this.sendVerifyToScoutAndIgnoreResponses();
                }
            }
        }

        private void sendVerifyToScoutAndIgnoreResponses() {
            final String text = RwtScoutStringField.this.getUiField().getText();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((IStringField)RwtScoutStringField.this.getScoutObject()).getUIFacade().setTextFromUI(text);
                }
            };
            RwtScoutStringField.this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    private class P_RwtTextSelectionListener
    extends SelectionAdapter {
        private static final long serialVersionUID = 1L;

        private P_RwtTextSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            RwtScoutStringField.this.setSelectionFromUi(e.x, e.y);
        }
    }

    private class P_TextVerifyListener
    implements VerifyListener {
        private static final long serialVersionUID = 1L;

        private P_TextVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            switch (RwtScoutStringField.this.m_characterType) {
                case 1: {
                    e.text = e.text.toUpperCase();
                    break;
                }
                case 2: {
                    e.text = e.text.toLowerCase();
                }
            }
        }
    }
}

