/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.svg.calendar.comp;

import java.util.Date;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.ui.svg.calendar.CalendarSvgUtility;
import org.eclipse.scout.rt.ui.svg.calendar.comp.IComponentElementFactory;
import org.eclipse.scout.svg.client.SVGUtility;
import org.w3c.dom.Element;

public abstract class AbstractComponentElementFactory
implements IComponentElementFactory {
    private CalendarComponent m_selectedComponent;

    @Override
    public final void setSelectedComponent(CalendarComponent c) {
        this.m_selectedComponent = c;
    }

    protected final CalendarComponent getSelectedComponent() {
        return this.m_selectedComponent;
    }

    protected static void setElementDimensions(Element e, SvgRect dimensions) {
        e.setAttribute("x", "" + dimensions.x);
        e.setAttribute("y", "" + dimensions.y);
        e.setAttribute("width", "" + dimensions.width);
        e.setAttribute("height", "" + dimensions.height);
    }

    protected static SvgRect getCopyWithPadding(SvgRect rect, float padding) {
        SvgRect ret = new SvgRect();
        ret.x = rect.x + padding;
        ret.y = rect.y + padding;
        ret.width = rect.width - 2.0f * padding;
        ret.height = rect.height - 2.0f * padding;
        return ret;
    }

    protected Element createNewComponentElement(Element template, CalendarComponent c, Date day) {
        Element newEl = (Element)template.cloneNode(false);
        Element title = template.getOwnerDocument().createElementNS("http://www.w3.org/2000/svg", "title");
        SVGUtility.setTextContent((Element)title, (String)c.getTooltip(day));
        newEl.appendChild(title);
        newEl.setAttribute("id", "comp" + c.getItem().getId());
        CalendarSvgUtility.removeBorder(newEl);
        CalendarSvgUtility.setBackgroundColor(newEl, c.getItem().getColor(), this.getSelectedComponent() == c);
        return newEl;
    }

    protected static SvgRect getElementDimensions(Element e) {
        SvgRect ret = new SvgRect();
        ret.x = Float.parseFloat(e.getAttribute("x"));
        ret.y = Float.parseFloat(e.getAttribute("y"));
        ret.width = Float.parseFloat(e.getAttribute("width"));
        ret.height = Float.parseFloat(e.getAttribute("height"));
        return ret;
    }

    protected static class SvgRect {
        protected float x;
        protected float y;
        protected float width;
        protected float height;

        protected SvgRect() {
        }
    }
}

