/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.browserfield.internal;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.RunnableWithException;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.form.fields.browserfield.IBrowserField;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.browserfield.ISwingScoutBrowserField;
import org.eclipse.scout.rt.ui.swing.form.fields.browserfield.internal.DisposeUtil;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SwingScoutBrowserField
extends SwingScoutValueFieldComposite<IBrowserField>
implements ISwingScoutBrowserField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutBrowserField.class);
    private static Display swtDisplay;
    private Shell m_swtShell;
    private Browser m_swtBrowser;
    private File m_tempDir;
    private String m_currentLocation;
    private final List<RunnableWithException<?>> m_swtCommandQueue;
    private final Object m_swtCommandQueueLock = new Object();
    private P_CanvasEx m_canvas;
    private P_HierarchyListener m_hierarchyListener;

    static {
        StaticDisplayDispatcher disp = new StaticDisplayDispatcher();
        disp.start();
        swtDisplay = disp.getDisplay();
    }

    public SwingScoutBrowserField() {
        this.m_swtCommandQueue = new LinkedList();
    }

    protected void initializeSwing() {
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        JPanelEx wordComponent = new JPanelEx();
        this.m_canvas = new P_CanvasEx();
        wordComponent.add((Component)this.m_canvas);
        container.add((Component)wordComponent);
        this.setSwingContainer((JComponent)container);
        this.setSwingField((JComponent)wordComponent);
        this.getSwingContainer().setLayout((LayoutManager)new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    protected void attachScout() {
        super.attachScout();
        if (this.m_hierarchyListener == null) {
            this.m_hierarchyListener = new P_HierarchyListener();
            this.m_canvas.addHierarchyListener(this.m_hierarchyListener);
        }
    }

    protected void detachScout() {
        if (this.m_hierarchyListener != null) {
            this.m_canvas.removeHierarchyListener(this.m_hierarchyListener);
            this.m_hierarchyListener = null;
        }
        if (this.m_tempDir != null) {
            IOUtility.deleteDirectory((File)this.m_tempDir);
            this.m_tempDir = null;
        }
        super.detachScout();
    }

    private boolean isSwtAttached() {
        return this.m_swtBrowser != null;
    }

    private void attachSwtSafe() {
        try {
            if (this.isSwtAttached()) {
                return;
            }
            swtDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            SwingScoutBrowserField.this.m_swtShell = SWT_AWT.new_Shell((Display)Display.getDefault(), (Canvas)SwingScoutBrowserField.this.m_canvas);
                            SwingScoutBrowserField.this.m_swtBrowser = new Browser((Composite)SwingScoutBrowserField.this.m_swtShell, 0);
                            SwingScoutBrowserField.this.m_swtShell.setLayout((Layout)new FillLayout());
                            SwingScoutBrowserField.this.runSwtCommandsInsideSwtThread();
                            SwingScoutBrowserField.this.m_swtBrowser.addLocationListener((LocationListener)new LocationAdapter(){

                                public void changing(LocationEvent event) {
                                    event.doit = SwingScoutBrowserField.this.fireBeforeLocationChangedFromSwt(event.location);
                                }

                                public void changed(LocationEvent event) {
                                    SwingScoutBrowserField.this.fireAfterLocationChangedFromSwt(event.location);
                                }
                            });
                        }
                        catch (Exception e) {
                            LOG.error("Unexpected error occured while attaching Microsoft Word. All resources safely disposed.", (Throwable)e);
                            SwingScoutBrowserField.this.detachSwtSafe();
                            SwingScoutBrowserField.this.getSwingContainer().revalidate();
                        }
                    }
                    finally {
                        SwingScoutBrowserField.this.getSwingContainer().revalidate();
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error("Error occured while attaching SWT.", (Throwable)e);
        }
    }

    private void detachSwtSafe() {
        try {
            if (!this.isSwtAttached()) {
                return;
            }
            swtDisplay.syncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SwingScoutBrowserField.this.runSwtCommandsInsideSwtThread();
                    Object object = SwingScoutBrowserField.this.m_swtCommandQueueLock;
                    synchronized (object) {
                        SwingScoutBrowserField.this.m_swtCommandQueue.clear();
                    }
                    DisposeUtil.disposeSafe((Control)SwingScoutBrowserField.this.m_swtBrowser);
                    SwingScoutBrowserField.this.m_swtBrowser = null;
                    DisposeUtil.closeAndDisposeSafe(SwingScoutBrowserField.this.m_swtShell);
                    SwingScoutBrowserField.this.m_swtShell = null;
                }
            });
        }
        catch (Exception e) {
            LOG.error("Error occured while detaching SWT.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swtAsyncExec(RunnableWithException<?> command) {
        Object object = this.m_swtCommandQueueLock;
        synchronized (object) {
            this.m_swtCommandQueue.add(command);
        }
        swtDisplay.asyncExec(new Runnable(){

            @Override
            public void run() {
                SwingScoutBrowserField.this.runSwtCommandsInsideSwtThread();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSwtCommandsInsideSwtThread() {
        if (this.isSwtAttached() && this.getScoutObject() != null) {
            while (true) {
                Object object = this.m_swtCommandQueueLock;
                synchronized (object) {
                    if (this.m_swtCommandQueue.isEmpty()) {
                        break;
                    }
                    RunnableWithException<?> r = this.m_swtCommandQueue.remove(0);
                    try {
                        r.run();
                    }
                    catch (Throwable e) {
                        LOG.error("running command in COM", e);
                    }
                }
            }
        }
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if ("location".equals(name)) {
            this.setLocationFromScout();
        }
    }

    protected void setValueFromScout(Object o) {
        this.setLocationFromScout();
    }

    protected void setLocationFromScout() {
        String location;
        block9: {
            location = ((IBrowserField)this.getScoutObject()).getLocation();
            RemoteFile r = (RemoteFile)((IBrowserField)this.getScoutObject()).getValue();
            if (location == null && r != null && r.exists()) {
                try {
                    if (this.m_tempDir == null) {
                        try {
                            this.m_tempDir = IOUtility.createTempDirectory((String)"html");
                        }
                        catch (ProcessingException e) {
                            LOG.error("create temporary folder", (Throwable)e);
                        }
                    }
                    if (r.getName().matches(".*\\.(zip|jar)")) {
                        r.writeZipContentToDirectory(this.m_tempDir);
                        String simpleName = r.getName().replaceAll("\\.(zip|jar)", ".htm");
                        File[] fileArray = this.m_tempDir.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File f = fileArray[n2];
                            if (f.getName().startsWith(simpleName)) {
                                location = f.toURI().toURL().toExternalForm();
                                break block9;
                            }
                            ++n2;
                        }
                        break block9;
                    }
                    File f = new File(this.m_tempDir, r.getName());
                    r.writeData(f);
                    location = f.toURI().toURL().toExternalForm();
                }
                catch (Throwable t) {
                    LOG.error("preparing html content for " + r, t);
                }
            }
        }
        this.m_currentLocation = location;
        this.swtAsyncExec(new RunnableWithException<Object>(){

            public Object run() throws Throwable {
                if (SwingScoutBrowserField.this.m_currentLocation != null) {
                    SwingScoutBrowserField.this.getSwtBrowser().setUrl(SwingScoutBrowserField.this.m_currentLocation);
                } else {
                    SwingScoutBrowserField.this.getSwtBrowser().setText("");
                }
                return null;
            }
        });
    }

    protected boolean fireBeforeLocationChangedFromSwt(final String location) {
        final AtomicReference accept = new AtomicReference();
        ClientSyncJob job = new ClientSyncJob("fireBeforeLocationChangedFromSwt", this.getSwingEnvironment().getScoutSession()){

            protected void runVoid(IProgressMonitor monitor) {
                accept.set(((IBrowserField)SwingScoutBrowserField.this.getScoutObject()).getUIFacade().fireBeforeLocationChangedFromUI(location));
            }
        };
        job.schedule();
        try {
            job.join(10000L);
        }
        catch (InterruptedException interruptedException) {}
        return accept.get() != null ? (Boolean)accept.get() : false;
    }

    protected void fireAfterLocationChangedFromSwt(final String location) {
        ClientSyncJob job = new ClientSyncJob("fireAfterLocationChangedFromSwt", this.getSwingEnvironment().getScoutSession()){

            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                ((IBrowserField)SwingScoutBrowserField.this.getScoutObject()).getUIFacade().fireAfterLocationChangedFromUI(location);
            }
        };
        job.schedule();
    }

    protected Browser getSwtBrowser() {
        return this.m_swtBrowser;
    }

    private class P_CanvasEx
    extends Canvas {
        private static final long serialVersionUID = 1L;

        private P_CanvasEx() {
        }

        @Override
        public void removeNotify() {
            SwingScoutBrowserField.this.detachSwtSafe();
            super.removeNotify();
        }
    }

    private class P_HierarchyListener
    implements HierarchyListener {
        private P_HierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (e.getID() == 1400 && (e.getChangeFlags() & 2L) != 0L && e.getChanged() == SwingScoutBrowserField.this.m_canvas) {
                if (e.getChanged().isDisplayable()) {
                    SwingScoutBrowserField.this.attachSwtSafe();
                } else {
                    SwingScoutBrowserField.this.detachSwtSafe();
                }
            }
        }
    }

    private static class StaticDisplayDispatcher
    extends Thread {
        private Display m_display;

        public StaticDisplayDispatcher() {
            super("SWT HTML Display Dispatcher");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            this.m_display = Display.getDefault();
            if (this.m_display.getThread() == Thread.currentThread()) {
                while (!this.m_display.isDisposed()) {
                    if (this.m_display.readAndDispatch()) continue;
                    this.m_display.sleep();
                }
            }
        }

        Display getDisplay() {
            while (this.m_display == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.m_display;
        }
    }
}

