/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.CSSPatch;
import org.eclipse.scout.commons.HTMLUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.busy.IBusyHandler;
import org.eclipse.scout.rt.client.busy.IBusyManagerService;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.htmlfield.IHtmlField;
import org.eclipse.scout.rt.client.ui.form.fields.mailfield.IMailField;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.FormFieldFactory;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingIconLocator;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.ISwingScoutAction;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.concurrency.SwingScoutSynchronizer;
import org.eclipse.scout.rt.ui.swing.ext.IEmbeddedFrameProviderService;
import org.eclipse.scout.rt.ui.swing.ext.JDialogEx;
import org.eclipse.scout.rt.ui.swing.ext.JFrameEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelTop;
import org.eclipse.scout.rt.ui.swing.ext.busy.SwingBusyHandler;
import org.eclipse.scout.rt.ui.swing.focus.SwingScoutFocusTraversalPolicy;
import org.eclipse.scout.rt.ui.swing.form.ISwingScoutForm;
import org.eclipse.scout.rt.ui.swing.form.SwingScoutForm;
import org.eclipse.scout.rt.ui.swing.form.fields.ISwingScoutFormField;
import org.eclipse.scout.rt.ui.swing.form.fields.OnFieldLabelDecorator;
import org.eclipse.scout.rt.ui.swing.form.fields.tabbox.ISwingScoutTabItem;
import org.eclipse.scout.rt.ui.swing.form.fields.tabbox.SwingScoutTabItem;
import org.eclipse.scout.rt.ui.swing.inject.ActionInjector;
import org.eclipse.scout.rt.ui.swing.inject.AppendActionsInjector;
import org.eclipse.scout.rt.ui.swing.inject.InitLookAndFeelInjector;
import org.eclipse.scout.rt.ui.swing.inject.UIDefaultsInjector;
import org.eclipse.scout.rt.ui.swing.window.ISwingScoutBoundsProvider;
import org.eclipse.scout.rt.ui.swing.window.ISwingScoutView;
import org.eclipse.scout.rt.ui.swing.window.desktop.ISwingScoutDesktop;
import org.eclipse.scout.rt.ui.swing.window.desktop.ISwingScoutRootFrame;
import org.eclipse.scout.rt.ui.swing.window.desktop.SwingScoutDesktop;
import org.eclipse.scout.rt.ui.swing.window.desktop.SwingScoutRootFrame;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.MultiSplitLayoutConstraints;
import org.eclipse.scout.rt.ui.swing.window.desktop.tray.ISwingScoutTray;
import org.eclipse.scout.rt.ui.swing.window.desktop.tray.SwingScoutTray;
import org.eclipse.scout.rt.ui.swing.window.dialog.SwingScoutDialog;
import org.eclipse.scout.rt.ui.swing.window.filechooser.ISwingScoutFileChooser;
import org.eclipse.scout.rt.ui.swing.window.filechooser.SwingScoutFileChooser;
import org.eclipse.scout.rt.ui.swing.window.frame.SwingScoutFrame;
import org.eclipse.scout.rt.ui.swing.window.internalframe.SwingScoutInternalFrame;
import org.eclipse.scout.rt.ui.swing.window.messagebox.ISwingScoutMessageBox;
import org.eclipse.scout.rt.ui.swing.window.messagebox.SwingScoutMessageBox;
import org.eclipse.scout.rt.ui.swing.window.popup.SwingScoutPopup;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractSwingEnvironment
implements ISwingEnvironment {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractSwingEnvironment.class);
    private boolean m_initialized;
    private IClientSession m_scoutSession;
    private SwingScoutSynchronizer m_synchronizer;
    private SwingIconLocator m_iconLocator;
    private ISwingScoutTray m_trayComposite;
    private Frame m_rootFrame;
    private FormFieldFactory m_formFieldFactory;
    private ISwingScoutRootFrame m_rootComposite;
    private final PropertyChangeSupport m_propertySupport = new PropertyChangeSupport(this);
    private final WeakHashMap<IForm, ISwingScoutForm> m_standaloneFormComposites;
    private Component m_popupOwner;
    private Rectangle m_popupOwnerBounds;
    private final Object m_immediateSwingJobsLock = new Object();
    private final List<Runnable> m_immediateSwingJobs = new ArrayList<Runnable>();

    public AbstractSwingEnvironment() {
        AbstractSwingEnvironment.checkThread();
        this.m_standaloneFormComposites = new WeakHashMap();
        this.init();
    }

    @Override
    public void init() {
        AbstractSwingEnvironment.checkThread();
        if (!this.m_initialized) {
            this.m_initialized = true;
            System.setProperty("sun.java2d.noddraw", "true");
            System.getProperty("sun.java2d.noddraw", "true");
            this.initLookAndFeel(System.getProperties());
            this.interceptUIDefaults(UIManager.getDefaults());
            CSSPatch.apply();
            this.m_rootFrame = this.createRootFrame();
            if (this.m_rootFrame != null) {
                this.setWindowIcon(this.m_rootFrame);
            }
            this.m_synchronizer = new SwingScoutSynchronizer(this);
        }
    }

    protected void initLookAndFeel(Properties initProperties) {
        new InitLookAndFeelInjector().inject(initProperties);
    }

    @Override
    public Icon getIcon(String name) {
        Icon icon = this.m_iconLocator.getIcon(name);
        if (icon == null) {
            icon = Activator.getIcon(name);
        }
        return icon;
    }

    @Override
    public Image getImage(String name) {
        Image image = this.m_iconLocator.getImage(name);
        if (image == null) {
            image = Activator.getImage(name);
        }
        return image;
    }

    public List<Image> getImages(String ... names) {
        ArrayList<Image> result = new ArrayList<Image>();
        if (names != null) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                Image img;
                String name = stringArray[n2];
                if (name != null && (img = this.getImage(name)) != null) {
                    result.add(img);
                }
                ++n2;
            }
        }
        return result;
    }

    protected void setWindowIcon(Window window) {
        Image legacyIcon = Activator.getImage("window");
        if (legacyIcon != null) {
            window.setIconImage(legacyIcon);
        } else {
            ArrayList<Image> icons = new ArrayList<Image>();
            String[] stringArray = new String[]{"window16", "window32", "window48", "window256"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                Image img;
                String name = stringArray[n2];
                if (name != null && (img = Activator.getImage(name)) != null) {
                    icons.add(img);
                }
                ++n2;
            }
            window.setIconImages(icons);
        }
    }

    protected ISwingScoutTray createTray(IDesktop desktop) {
        SwingScoutTray ui = new SwingScoutTray();
        ui.createField(desktop, this);
        this.decorate(desktop, ui);
        return ui;
    }

    @Override
    public ISwingScoutTray getTrayComposite() {
        return this.m_trayComposite;
    }

    @Override
    public int getFormColumnWidth() {
        return 360;
    }

    @Override
    public int getFormColumnGap() {
        return 12;
    }

    @Override
    public int getFormRowHeight() {
        return 23;
    }

    @Override
    public int getFormRowGap() {
        return 6;
    }

    @Override
    public int getFieldLabelWidth() {
        return 130;
    }

    @Override
    public int getProcessButtonHeight() {
        return 28;
    }

    @Override
    public int getIconButtonSize() {
        return 23;
    }

    @Override
    public int getDropDownButtonWidth() {
        return 35;
    }

    @Override
    public void interceptUIDefaults(UIDefaults defaults) {
        new UIDefaultsInjector().inject(defaults);
    }

    @Override
    public Frame getRootFrame() {
        AbstractSwingEnvironment.checkThread();
        return this.m_rootFrame;
    }

    @Override
    public ISwingScoutRootFrame getRootComposite() {
        return this.m_rootComposite;
    }

    protected boolean execBeforeDesktop(IClientSession clientSession) throws Exception {
        return true;
    }

    @Override
    public void showGUI(IClientSession session) {
        IDesktop desktop;
        AbstractSwingEnvironment.checkThread();
        this.m_scoutSession = session;
        SwingUtility.setNlsTexts(this.m_scoutSession.getTexts());
        if (this.m_rootFrame == null) {
            this.m_scoutSession.stopSession();
            return;
        }
        this.m_iconLocator = this.createIconLocator();
        try {
            if (!this.execBeforeDesktop(session)) {
                System.exit(0);
            }
        }
        catch (Exception e) {
            LOG.error("GUI initialization failed", (Throwable)e);
            System.exit(0);
        }
        if ((desktop = this.m_scoutSession.getDesktop()) != null) {
            IForm f;
            this.m_scoutSession.getDesktop().addDesktopListener(new DesktopListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void desktopChanged(final DesktopEvent e) {
                    switch (e.getType()) {
                        case 600: {
                            Runnable t = new Runnable(){

                                @Override
                                public void run() {
                                    AbstractSwingEnvironment.this.showStandaloneForm(null, e.getForm());
                                }
                            };
                            AbstractSwingEnvironment.this.invokeSwingLater(t);
                            break;
                        }
                        case 610: {
                            Runnable t = new Runnable(){

                                @Override
                                public void run() {
                                    AbstractSwingEnvironment.this.hideStandaloneForm(e.getForm());
                                }
                            };
                            AbstractSwingEnvironment.this.invokeSwingLater(t);
                            break;
                        }
                        case 620: {
                            Runnable t = new Runnable(){

                                @Override
                                public void run() {
                                    AbstractSwingEnvironment.this.activateStandaloneForm(e.getForm());
                                }
                            };
                            AbstractSwingEnvironment.this.invokeSwingLater(t);
                            break;
                        }
                        case 700: {
                            Runnable t = new Runnable(){

                                @Override
                                public void run() {
                                    AbstractSwingEnvironment.this.showMessageBox(null, e.getMessageBox());
                                }
                            };
                            AbstractSwingEnvironment.this.invokeSwingLater(t);
                            break;
                        }
                        case 910: {
                            Runnable t = new Runnable(){

                                @Override
                                public void run() {
                                    AbstractSwingEnvironment.this.showFileChooser(null, e.getFileChooser());
                                }
                            };
                            AbstractSwingEnvironment.this.invokeSwingLater(t);
                            break;
                        }
                        case 1000: {
                            final Object lock = new Object();
                            Runnable t = new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    try {
                                        IFormField f = AbstractSwingEnvironment.this.findFocusOwnerField();
                                        if (f != null) {
                                            e.setFocusedField(f);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object object = lock;
                                        synchronized (object) {
                                            lock.notifyAll();
                                        }
                                        throw throwable;
                                    }
                                    Object object = lock;
                                    synchronized (object) {
                                        lock.notifyAll();
                                    }
                                }
                            };
                            Object object = lock;
                            synchronized (object) {
                                AbstractSwingEnvironment.this.invokeSwingLater(t);
                                try {
                                    lock.wait(2000L);
                                }
                                catch (InterruptedException interruptedException) {}
                                break;
                            }
                        }
                    }
                }
            });
            this.m_rootComposite = this.createRootComposite(this.getRootFrame(), this.m_scoutSession.getDesktop());
            this.m_rootComposite.showSwingFrame();
            IForm[] iFormArray = desktop.getViewStack();
            int n = iFormArray.length;
            int n2 = 0;
            while (n2 < n) {
                f = iFormArray[n2];
                if (f.isAutoAddRemoveOnDesktop()) {
                    this.showStandaloneForm(this.getRootFrame(), f);
                }
                ++n2;
            }
            if (desktop.isTrayVisible()) {
                this.m_trayComposite = this.createTray(desktop);
            }
            iFormArray = desktop.getDialogStack();
            n = iFormArray.length;
            n2 = 0;
            while (n2 < n) {
                f = iFormArray[n2];
                if (f.isAutoAddRemoveOnDesktop()) {
                    this.showStandaloneForm(this.getRootFrame(), f);
                }
                ++n2;
            }
            iFormArray = desktop.getMessageBoxStack();
            n = iFormArray.length;
            n2 = 0;
            while (n2 < n) {
                IForm mb = iFormArray[n2];
                this.showMessageBox(this.getRootFrame(), (IMessageBox)mb);
                ++n2;
            }
            new ClientSyncJob("Desktop opened", session){

                protected void runVoid(IProgressMonitor monitor) throws Throwable {
                    desktop.getUIFacade().fireDesktopOpenedFromUI();
                    desktop.getUIFacade().fireGuiAttached();
                }
            }.schedule();
        }
        this.attachBusyHandler();
    }

    protected SwingBusyHandler attachBusyHandler() {
        IBusyManagerService service = (IBusyManagerService)SERVICES.getService(IBusyManagerService.class);
        if (service == null) {
            return null;
        }
        SwingBusyHandler handler = this.createBusyHandler();
        service.register(this.getScoutSession(), (IBusyHandler)handler);
        return handler;
    }

    protected SwingBusyHandler createBusyHandler() {
        return new SwingBusyHandler(this.getScoutSession());
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }

    @Override
    public IClientSession getScoutSession() {
        return this.m_scoutSession;
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public void setBusyFromSwing(boolean b) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postImmediateSwingJob(Runnable r) {
        Object object = this.m_immediateSwingJobsLock;
        synchronized (object) {
            this.m_immediateSwingJobs.add(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchImmediateSwingJobs() {
        ArrayList<Runnable> list;
        Object object = this.m_immediateSwingJobsLock;
        synchronized (object) {
            list = new ArrayList<Runnable>(this.m_immediateSwingJobs);
            this.m_immediateSwingJobs.clear();
        }
        for (Runnable r : list) {
            try {
                r.run();
            }
            catch (Throwable t) {
                LOG.warn("running " + r, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobEx invokeScoutLater(Runnable j, long cancelTimeout) {
        Object object = this.m_immediateSwingJobsLock;
        synchronized (object) {
            this.m_immediateSwingJobs.clear();
        }
        return this.m_synchronizer.invokeScoutLater(j, cancelTimeout);
    }

    @Override
    public void invokeSwingLater(Runnable j) {
        this.m_synchronizer.invokeSwingLater(j);
    }

    protected SwingIconLocator createIconLocator() {
        return new SwingIconLocator(this.getScoutSession().getIconLocator());
    }

    @Override
    public Frame createRootFrame() {
        IEmbeddedFrameProviderService es;
        Frame rootFrame = null;
        long hWnd = 0L;
        Pattern pat = Pattern.compile("hWnd=([-]?[0-9]+)");
        String[] stringArray = Platform.getApplicationArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Matcher m = pat.matcher(s.trim());
            if (m.matches()) {
                hWnd = Long.parseLong(m.group(1));
                break;
            }
            ++n2;
        }
        if (hWnd != 0L && (es = (IEmbeddedFrameProviderService)SERVICES.getService(IEmbeddedFrameProviderService.class)) != null) {
            try {
                rootFrame = es.createEmbeddedFrame(hWnd);
                rootFrame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        AbstractSwingEnvironment.this.m_rootFrame = null;
                        if (AbstractSwingEnvironment.this.m_scoutSession != null) {
                            AbstractSwingEnvironment.this.m_scoutSession.stopSession();
                        }
                    }
                });
            }
            catch (Throwable t) {
                LOG.error("create embedded frame using " + es.getClass(), t);
            }
        }
        if (rootFrame == null) {
            rootFrame = new JFrameEx();
            ((JFrame)rootFrame).getRootPane().setName("Synth.Frame");
            ((JFrameEx)rootFrame).setAutoCorrectSize(false);
        }
        if (rootFrame instanceof RootPaneContainer) {
            this.decorateAppZone((RootPaneContainer)((Object)rootFrame));
        }
        return rootFrame;
    }

    @Override
    public ISwingScoutRootFrame createRootComposite(Frame rootFrame, IDesktop desktop) {
        SwingScoutRootFrame ui = new SwingScoutRootFrame(rootFrame);
        ui.createField(desktop, this);
        this.decorate(desktop, ui);
        return ui;
    }

    protected void decorate(Object scoutObject, Object swingScoutComposite) {
    }

    protected void decorateAppZone(RootPaneContainer root) {
        String zone = Activator.getDefault().getBundle().getBundleContext().getProperty("app.zone");
        if (zone != null) {
            if (zone.equals("int") || zone.equals("integration")) {
                root.getRootPane().setBorder(new LineBorder(Color.yellow, 3));
            } else if (zone.equals("test")) {
                root.getRootPane().setBorder(new LineBorder(Color.orange, 3));
            } else if (zone.equals("dev") || zone.equals("development")) {
                root.getRootPane().setBorder(new LineBorder(Color.red, 3));
            }
        }
    }

    protected Window getOwnerForChildWindow(Component parent) {
        if (parent != null) {
            if (parent instanceof Window) {
                return (Window)parent;
            }
            Window w = SwingUtilities.getWindowAncestor(parent);
            if (w != null) {
                return w;
            }
        }
        return SwingUtility.getOwnerForChildWindow();
    }

    @Override
    public ISwingScoutDesktop createDesktop(Window owner, IDesktop desktop) {
        SwingScoutDesktop ui = new SwingScoutDesktop();
        ui.createField(desktop, this);
        this.decorate(desktop, ui);
        return ui;
    }

    @Override
    public void showStandaloneForm(Component parent, IForm f) {
        if (f == null) {
            return;
        }
        ISwingScoutView view = null;
        ISwingScoutForm formComposite = this.m_standaloneFormComposites.get(f);
        if (formComposite != null) {
            view = formComposite.getView();
        }
        if (view != null) {
            return;
        }
        Window w = this.getOwnerForChildWindow(parent);
        switch (f.getDisplayHint()) {
            case 0: {
                if (f.isModal() || w instanceof Dialog) {
                    view = this.createDialog(w, f);
                    break;
                }
                view = this.createFrame(w, f);
                break;
            }
            case 20: {
                Object constraints = this.getViewLayoutConstraintsFor(f);
                view = this.createView(constraints, f);
                break;
            }
            case 10: {
                view = this.createPopupWindow(w, f);
                if (view != null) break;
                LOG.error("showing popup for " + f + ", but there is neither a focus owner nor the property 'ISwingEnvironment.getPopupOwner()'");
                return;
            }
            case 12: {
                view = this.createPopupDialog(w, f);
                if (view != null) break;
                LOG.error("showing popup for " + f + ", but there is neither a focus owner nor the property 'ISwingEnvironment.getPopupOwner()'");
                return;
            }
        }
        if (view != null) {
            formComposite = this.createForm(view, f);
            this.m_standaloneFormComposites.put(f, formComposite);
            view.openView();
        }
    }

    @Override
    public void hideStandaloneForm(IForm f) {
        ISwingScoutForm formComposite;
        if (f != null && (formComposite = this.m_standaloneFormComposites.remove(f)) != null) {
            ISwingScoutView viewComposite = formComposite.getView();
            formComposite.detachSwingView();
            if (viewComposite != null) {
                viewComposite.closeView();
            }
        }
    }

    @Override
    public ISwingScoutForm[] getStandaloneFormComposites() {
        ArrayList<ISwingScoutForm> list = new ArrayList<ISwingScoutForm>();
        for (ISwingScoutForm f : this.m_standaloneFormComposites.values()) {
            if (f == null) continue;
            list.add(f);
        }
        return list.toArray(new ISwingScoutForm[list.size()]);
    }

    @Override
    public ISwingScoutForm getStandaloneFormComposite(IForm f) {
        if (f != null) {
            ISwingScoutForm formComposite = this.m_standaloneFormComposites.get(f);
            return formComposite;
        }
        return null;
    }

    @Override
    public void activateStandaloneForm(IForm f) {
        ISwingScoutForm formComposite;
        if (f != null && (formComposite = this.m_standaloneFormComposites.get(f)) != null) {
            RootPaneContainer root = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, formComposite.getSwingFormPane()));
            if (root instanceof JInternalFrame) {
                try {
                    ((JInternalFrame)root).setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (root instanceof Window) {
                ((Window)((Object)root)).requestFocusInWindow();
            }
        }
    }

    @Override
    public Object getViewLayoutConstraintsFor(IForm f) {
        String viewId = f.getDisplayViewId();
        return this.getViewLayoutConstraintsFor(viewId);
    }

    @Override
    public Object getViewLayoutConstraintsFor(String viewId) {
        if ("OUTLINE_SELECTOR".equalsIgnoreCase(viewId)) {
            viewId = "SW";
        } else if ("OUTLINE".equalsIgnoreCase(viewId)) {
            viewId = "NW";
        } else if ("PAGE_DETAIL".equalsIgnoreCase(viewId)) {
            viewId = "N";
        } else if ("PAGE_TABLE".equalsIgnoreCase(viewId)) {
            viewId = "C";
        } else if ("PAGE_SEARCH".equalsIgnoreCase(viewId)) {
            viewId = "S";
        }
        if (viewId == null) {
            return new MultiSplitLayoutConstraints(1, 1, 0, new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
        }
        if (viewId.equalsIgnoreCase("N")) {
            return new MultiSplitLayoutConstraints(0, 1, 40, new float[]{7.0f, 9.0f, 7.0f, 6.0f, 6.0f, 5.0f, 4.0f, 3.0f, 4.0f});
        }
        if (viewId.equalsIgnoreCase("NE")) {
            return new MultiSplitLayoutConstraints(0, 2, 70, new float[]{0.0f, 0.0f, 9.0f, 0.0f, 0.0f, 8.0f, 0.0f, 0.0f, 5.0f});
        }
        if (viewId.equalsIgnoreCase("E")) {
            return new MultiSplitLayoutConstraints(1, 2, 80, new float[]{0.0f, 0.0f, 8.0f, 0.0f, 0.0f, 9.0f, 0.0f, 0.0f, 8.0f});
        }
        if (viewId.equalsIgnoreCase("SE")) {
            return new MultiSplitLayoutConstraints(2, 2, 90, new float[]{0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 7.0f, 0.0f, 0.0f, 9.0f});
        }
        if (viewId.equalsIgnoreCase("S")) {
            return new MultiSplitLayoutConstraints(2, 1, 60, new float[]{5.0f, 3.0f, 4.0f, 5.0f, 5.0f, 4.0f, 6.0f, 9.0f, 7.0f});
        }
        if (viewId.equalsIgnoreCase("SW")) {
            return new MultiSplitLayoutConstraints(2, 0, 10, new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 9.0f, 0.0f, 0.0f});
        }
        if (viewId.equalsIgnoreCase("W")) {
            return new MultiSplitLayoutConstraints(1, 0, 20, new float[]{8.0f, 0.0f, 0.0f, 9.0f, 0.0f, 0.0f, 8.0f, 0.0f, 0.0f});
        }
        if (viewId.equalsIgnoreCase("NW")) {
            return new MultiSplitLayoutConstraints(0, 0, 30, new float[]{9.0f, 0.0f, 0.0f, 8.0f, 0.0f, 0.0f, 7.0f, 0.0f, 0.0f});
        }
        if (viewId.equalsIgnoreCase("C")) {
            return new MultiSplitLayoutConstraints(1, 1, 50, new float[]{6.0f, 6.0f, 6.0f, 7.0f, 9.0f, 6.0f, 5.0f, 6.0f, 6.0f});
        }
        LOG.warn("unexpected viewId \"" + viewId + "\"");
        return new MultiSplitLayoutConstraints(1, 1, 50, new float[]{6.0f, 6.0f, 6.0f, 7.0f, 9.0f, 6.0f, 6.0f, 6.0f, 6.0f});
    }

    @Override
    public IFormField findFocusOwnerField() {
        Component comp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        while (comp instanceof JComponent) {
            IPropertyObserver o = SwingScoutComposite.getScoutModelOnWidget(comp);
            if (o instanceof IFormField) {
                return (IFormField)o;
            }
            comp = comp.getParent();
        }
        return null;
    }

    @Override
    public void showMessageBox(Component parent, IMessageBox mb) {
        ISwingScoutMessageBox mbox = this.createMessageBox(this.getOwnerForChildWindow(parent), mb);
        mbox.showSwingMessageBox();
    }

    @Override
    public ISwingScoutMessageBox createMessageBox(Window w, IMessageBox mb) {
        SwingScoutMessageBox ui = new SwingScoutMessageBox(w);
        ui.createField(mb, this);
        ui.setName("Synth.Dialog");
        this.decorate(mb, ui);
        return ui;
    }

    @Override
    public void showFileChooser(Component parent, IFileChooser fc) {
        ISwingScoutFileChooser sfc = this.createFileChooser(this.getOwnerForChildWindow(parent), fc);
        sfc.showFileChooser();
    }

    @Override
    public ISwingScoutFileChooser createFileChooser(Window w, IFileChooser fc) {
        SwingScoutFileChooser ui = new SwingScoutFileChooser(this, fc, w, false);
        this.decorate(fc, ui);
        return ui;
    }

    @Override
    public ISwingScoutFormField createFormField(JComponent parent, IFormField field) {
        if (this.m_formFieldFactory == null) {
            this.m_formFieldFactory = new FormFieldFactory();
        }
        ISwingScoutFormField<?> ui = this.m_formFieldFactory.createFormField(parent, field, this);
        this.decorate(field, ui);
        return ui;
    }

    @Override
    public JDialogEx createJDialogEx(Dialog swingParent) {
        return new JDialogEx(swingParent);
    }

    @Override
    public JDialogEx createJDialogEx(Frame swingParent) {
        return new JDialogEx(swingParent);
    }

    @Override
    public ISwingScoutView createDialog(Window owner, IForm form) {
        P_FormBoundsProvider boundsProvider = null;
        if (form.isCacheBounds()) {
            boundsProvider = new P_FormBoundsProvider(form);
        }
        SwingScoutDialog ui = new SwingScoutDialog(this, owner, boundsProvider, form.isModal());
        ui.setName("Synth.Dialog");
        Window w = SwingUtilities.getWindowAncestor(ui.getSwingContentPane());
        if (w != null) {
            this.setWindowIcon(w);
        }
        this.decorate(form, ui);
        if (w instanceof RootPaneContainer) {
            this.decorateAppZone((RootPaneContainer)((Object)w));
        }
        return ui;
    }

    @Override
    public ISwingScoutView createFrame(Window owner, IForm form) {
        P_FormBoundsProvider boundsProvider = null;
        if (form.isCacheBounds()) {
            boundsProvider = new P_FormBoundsProvider(form);
        }
        SwingScoutFrame ui = new SwingScoutFrame(this, boundsProvider);
        ui.setName("Synth.Frame");
        Window w = SwingUtilities.getWindowAncestor(ui.getSwingContentPane());
        if (w != null) {
            this.setWindowIcon(w);
        }
        this.decorate(form, ui);
        if (w instanceof RootPaneContainer) {
            this.decorateAppZone((RootPaneContainer)((Object)w));
        }
        return ui;
    }

    @Override
    public ISwingScoutView createPopupDialog(Window parentWindow, IForm form) {
        Component owner = this.getPopupOwner();
        if (owner == null) {
            owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        if (owner == null) {
            return null;
        }
        Rectangle ownerBounds = this.getPopupOwnerBounds();
        if (ownerBounds == null) {
            ownerBounds = owner.getBounds();
        }
        final Rectangle ownerBoundsFinal = ownerBounds;
        ISwingScoutBoundsProvider boundsProvider = new ISwingScoutBoundsProvider(){

            @Override
            public Rectangle getBounds() {
                return ownerBoundsFinal;
            }

            @Override
            public void storeBounds(Rectangle bounds) {
            }
        };
        SwingScoutDialog ui = new SwingScoutDialog(this, parentWindow, boundsProvider);
        ui.setName("Synth.Dialog");
        Window w = SwingUtilities.getWindowAncestor(ui.getSwingContentPane());
        if (w != null) {
            this.setWindowIcon(w);
        }
        this.decorate(form, ui);
        return ui;
    }

    @Override
    public ISwingScoutView createPopupWindow(Window parentWindow, IForm form) {
        Component owner = this.getPopupOwner();
        if (owner == null) {
            owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        if (owner == null) {
            return null;
        }
        Rectangle ownerBounds = this.getPopupOwnerBounds();
        if (ownerBounds == null) {
            ownerBounds = owner.getBounds();
        }
        final SwingScoutPopup ui = new SwingScoutPopup(this, owner, ownerBounds);
        SwingUtilities.getWindowAncestor(owner).addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                e.getWindow().removeWindowListener(this);
                ui.closeView();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                e.getWindow().removeWindowListener(this);
                ui.closeView();
            }
        });
        SwingUtilities.getWindowAncestor(owner).addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                e.getWindow().removeWindowFocusListener(this);
                ui.closeView();
            }
        });
        ui.setName("Synth.Popup");
        this.decorate(form, ui);
        return ui;
    }

    @Override
    public ISwingScoutView createView(Object viewConstraints, IForm form) {
        P_FormBoundsProvider boundsProvider = null;
        if (form.isCacheBounds()) {
            boundsProvider = new P_FormBoundsProvider(form);
        }
        ISwingScoutView ui = this.createInternalFrame(viewConstraints, form, boundsProvider);
        ui.setName("Synth.View");
        this.decorate(form, ui);
        return ui;
    }

    protected ISwingScoutView createInternalFrame(Object viewConstraints, IForm form, ISwingScoutBoundsProvider boundsProvider) {
        return new SwingScoutInternalFrame(this, viewConstraints, boundsProvider);
    }

    @Override
    public ISwingScoutForm createForm(JComponent parent, IForm model) {
        SwingScoutForm ui = new SwingScoutForm(this, model);
        ui.createField(model, this);
        this.decorate(model, ui);
        return ui;
    }

    @Override
    public ISwingScoutForm createForm(ISwingScoutView targetViewComposite, IForm model) {
        SwingScoutForm ui = new SwingScoutForm(this, targetViewComposite, model);
        ui.createField(model, this);
        this.decorate(model, ui);
        return ui;
    }

    @Override
    public ISwingScoutTabItem createTabItem(JComponent parent, IGroupBox field) {
        SwingScoutTabItem ui = new SwingScoutTabItem();
        ui.createField(field, this);
        this.decorate(field, ui);
        return ui;
    }

    @Override
    public void appendActions(JComponent parent, List<? extends IAction> actions) {
        new AppendActionsInjector().inject(this, parent, actions);
    }

    @Override
    public ISwingScoutAction createAction(JComponent parent, IAction action) {
        ISwingScoutAction<?> ui = new ActionInjector().inject(this, parent, action);
        this.decorate(action, ui);
        return ui;
    }

    @Override
    public boolean acceptAsFocusTarget(Component comp) {
        AbstractSwingEnvironment.checkThread();
        return new SwingScoutFocusTraversalPolicy().accept(comp);
    }

    @Override
    public JStatusLabelEx createStatusLabel() {
        return this.createStatusLabel(null);
    }

    @Override
    public JStatusLabelEx createStatusLabel(IFormField formField) {
        JStatusLabelEx ui = null;
        ui = formField != null && formField.getLabelPosition() == 4 ? new JStatusLabelTop() : new JStatusLabelEx();
        ui.setName("Synth.StatusLabel");
        return ui;
    }

    @Override
    public OnFieldLabelDecorator createOnFieldLabelDecorator(JComponent c, boolean mandatory) {
        return new OnFieldLabelDecorator(c, mandatory);
    }

    @Override
    public JComponent createLogo() {
        JLabel logo = new JLabel();
        logo.setIcon(Activator.getIcon("logo"));
        return logo;
    }

    @Override
    public Component getPopupOwner() {
        return this.m_popupOwner;
    }

    @Override
    public Rectangle getPopupOwnerBounds() {
        return this.m_popupOwnerBounds;
    }

    @Override
    public void setPopupOwner(Component owner, Rectangle ownerBounds) {
        this.m_popupOwner = owner;
        this.m_popupOwnerBounds = ownerBounds;
    }

    @Override
    public String styleHtmlText(ISwingScoutFormField<?> uiComposite, String rawHtml) {
        String cleanHtml = rawHtml;
        if (cleanHtml == null) {
            cleanHtml = "";
        }
        if (uiComposite.getScoutObject() instanceof IHtmlField) {
            IHtmlField htmlField = (IHtmlField)uiComposite.getScoutObject();
            if (htmlField.isHtmlEditor()) {
                if (!StringUtility.hasText((String)cleanHtml)) {
                    cleanHtml = "<html><head></head><body></body></html>";
                }
            } else {
                cleanHtml = HTMLUtility.cleanupHtml((String)cleanHtml, (boolean)false, (boolean)true, (HTMLUtility.DefaultFont)this.createDefaultFontSettings(uiComposite.getSwingField()));
            }
        } else if (uiComposite.getScoutObject() instanceof IMailField) {
            cleanHtml = HTMLUtility.cleanupHtml((String)cleanHtml, (boolean)false, (boolean)true, (HTMLUtility.DefaultFont)this.createDefaultFontSettings(uiComposite.getSwingField()));
        }
        return cleanHtml;
    }

    protected HTMLUtility.DefaultFont createDefaultFontSettings(JComponent component) {
        Font f = component.getFont();
        Color color = component.getForeground();
        HTMLUtility.DefaultFont defaultFont = new HTMLUtility.DefaultFont();
        defaultFont.setFamilies(new String[]{f.getFamily(), "sans-serif"});
        defaultFont.setSize(f.getSize());
        defaultFont.setSizeUnit("pt");
        defaultFont.setForegroundColor(color.getRGB());
        return defaultFont;
    }

    private static void checkThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Must be called in swing thread");
        }
    }

    @Override
    public FormEvent[] fetchPendingPrintEvents(IForm form) {
        return new FormEvent[0];
    }

    private class P_FormBoundsProvider
    implements ISwingScoutBoundsProvider {
        private final IForm m_form;

        public P_FormBoundsProvider(IForm form) {
            this.m_form = form;
        }

        @Override
        public Rectangle getBounds() {
            Rectangle r = ClientUIPreferences.getInstance((IClientSession)AbstractSwingEnvironment.this.getScoutSession()).getFormBounds(this.m_form);
            if (r != null) {
                r = SwingUtility.validateRectangleOnScreen(r, false, false);
            }
            return r;
        }

        @Override
        public void storeBounds(Rectangle bounds) {
            ClientUIPreferences.getInstance((IClientSession)AbstractSwingEnvironment.this.getScoutSession()).setFormBounds(this.m_form, bounds);
        }
    }
}

