/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.table;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;
import org.eclipse.scout.rt.ui.swing.basic.table.SwingTableColumn;
import org.eclipse.scout.rt.ui.swing.ext.JTableEx;

class SwingTable
extends JTableEx {
    private static final long serialVersionUID = 1L;

    public void setOptimalColumnWidths() {
        TableColumnModel tcm = this.getColumnModel();
        int c = 0;
        int nc = this.getColumnCount();
        while (c < nc) {
            TableColumn tc = tcm.getColumn(c);
            this.setOptimalColumnWidth(tc);
            ++c;
        }
    }

    public void setOptimalColumnWidth(TableColumn tc) {
        int w;
        int modelIndex = tc.getModelIndex();
        int dw = this.getIntercellSpacing().width;
        Insets is = new Insets(0, 0, 0, 0);
        int wmax = 16;
        if (this.getTableHeader() != null) {
            Component hcomp = this.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(this, tc.getHeaderValue(), false, false, 0, modelIndex);
            wmax = SwingLayoutUtility.getSize((Component)hcomp, (int)1).width;
            if (hcomp instanceof JComponent) {
                ((JComponent)hcomp).getInsets(is);
                wmax += is.left + is.right;
            }
        }
        if (this.isDynamicRowHeight() && this.isColumnWrapped(tc) && (w = this.getConfiguredWidth(tc)) > wmax) {
            wmax = w;
        }
        int r = 0;
        int nr = this.getRowCount();
        while (r < nr) {
            TableCellRenderer renderer = this.getCellRenderer(r, modelIndex);
            if (renderer != null) {
                JComponent comp = (JComponent)this.prepareRenderer(renderer, r, modelIndex);
                int w2 = SwingLayoutUtility.getSize((Component)comp, (int)1).width;
                if (comp instanceof JComponent) {
                    comp.getInsets(is);
                    w2 += is.left + is.right;
                }
                if (w2 > wmax) {
                    wmax = w2;
                }
            }
            ++r;
        }
        tc.setPreferredWidth(wmax + dw);
    }

    private boolean isColumnWrapped(TableColumn tc) {
        if (!(tc instanceof SwingTableColumn)) {
            return false;
        }
        IColumn scoutColumn = ((SwingTableColumn)tc).getScoutColumn();
        if (!(scoutColumn instanceof AbstractStringColumn)) {
            return false;
        }
        return ((AbstractStringColumn)scoutColumn).isTextWrap();
    }

    private int getConfiguredWidth(TableColumn tc) {
        if (!(tc instanceof SwingTableColumn)) {
            return 0;
        }
        return ((SwingTableColumn)tc).getScoutColumn().getWidth();
    }
}

