/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.smartfield;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.BooleanHolder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartFieldProposalForm;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingPopupWorker;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.basic.document.BasicDocumentFilter;
import org.eclipse.scout.rt.ui.swing.ext.IDropDownButtonListener;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JTableEx;
import org.eclipse.scout.rt.ui.swing.ext.JTextFieldWithDropDownButton;
import org.eclipse.scout.rt.ui.swing.ext.JTreeEx;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.smartfield.ISwingScoutSmartField;
import org.eclipse.scout.rt.ui.swing.window.popup.SwingScoutDropDownPopup;
import org.eclipse.scout.rt.ui.swing.window.popup.SwingScoutPopup;

public class SwingScoutSmartField
extends SwingScoutValueFieldComposite<ISmartField<?>>
implements ISwingScoutSmartField {
    private static final long serialVersionUID = 1L;
    private SwingScoutDropDownPopup m_proposalPopup;
    private P_PendingProposalJob m_pendingProposalJob;
    private Object m_pendingProposalJobLock;

    @Override
    protected void initializeSwing() {
        this.m_pendingProposalJobLock = new Object();
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
        container.add(label);
        JTextComponent textField = this.createTextField(container);
        Document doc = textField.getDocument();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).setDocumentFilter(new BasicDocumentFilter(2000));
        }
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SwingScoutSmartField.this.handleSwingDocumentChanged(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingScoutSmartField.this.handleSwingDocumentChanged(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingScoutSmartField.this.handleSwingDocumentChanged(e);
            }
        });
        this.installSwingKeyStrokeDelegate(textField, SwingUtility.createKeystroke("UP"), "upArrow");
        this.installSwingKeyStrokeDelegate(textField, SwingUtility.createKeystroke("DOWN"), "downArrow");
        this.installSwingKeyStrokeDelegate(textField, SwingUtility.createKeystroke("PAGE_UP"), "pageUp");
        this.installSwingKeyStrokeDelegate(textField, SwingUtility.createKeystroke("PAGE_DOWN"), "pageDown");
        InputMap inputMap = textField.getInputMap(0);
        inputMap.put(SwingUtility.createKeystroke("F2"), "smartChooser");
        ActionMap actionMap = textField.getActionMap();
        actionMap.put("smartChooser", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingScoutSmartField.this.handleSwingSmartChooserAction(0L);
            }
        });
        this.setSwingContainer(container);
        this.setSwingLabel(label);
        this.setSwingField(textField);
        this.getSwingContainer().setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    protected JTextComponent createTextField(JComponent container) {
        JTextFieldWithDropDownButton textField = new JTextFieldWithDropDownButton(this.getSwingEnvironment());
        container.add(textField);
        textField.addDropDownButtonListener(new IDropDownButtonListener(){

            @Override
            public void iconClicked(Object source) {
                SwingScoutSmartField.this.getSwingTextField().requestFocus();
                SwingScoutSmartField.this.handleSwingSmartChooserAction(0L);
            }

            @Override
            public void menuClicked(Object source) {
                SwingScoutSmartField.this.handleSwingPopup((JComponent)source);
            }
        });
        return textField;
    }

    @Override
    public JTextComponent getSwingTextField() {
        return (JTextComponent)this.getSwingField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        ISmartField f = (ISmartField)this.getScoutObject();
        this.setIconIdFromScout(f.getIconId());
        this.setProposalFormFromScout(f.getProposalForm());
        if (this.getSwingField() instanceof JTextFieldWithDropDownButton) {
            ((JTextFieldWithDropDownButton)this.getSwingField()).setMenuEnabled(((ISmartField)this.getScoutObject()).hasMenus());
        }
    }

    @Override
    protected void detachScout() {
        this.hideProposalPopup();
        super.detachScout();
    }

    @Override
    protected void setHorizontalAlignmentFromScout(int scoutAlign) {
        if (this.getSwingTextField() instanceof JTextField) {
            int swingAlign = SwingUtility.createHorizontalAlignment(scoutAlign);
            ((JTextField)this.getSwingTextField()).setHorizontalAlignment(swingAlign);
        }
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        JTextComponent swingField = this.getSwingTextField();
        if (!CompareUtility.equals((Object)swingField.getText(), (Object)s)) {
            swingField.setText(s);
            if (swingField.hasFocus() && swingField.getDocument().getLength() > 0) {
                swingField.setCaretPosition(swingField.getDocument().getLength());
                swingField.moveCaretPosition(0);
            } else {
                swingField.setCaretPosition(0);
            }
        }
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        if (this.getSwingField() instanceof JTextFieldWithDropDownButton) {
            ((JTextFieldWithDropDownButton)this.getSwingField()).setDropDownButtonEnabled(b);
        }
    }

    protected void setIconIdFromScout(String iconId) {
        if (this.getSwingField() instanceof JTextFieldWithDropDownButton) {
            ((JTextFieldWithDropDownButton)this.getSwingField()).setIconGroup(new IconGroup(this.getSwingEnvironment(), iconId));
        }
    }

    protected void setProposalFormFromScout(ISmartFieldProposalForm form) {
        if (form != null) {
            this.showProposalPopup(form);
        } else {
            this.hideProposalPopup();
        }
    }

    @Override
    protected void setForegroundFromScout(String scoutColor) {
        JComponent fld = this.getSwingField();
        if (fld != null && scoutColor != null && fld instanceof JTextComponent) {
            this.setDisabledTextColor(SwingUtility.createColor(scoutColor), (JTextComponent)fld);
        }
        super.setForegroundFromScout(scoutColor);
    }

    protected void handleSwingDocumentChanged(DocumentEvent e) {
        this.setInputDirty(true);
        if (this.getUpdateSwingFromScoutLock().isReleased() && this.getSwingTextField().isShowing() && this.getSwingTextField().isFocusOwner()) {
            String text = this.getSwingTextField().getText();
            if (text == null || text.length() == 0) {
                if (this.m_proposalPopup != null) {
                    this.requestProposalSupportFromSwing(text, false, 0L);
                }
            } else {
                this.requestProposalSupportFromSwing(text, false, this.m_proposalPopup != null ? 200 : 0);
            }
        }
    }

    protected void installSwingKeyStrokeDelegate(JComponent textField, final KeyStroke k, String name) {
        textField.getInputMap(0).put(k, name);
        textField.getActionMap().put(name, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SwingScoutSmartField.this.getSwingTextField().isVisible() && SwingScoutSmartField.this.getSwingTextField().isEditable()) {
                    if (SwingScoutSmartField.this.m_proposalPopup == null) {
                        SwingScoutSmartField.this.requestProposalSupportFromSwing("*", true, 0L);
                    } else {
                        ActionListener a;
                        JComponent c = SwingUtility.findChildComponent(SwingScoutSmartField.this.m_proposalPopup.getSwingContentPane(), JTable.class);
                        if (c == null) {
                            c = SwingUtility.findChildComponent(SwingScoutSmartField.this.m_proposalPopup.getSwingContentPane(), JTree.class);
                        }
                        if (c != null && (a = c.getActionForKeyStroke(k)) != null) {
                            a.actionPerformed(new ActionEvent(c, 1001, null));
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestProposalSupportFromSwing(String text, boolean selectCurrentValue, long initialDelay) {
        Object object = this.m_pendingProposalJobLock;
        synchronized (object) {
            if (this.m_pendingProposalJob == null) {
                this.m_pendingProposalJob = new P_PendingProposalJob();
            } else {
                this.m_pendingProposalJob.cancel();
            }
            this.m_pendingProposalJob.update(text, selectCurrentValue);
            this.m_pendingProposalJob.schedule(initialDelay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptProposalFromSwing() {
        Object object = this.m_pendingProposalJobLock;
        synchronized (object) {
            if (this.m_pendingProposalJob != null) {
                this.m_pendingProposalJob.cancel();
                this.m_pendingProposalJob = null;
            }
        }
        final String text = this.getSwingTextField().getText();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((ISmartField)SwingScoutSmartField.this.getScoutObject()).getUIFacade().setTextFromUI(text);
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    private void showProposalPopup(final ISmartFieldProposalForm form) {
        JTreeEx proposalTree;
        this.setInputDirty(true);
        if (!this.getSwingField().isDisplayable()) {
            this.getSwingEnvironment().invokeScoutLater(new Runnable(){

                @Override
                public void run() {
                    ((ISmartField)SwingScoutSmartField.this.getScoutObject()).setDisplayText(null);
                    ((ISmartField)SwingScoutSmartField.this.getScoutObject()).refreshDisplayText();
                    ((ISmartField)SwingScoutSmartField.this.getScoutObject()).getUIFacade().unregisterProposalFormFromUI(form);
                }
            }, 0L);
            return;
        }
        if (this.m_proposalPopup != null) {
            if (this.m_proposalPopup.isVisible()) {
                this.m_proposalPopup.closeView();
            }
            this.m_proposalPopup = null;
        }
        this.getSwingTextField().getInputMap(0).put(SwingUtility.createKeystroke("ENTER"), "enter");
        this.getSwingTextField().getActionMap().put("enter", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingScoutSmartField.this.acceptProposalFromSwing();
            }
        });
        this.getSwingTextField().getInputMap(0).put(SwingUtility.createKeystroke("ESCAPE"), "escape");
        this.getSwingTextField().getActionMap().put("escape", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SwingScoutSmartField.this.m_proposalPopup != null) {
                    SwingScoutSmartField.this.m_proposalPopup.closeView();
                }
            }
        });
        this.m_proposalPopup = new SwingScoutDropDownPopup(this.getSwingEnvironment(), (Component)this.getSwingTextField(), this.getSwingTextField());
        this.getSwingEnvironment().createForm(this.m_proposalPopup, (IForm)form);
        this.m_proposalPopup.makeNonFocusable();
        final JTableEx proposalTable = SwingUtility.findChildComponent(this.m_proposalPopup.getSwingContentPane(), JTableEx.class);
        if (proposalTable != null) {
            proposalTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (proposalTable.getSelectedRowCount() == 0) {
                        proposalTable.getSelectionModel().setAnchorSelectionIndex(-1);
                        proposalTable.getSelectionModel().setLeadSelectionIndex(-1);
                    }
                }
            });
        }
        if ((proposalTree = SwingUtility.findChildComponent(this.m_proposalPopup.getSwingContentPane(), JTreeEx.class)) != null) {
            proposalTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    if (proposalTree.getSelectionCount() == 0) {
                        proposalTree.setAnchorSelectionPath(null);
                        proposalTree.setLeadSelectionPath(null);
                    }
                }
            });
        }
        this.m_proposalPopup.getSwingWindow().setSize(new Dimension(this.getSwingTextField().getWidth(), 200));
        if (proposalTree != null || proposalTable != null) {
            form.addFormListener(new FormListener(){

                public void formChanged(FormEvent e) throws ProcessingException {
                    switch (e.getType()) {
                        case 5000: {
                            Runnable t = new Runnable(){

                                @Override
                                public void run() {
                                    SwingScoutSmartField.this.optimizePopupSize(SwingScoutSmartField.this.m_proposalPopup, proposalTable, proposalTree);
                                }
                            };
                            SwingScoutSmartField.this.getSwingEnvironment().invokeSwingLater(t);
                        }
                    }
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingScoutSmartField.this.optimizePopupSize(SwingScoutSmartField.this.m_proposalPopup, proposalTable, proposalTree);
                }
            });
            if (proposalTree != null && proposalTree.getRowCount() > 0 || proposalTable != null && proposalTable.getRowCount() > 0) {
                this.optimizePopupSize(this.m_proposalPopup, proposalTable, proposalTree);
            }
        }
        this.m_proposalPopup.openView();
    }

    private void optimizePopupSize(SwingScoutPopup popup, JTableEx proposalTable, JTreeEx proposalTree) {
        if (proposalTable != null) {
            JViewport viewPort = proposalTable.getParent() instanceof JViewport ? (JViewport)proposalTable.getParent() : null;
            JScrollPane scrollPane = viewPort != null && viewPort.getParent() instanceof JScrollPane ? (JScrollPane)viewPort.getParent() : null;
            int scrollbarSize = scrollPane != null ? scrollPane.getVerticalScrollBar().getPreferredSize().width + 2 : 0;
            Dimension d = proposalTable.getPreferredContentSize(1000);
            d.width += scrollbarSize;
            d.width = Math.max(this.getSwingTextField().getWidth(), Math.min(d.width, 400));
            d.height = Math.max(this.getSwingEnvironment().getFormRowHeight(), Math.min(d.height, 280));
            Insets insets = proposalTable.getInsets();
            if (insets != null) {
                d.width += insets.left + insets.right;
                d.height += insets.top + insets.bottom;
            }
            proposalTable.setPreferredScrollableViewportSize(d);
            Container c = proposalTable;
            while (c != null && !(c instanceof Window)) {
                ((Component)c).invalidate();
                c = c.getParent();
            }
            if (popup != null && popup.getSwingWindow() != null && popup.getSwingWindow().isShowing()) {
                popup.autoAdjustBounds();
            }
        } else if (proposalTree != null) {
            JViewport viewPort = proposalTree.getParent() instanceof JViewport ? (JViewport)proposalTree.getParent() : null;
            JScrollPane scrollPane = viewPort != null && viewPort.getParent() instanceof JScrollPane ? (JScrollPane)viewPort.getParent() : null;
            int scrollbarSize = scrollPane != null ? scrollPane.getVerticalScrollBar().getPreferredSize().width + 2 : 0;
            Dimension d = proposalTree.getPreferredContentSize(1000);
            d.width += scrollbarSize;
            d.width = Math.max(this.getSwingTextField().getWidth(), Math.min(d.width, 400));
            d.height = Math.max(this.getSwingEnvironment().getFormRowHeight(), Math.min(d.height, 280));
            Insets insets = proposalTree.getInsets();
            if (insets != null) {
                d.width += insets.left + insets.right;
                d.height += insets.top + insets.bottom;
            }
            proposalTree.setPreferredScrollableViewportSize(d);
            Container c = proposalTree;
            while (c != null && !(c instanceof Window)) {
                ((Component)c).invalidate();
                c = c.getParent();
            }
            if (popup != null && popup.getSwingWindow() != null && popup.getSwingWindow().isShowing()) {
                popup.autoAdjustBounds();
            }
        }
    }

    private void hideProposalPopup() {
        this.getSwingTextField().getInputMap(0).remove(SwingUtility.createKeystroke("ENTER"));
        this.getSwingTextField().getActionMap().remove("enter");
        this.getSwingTextField().getInputMap(0).remove(SwingUtility.createKeystroke("ESCAPE"));
        this.getSwingTextField().getActionMap().remove("escape");
        if (this.m_proposalPopup != null) {
            this.m_proposalPopup.closeView();
            this.m_proposalPopup = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean handleSwingInputVerifier() {
        Object object = this.m_pendingProposalJobLock;
        synchronized (object) {
            if (this.m_pendingProposalJob != null) {
                this.m_pendingProposalJob.cancel();
                this.m_pendingProposalJob = null;
            }
        }
        final String text = this.getSwingTextField().getText();
        final BooleanHolder result = new BooleanHolder(Boolean.valueOf(true));
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((ISmartField)SwingScoutSmartField.this.getScoutObject()).getUIFacade().setTextFromUI(text);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getSwingEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {}
        boolean processed = job.getState() == 0;
        this.getSwingEnvironment().dispatchImmediateSwingJobs();
        return !processed || (Boolean)result.getValue() != false;
    }

    @Override
    protected void handleSwingFocusGained() {
        super.handleSwingFocusGained();
        JTextComponent swingField = this.getSwingTextField();
        if (swingField.getDocument().getLength() > 0) {
            swingField.setCaretPosition(swingField.getDocument().getLength());
            swingField.moveCaretPosition(0);
        }
        if (((ISmartField)this.getScoutObject()).getErrorStatus() != null) {
            this.requestProposalSupportFromSwing(((ISmartField)this.getScoutObject()).getDisplayText(), false, 0L);
        }
    }

    protected boolean isSmartChooserEnabled() {
        if (this.getSwingField() instanceof JTextFieldWithDropDownButton) {
            return ((JTextFieldWithDropDownButton)this.getSwingField()).isDropDownButtonEnabled();
        }
        return false;
    }

    protected void handleSwingSmartChooserAction(long initialDelay) {
        if (this.isSmartChooserEnabled()) {
            this.requestProposalSupportFromSwing("*", true, initialDelay);
        }
    }

    protected void handleSwingPopup(final JComponent target) {
        if (((ISmartField)this.getScoutObject()).hasMenus()) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    IMenu[] scoutMenus = ((ISmartField)SwingScoutSmartField.this.getScoutObject()).getUIFacade().firePopupFromUI();
                    int x = 0;
                    if (target instanceof JTextFieldWithDropDownButton) {
                        JTextFieldWithDropDownButton tf = (JTextFieldWithDropDownButton)target;
                        x = tf.getWidth() - tf.getMargin().right;
                    }
                    Point point = new Point(x, target.getHeight());
                    new SwingPopupWorker(SwingScoutSmartField.this.getSwingEnvironment(), target, point, scoutMenus).enqueue();
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 5678L);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("iconId")) {
            this.setIconIdFromScout((String)newValue);
        } else if (name.equals("proposalForm")) {
            this.setProposalFormFromScout((ISmartFieldProposalForm)newValue);
        }
    }

    private String getLinesOfStackTrace(StackTraceElement[] elements, int lines) {
        StringBuilder b = new StringBuilder();
        int lineCount = Math.min(lines, elements.length);
        int i = 0;
        while (i < lineCount) {
            b.append("  " + elements[i].toString());
            if (i < lineCount - 1) {
                b.append("\n");
            }
            ++i;
        }
        return b.toString();
    }

    private class P_PendingProposalJob
    extends JobEx
    implements Runnable {
        private String m_text;
        private boolean m_selectCurrentValue;

        public P_PendingProposalJob() {
            super("");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            SwingUtilities.invokeLater(this);
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = SwingScoutSmartField.this.m_pendingProposalJobLock;
            synchronized (object) {
                if (SwingScoutSmartField.this.m_pendingProposalJob != this) {
                    return;
                }
                SwingScoutSmartField.this.m_pendingProposalJob = null;
            }
            if (SwingScoutSmartField.this.getSwingField().isFocusOwner()) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        ((ISmartField)SwingScoutSmartField.this.getScoutObject()).getUIFacade().openProposalFromUI(P_PendingProposalJob.this.m_text, P_PendingProposalJob.this.m_selectCurrentValue);
                    }
                };
                SwingScoutSmartField.this.getSwingEnvironment().invokeScoutLater(t, 0L);
            }
        }

        public void update(String text, boolean selectCurrentValue) {
            this.m_text = text;
            this.m_selectCurrentValue = selectCurrentValue;
        }
    }
}

