/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.login.internal;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.scout.rt.ui.swing.ext.FlowLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.JDialogEx;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.login.internal.AuthStatus;
import org.eclipse.scout.rt.ui.swing.login.internal.InternalNetAuthenticator;

public class LoginDialog
extends JDialogEx {
    private static final long serialVersionUID = 1L;
    private JTextField m_userField;
    private JPasswordField m_passField;
    private JButton m_okButton;
    private JCheckBox m_saveCheckBox;
    private AuthStatus m_status;

    public LoginDialog(AuthStatus status) {
        this.m_status = status;
        this.setTitle(UIManager.getString("LoginDialog.title"));
        this.createContents();
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                LoginDialog.this.setInitialFocus();
            }
        });
    }

    protected void createContents() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(new EmptyBorder(10, 5, 10, 5));
        Insets insets = new Insets(1, 2, 1, 2);
        JLabel infoField = new JLabel();
        contentPane.add((Component)infoField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        if (this.m_status.isProxy()) {
            infoField.setText("PROXY " + this.m_status.getUrl().getHost());
        } else {
            infoField.setText(this.m_status.getUrl().getHost());
        }
        JLabel userLabel = new JLabel();
        contentPane.add((Component)userLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        userLabel.setText(UIManager.getString("LoginDialog.username"));
        this.m_userField = new JTextField(10);
        contentPane.add((Component)this.m_userField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        if (this.m_status.getUsername() != null) {
            this.m_userField.setText(this.m_status.getUsername());
        }
        this.m_userField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                LoginDialog.this.m_status.setUsername(LoginDialog.this.m_userField.getText());
                LoginDialog.this.updateOkButton();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LoginDialog.this.m_status.setUsername(LoginDialog.this.m_userField.getText());
                LoginDialog.this.updateOkButton();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LoginDialog.this.m_status.setUsername(LoginDialog.this.m_userField.getText());
                LoginDialog.this.updateOkButton();
            }
        });
        this.m_userField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LoginDialog.this.m_userField.selectAll();
                LoginDialog.this.m_userField.setSelectionStart(0);
            }
        });
        JLabel passLabel = new JLabel();
        contentPane.add((Component)passLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        passLabel.setText(UIManager.getString("LoginDialog.password"));
        this.m_passField = new JPasswordField(10);
        contentPane.add((Component)this.m_passField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        if (this.m_status.getPassword() != null) {
            this.m_passField.setText(new String(this.m_status.getPassword()));
        }
        this.m_passField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                LoginDialog.this.m_status.setPassword(new String(LoginDialog.this.m_passField.getPassword()));
                LoginDialog.this.updateOkButton();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LoginDialog.this.m_status.setPassword(new String(LoginDialog.this.m_passField.getPassword()));
                LoginDialog.this.updateOkButton();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LoginDialog.this.m_status.setPassword(new String(LoginDialog.this.m_passField.getPassword()));
                LoginDialog.this.updateOkButton();
            }
        });
        this.m_passField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LoginDialog.this.m_passField.selectAll();
                LoginDialog.this.m_passField.setSelectionStart(0);
            }
        });
        if (InternalNetAuthenticator.NET_AUTHENTICATION_CACHE_ENABLED) {
            this.m_saveCheckBox = new JCheckBox(UIManager.getString("LoginDialog.savePassword"), false);
            this.m_saveCheckBox.setOpaque(false);
            contentPane.add((Component)this.m_saveCheckBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        }
        contentPane.add((Component)new JPanelEx(), new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 13, 1, insets, 0, 0));
        JPanelEx buttonPanel = new JPanelEx(new FlowLayoutEx(4, 2, 1));
        contentPane.add((Component)buttonPanel, new GridBagConstraints(0, 11, 2, 1, 1.0, 0.0, 13, 2, insets, 0, 0));
        this.m_okButton = new JButton();
        buttonPanel.add(this.m_okButton);
        this.m_okButton.setText(UIManager.getString("LoginDialog.ok"));
        this.m_okButton.setEnabled(false);
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.doOk();
            }
        });
        JButton cancel = new JButton();
        buttonPanel.add(cancel);
        cancel.setText(UIManager.getString("LoginDialog.cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.m_status.setUsername(null);
                LoginDialog.this.m_status.setPassword(null);
                LoginDialog.this.doCancel();
            }
        });
        this.updateOkButton();
    }

    private void doOk() {
        this.m_status.setOk();
        if (this.m_saveCheckBox != null) {
            this.m_status.setSavePassword(this.m_saveCheckBox.isSelected());
        }
        this.setVisible(false);
    }

    private void doCancel() {
        this.m_status.setCancel();
        this.setVisible(false);
    }

    public void setInitialFocus() {
        if (this.m_userField.getText() != null && this.m_userField.getText().length() == 0) {
            this.m_userField.requestFocus();
        } else {
            this.m_passField.requestFocus();
        }
        this.getRootPane().setDefaultButton(this.m_okButton);
    }

    private void updateOkButton() {
        if (this.m_status.getUsername() != null && this.m_status.getUsername().length() > 0 && this.m_status.getPassword() != null && this.m_status.getPassword().length() > 0) {
            this.m_okButton.setEnabled(true);
        } else {
            this.m_okButton.setEnabled(false);
        }
    }
}

