/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.splash;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.rt.ui.swing.ext.BorderLayoutEx;
import org.eclipse.scout.rt.ui.swing.form.fields.AbstractLayoutManager2;
import org.eclipse.scout.rt.ui.swing.splash.ISplashWindow;
import org.osgi.framework.Version;

public class EmbeddedSplashWindow
implements ISplashWindow {
    private static final long serialVersionUID = 1L;
    private RootPaneContainer m_owner;
    private JLabel m_splash;
    private String m_title;
    private String m_statusText = "...";
    private String m_versionText;
    private float m_animationPhase = -1.0f;

    public EmbeddedSplashWindow(RootPaneContainer owner) {
        this.m_owner = owner;
        Version v = Version.emptyVersion;
        if (Platform.getProduct() != null) {
            this.m_title = Platform.getProduct().getName();
            v = Version.parseVersion((String)("" + Platform.getProduct().getDefiningBundle().getHeaders().get("Bundle-Version")));
        }
        this.m_versionText = String.valueOf(v.getMajor()) + "." + v.getMinor() + "." + v.getMicro();
    }

    @Override
    public void showSplash() {
        Icon imgIcon = UIManager.getIcon("Splash.icon");
        if (imgIcon == null) {
            imgIcon = new P_EmptyIcon();
        }
        this.m_splash = new JLabel(new P_SplashScreen(imgIcon));
        this.m_splash.setPreferredSize(new Dimension(imgIcon.getIconWidth(), imgIcon.getIconHeight()));
        this.m_splash.setVerticalAlignment(1);
        Color c = UIManager.getColor("Splash.text");
        if (c != null) {
            this.m_splash.setForeground(c);
        }
        JComponent glass = (JComponent)this.m_owner.getGlassPane();
        glass.setLayout(new P_GlassOverlayLayout());
        this.m_owner.getContentPane().removeAll();
        this.m_owner.getContentPane().setLayout(new P_Layout());
        this.m_owner.getContentPane().add("Center", this.m_splash);
        ((Frame)((Object)this.m_owner)).pack();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
                while (EmbeddedSplashWindow.this.m_splash != null) {
                    try {
                        1.sleep(25L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (EmbeddedSplashWindow.this.m_splash == null || !EmbeddedSplashWindow.this.m_splash.isShowing()) continue;
                    EmbeddedSplashWindow.this.m_animationPhase = (float)(System.currentTimeMillis() / 3L % 1000L) / 1000.0f * 6.0f;
                    if (!(EmbeddedSplashWindow.this.m_animationPhase >= 0.0f) || !(EmbeddedSplashWindow.this.m_animationPhase <= 1.0f) || EmbeddedSplashWindow.this.m_splash == null) continue;
                    EmbeddedSplashWindow.this.m_splash.repaint();
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void disposeSplash() {
        this.m_splash = null;
        this.m_owner.getContentPane().removeAll();
        this.m_owner.getContentPane().setLayout(new BorderLayoutEx());
        JComponent glass = (JComponent)this.m_owner.getGlassPane();
        glass.removeAll();
        glass.setLayout(new FlowLayout());
        glass.setVisible(false);
    }

    @Override
    public void setStatusText(String s) {
        if (this.m_splash != null) {
            if (s == null) {
                s = "";
            }
            this.m_statusText = s;
            this.m_splash.repaint();
        }
    }

    private class P_EmptyIcon
    implements Icon {
        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            Color c1 = new Color(-3355444, true);
            Color c2 = new Color(0xCCCCCC, true);
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, c1, 0.0f, this.getIconHeight(), c2, true));
            g2d.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return 360;
        }

        @Override
        public int getIconHeight() {
            return 280;
        }
    }

    private class P_GlassOverlayLayout
    extends AbstractLayoutManager2 {
        private P_GlassOverlayLayout() {
        }

        @Override
        protected void validateLayout(Container parent) {
        }

        @Override
        protected Dimension getLayoutSize(Container parent, int sizeflag) {
            if (parent.getComponentCount() > 0) {
                return parent.getComponent(0).getPreferredSize();
            }
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            if (parent.getComponentCount() > 0) {
                Component c = parent.getComponent(0);
                Dimension d = c.getPreferredSize();
                int dx = Math.max(0, parent.getWidth() - d.width) / 2 - 45;
                int dy = Math.max(0, parent.getHeight() - d.height) / 2 + 70;
                c.setBounds(dx, dy, d.width, d.height);
            }
        }
    }

    private class P_Layout
    extends AbstractLayoutManager2 {
        private P_Layout() {
        }

        @Override
        protected void validateLayout(Container parent) {
        }

        @Override
        protected Dimension getLayoutSize(Container parent, int sizeflag) {
            if (parent.getComponentCount() > 0) {
                return parent.getComponent(0).getPreferredSize();
            }
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            if (parent.getComponentCount() > 0) {
                Component c = parent.getComponent(0);
                Dimension d = c.getPreferredSize();
                int dx = Math.max(0, parent.getWidth() - d.width) / 2;
                int dy = Math.max(0, parent.getHeight() - d.height) / 2;
                c.setBounds(dx, dy, d.width, d.height);
            }
        }
    }

    private class P_SplashScreen
    implements Icon {
        private Icon m_splashIcon;
        private int m_highlightSize = 200;

        public P_SplashScreen(Icon splashIcon) {
            this.m_splashIcon = splashIcon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            FontMetrics fm = g.getFontMetrics();
            int w = c.getWidth();
            int h = c.getHeight();
            this.m_splashIcon.paintIcon(c, g, x, y);
            Graphics2D g2d = (Graphics2D)g;
            Color c1 = new Color(0x66FFFFFF, true);
            Color c2 = new Color(0xFFFFFF, true);
            int phase = (int)(EmbeddedSplashWindow.this.m_animationPhase * (float)(w + this.m_highlightSize * 2)) - this.m_highlightSize;
            g2d.setPaint(new GradientPaint(phase - this.m_highlightSize, 0.0f, c2, phase, 0.0f, c1, true));
            g2d.fillRect(phase - this.m_highlightSize, 0, this.m_highlightSize, h);
            g2d.setPaint(new GradientPaint(phase, 0.0f, c1, phase + this.m_highlightSize, 0.0f, c2, true));
            g2d.fillRect(phase, 0, this.m_highlightSize, h);
            g2d.setPaint(c.getForeground());
            g.drawString(EmbeddedSplashWindow.this.m_versionText, 12, h - fm.getHeight() - 10);
            int offset = 12 + fm.stringWidth(EmbeddedSplashWindow.this.m_versionText) + 4;
            if (EmbeddedSplashWindow.this.m_statusText != null) {
                g.drawString(EmbeddedSplashWindow.this.m_statusText, Math.max((w - fm.stringWidth(EmbeddedSplashWindow.this.m_statusText)) / 2, offset), h - fm.getHeight() - 10);
            }
        }

        @Override
        public int getIconHeight() {
            return this.m_splashIcon.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.m_splashIcon.getIconWidth();
        }
    }
}

