/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.job;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.ui.swing.ext.job.SwingProgressMonitor;

public class SwingProgressProvider
extends ProgressProvider
implements IPropertyObserver {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingProgressProvider.class);
    public static final String PROP_ACTIVE_MONITOR = "activeMonitor";
    private final Object m_listLock = new Object();
    private final LinkedList<SwingProgressMonitor> m_list = new LinkedList();
    private final PropertyChangeSupport m_propertySupport = new PropertyChangeSupport((Object)this);
    private final PropertyChangeListener m_jobListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            SwingProgressProvider.this.setActiveMonitor((SwingProgressMonitor)((Object)e.getSource()));
        }
    };
    private SwingProgressMonitor m_activeMonitor;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    public IProgressMonitor createMonitor(Job job) {
        if (!this.accept(job)) {
            return this.getDefaultMonitor();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("new " + (job.isSystem() ? "system  " : (job.isUser() ? "user    " : "default ")) + "Job: " + job);
        }
        final SwingProgressMonitor monitor = new SwingProgressMonitor();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void running(IJobChangeEvent event) {
                SwingProgressProvider.this.addInternal(monitor);
            }

            public void done(IJobChangeEvent event) {
                SwingProgressProvider.this.removeInternal(monitor);
            }
        });
        return monitor;
    }

    private boolean accept(Job job) {
        if (job.isSystem()) {
            return false;
        }
        return !(job instanceof ClientJob) || !((ClientJob)job).isSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInternal(SwingProgressMonitor monitor) {
        Object object = this.m_listLock;
        synchronized (object) {
            this.m_list.add(monitor);
        }
        monitor.addPropertyChangeListener(this.m_jobListener);
        this.setActiveMonitor(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInternal(SwingProgressMonitor monitor) {
        SwingProgressMonitor next;
        monitor.removePropertyChangeListener(this.m_jobListener);
        Object object = this.m_listLock;
        synchronized (object) {
            this.m_list.remove((Object)monitor);
            next = this.m_list.size() > 0 ? this.m_list.get(this.m_list.size() - 1) : null;
        }
        this.setActiveMonitor(next);
    }

    private synchronized void setActiveMonitor(SwingProgressMonitor newValue) {
        SwingProgressMonitor oldValue = this.m_activeMonitor;
        this.m_activeMonitor = newValue;
        this.m_propertySupport.firePropertyChange(PROP_ACTIVE_MONITOR, (Object)oldValue, (Object)newValue);
    }

    public SwingProgressMonitor getActiveMonitor() {
        return this.m_activeMonitor;
    }
}

