/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.mailfield;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.eclipse.scout.commons.HTMLUtility;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.MailUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.filechooser.FileChooser;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.mailfield.IMailField;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SingleLayout;
import org.eclipse.scout.rt.ui.swing.SwingPopupWorker;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.BorderLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.FlowLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.JLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JScrollPaneEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JTextPaneEx;
import org.eclipse.scout.rt.ui.swing.ext.MouseClickedBugFix;
import org.eclipse.scout.rt.ui.swing.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.mailfield.ISwingScoutMailField;
import org.eclipse.scout.rt.ui.swing.form.fields.mailfield.SwingMailAttachment;
import org.eclipse.scout.rt.ui.swing.form.fields.mailfield.SwingMailAttachmentView;

public class SwingScoutMailField
extends SwingScoutValueFieldComposite<IMailField>
implements ISwingScoutMailField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutMailField.class);
    private static final String KEY_FROM = "From";
    private static final String KEY_TO = "To";
    private static final String KEY_CC = "Cc";
    private static final String KEY_BCC = "bcc";
    private Map<String, P_AddressComponent> m_addressComponents;
    private HTMLEditorKit m_htmlKit;
    private HTMLDocument m_htmlDoc;
    private StyleSheet m_styleSheet;
    private JTextPane m_htmlView;
    private JPanelEx m_htmlViewPanel;
    private JScrollPane m_scrollPane;
    private ArrayList<SwingMailAttachment> m_attachments;
    private JPanel m_attachementPanel;
    private MouseListener m_attachementListener;
    private File m_tempFolder;
    private JLabelEx m_sentLabel;
    private JLabelEx m_receivedDate;
    private JLabelEx m_subjectLabel;
    private JLabelEx m_subject;

    @Override
    protected void detachScout() {
        if (this.m_tempFolder != null) {
            IOUtility.deleteDirectory((File)this.m_tempFolder);
        }
        super.detachScout();
    }

    @Override
    protected void initializeSwing() {
        super.initializeSwing();
        this.m_attachementListener = new P_AttachementMouseListener();
        if (this.m_addressComponents == null) {
            this.m_addressComponents = new HashMap<String, P_AddressComponent>();
        }
        this.m_attachments = new ArrayList();
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
        container.add(label);
        JComponent mailPanel = this.createMailComponent();
        mailPanel.putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, LogicalGridDataBuilder.createField(this.getSwingEnvironment(), ((IMailField)this.getScoutObject()).getGridData()));
        container.add(mailPanel);
        this.setSwingContainer(container);
        this.setSwingLabel(label);
        this.setSwingField(this.m_htmlView);
        this.getSwingContainer().setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    protected JComponent createMailComponent() {
        JPanelEx mailContainer = new JPanelEx(new BorderLayoutEx(0, 0));
        JComponent header = this.createHeaderComponent();
        JComponent body = this.createBodyComponent();
        JComponent attachements = this.createAttachementComponent();
        JPanelEx bodyAttachmentPanel = new JPanelEx(new BorderLayoutEx(0, 0));
        bodyAttachmentPanel.setBorder(BorderFactory.createEtchedBorder());
        bodyAttachmentPanel.add((Component)body, "Center");
        bodyAttachmentPanel.add((Component)attachements, "South");
        mailContainer.add((Component)header, "North");
        mailContainer.add((Component)bodyAttachmentPanel, "Center");
        return mailContainer;
    }

    protected JComponent createBodyComponent() {
        this.m_htmlKit = new HTMLEditorKit();
        this.m_htmlDoc = (HTMLDocument)this.m_htmlKit.createDefaultDocument();
        this.m_styleSheet = this.m_htmlDoc.getStyleSheet();
        this.m_htmlView = new JTextPaneEx();
        this.m_htmlView.setEditorKit(this.m_htmlKit);
        this.m_htmlView.setDocument(this.m_htmlDoc);
        this.m_htmlView.setEditable(false);
        this.m_htmlView.setBorder(null);
        this.m_htmlView.setMargin(null);
        this.m_htmlView.setCaretPosition(0);
        this.m_htmlView.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SwingScoutMailField.this.fireHyperlinkActionFromSwing(e.getURL());
                }
            }
        });
        this.m_htmlViewPanel = new JPanelEx(new SingleLayout());
        if (((IMailField)this.getScoutObject()).isScrollBarEnabled()) {
            this.m_scrollPane = new JScrollPaneEx(this.m_htmlView);
            this.m_htmlViewPanel.add(this.m_scrollPane);
        } else {
            this.m_htmlViewPanel.add(this.m_htmlView);
        }
        return this.m_htmlViewPanel;
    }

    protected JComponent createHeaderComponent() {
        JPanel headerPanel = new JPanel(new GridBagLayout());
        P_AddressComponent fromComp = new P_AddressComponent();
        this.m_addressComponents.put(KEY_FROM, fromComp);
        P_AddressComponent toComp = new P_AddressComponent();
        this.m_addressComponents.put(KEY_TO, toComp);
        P_AddressComponent ccComp = new P_AddressComponent();
        this.m_addressComponents.put(KEY_CC, ccComp);
        this.m_sentLabel = new JLabelEx();
        this.m_receivedDate = new JLabelEx();
        this.m_subjectLabel = new JLabelEx();
        this.m_subject = new JLabelEx();
        GridBagConstraints constrains = new GridBagConstraints();
        constrains.gridx = 0;
        constrains.gridy = 0;
        constrains.weightx = 0.5;
        constrains.insets = new Insets(0, 0, 0, 0);
        constrains.fill = 1;
        headerPanel.add((Component)fromComp, constrains);
        constrains.gridx = 0;
        constrains.gridy = 1;
        headerPanel.add((Component)toComp, constrains);
        constrains.gridx = 0;
        constrains.gridy = 2;
        headerPanel.add((Component)ccComp, constrains);
        constrains.gridx = 0;
        constrains.gridy = 3;
        headerPanel.add(this.createReceivedDatePanel(), constrains);
        constrains.gridx = 0;
        constrains.gridy = 4;
        headerPanel.add(this.createSubjectPanel(), constrains);
        return headerPanel;
    }

    private Component createSubjectPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constrains = new GridBagConstraints();
        constrains.insets = new Insets(2, 2, 2, 2);
        constrains.gridx = 0;
        constrains.gridy = 0;
        constrains.weightx = 0.0;
        this.m_subjectLabel.setMinimumSize(new Dimension(80, 20));
        this.m_subjectLabel.setPreferredSize(new Dimension(80, 20));
        panel.add((Component)this.m_subjectLabel, constrains);
        constrains.gridx = 1;
        constrains.gridy = 0;
        constrains.weightx = 0.5;
        constrains.fill = 1;
        panel.add((Component)this.m_subject, constrains);
        return panel;
    }

    private Component createReceivedDatePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints Constrains = new GridBagConstraints();
        Constrains.insets = new Insets(2, 2, 2, 2);
        Constrains.gridx = 0;
        Constrains.gridy = 0;
        Constrains.weightx = 0.0;
        this.m_sentLabel.setMinimumSize(new Dimension(80, 20));
        this.m_sentLabel.setPreferredSize(new Dimension(80, 20));
        panel.add((Component)this.m_sentLabel, Constrains);
        Constrains.gridx = 1;
        Constrains.gridy = 0;
        Constrains.weightx = 0.5;
        Constrains.fill = 1;
        panel.add((Component)this.m_receivedDate, Constrains);
        return panel;
    }

    protected JComponent createAttachementComponent() {
        this.m_attachementPanel = new JPanelEx(new FlowLayoutEx(2));
        JScrollPaneEx pane = new JScrollPaneEx(this.m_attachementPanel, 21, 30);
        return pane;
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.updateFromLabelFromScout();
        this.updateToLabelFromScout();
        this.updateCcLabelFromScout();
        this.updateSentLabelFromScout();
        this.updateSubjectLabelFromScout();
    }

    @Override
    protected void setValueFromScout(Object o) {
        super.setValueFromScout(o);
        this.setMessageFromScout((MimeMessage)((IMailField)this.getScoutObject()).getValue());
    }

    protected void setMessageFromScout(MimeMessage message) {
        String subject = "";
        String receivedDate = "";
        ArrayList bodyCollector = new ArrayList();
        ArrayList attachementCollector = new ArrayList();
        Address[] fromAddresses = new Address[]{};
        Address[] toAddresses = new Address[]{};
        Address[] ccAddresses = new Address[]{};
        try {
            if (message != null) {
                MailUtility.collectMailParts((Part)message, bodyCollector, attachementCollector);
                subject = message.getSubject();
                Date received = message.getSentDate();
                if (received != null) {
                    receivedDate = DateFormat.getDateTimeInstance(0, 3).format(received);
                }
                fromAddresses = message.getFrom();
                toAddresses = message.getRecipients(Message.RecipientType.TO);
                ccAddresses = message.getRecipients(Message.RecipientType.CC);
            }
        }
        catch (Exception e) {
            LOG.warn("could not parse message.", (Throwable)e);
        }
        this.setAttachements(attachementCollector.toArray(new Part[attachementCollector.size()]));
        try {
            this.setBodyParts(bodyCollector.toArray(new Part[bodyCollector.size()]));
        }
        catch (Exception e) {
            LOG.warn("could not parse message.", (Throwable)e);
        }
        this.m_receivedDate.setText(receivedDate);
        this.m_subject.setText(subject);
        this.setAddressesFromScout(fromAddresses, KEY_FROM, false);
        this.setAddressesFromScout(toAddresses, KEY_TO, false);
        this.setAddressesFromScout(ccAddresses, KEY_CC, true);
    }

    protected void setAttachements(Part[] attachements) {
        Component[] componentArray = this.m_attachementPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.removeMouseListener(this.m_attachementListener);
            ++n2;
        }
        this.m_attachementPanel.removeAll();
        this.m_attachments.clear();
        if (attachements != null && attachements.length > 0) {
            this.m_attachementPanel.setVisible(true);
            componentArray = attachements;
            n = attachements.length;
            n2 = 0;
            while (n2 < n) {
                Component p = componentArray[n2];
                SwingMailAttachment att = new SwingMailAttachment((Part)p, this.getTempFolder());
                this.m_attachments.add(att);
                if (att.getContentId() == null) {
                    SwingMailAttachmentView attView = new SwingMailAttachmentView(att);
                    attView.addMouseListener(this.m_attachementListener);
                    this.m_attachementPanel.add(attView);
                }
                ++n2;
            }
        } else {
            this.m_attachementPanel.setVisible(false);
        }
    }

    protected void setBodyParts(Part[] bodyParts) throws MessagingException, ProcessingException, IOException {
        StringBuilder buf = new StringBuilder();
        if (bodyParts != null) {
            Part bodyPart = MailUtility.getHtmlPart((Part[])bodyParts);
            if (bodyPart == null) {
                bodyPart = MailUtility.getPlainTextPart((Part[])bodyParts);
                if (bodyPart != null) {
                    buf.append("<html><body><pre>");
                    buf.append((String)bodyPart.getContent());
                    buf.append("</pre></body></html>");
                }
            } else if (bodyPart instanceof MimePart) {
                byte[] content;
                MimePart mimePart = (MimePart)bodyPart;
                Pattern pattern = Pattern.compile("charset=\".*\"", 10);
                Matcher matcher = pattern.matcher(mimePart.getContentType());
                String htmlCharacterEncoding = "UTF-8";
                if (matcher.find() && matcher.group(0).split("\"").length >= 2) {
                    htmlCharacterEncoding = matcher.group(0).split("\"")[1];
                }
                if ((content = IOUtility.getContent((InputStream)mimePart.getInputStream())) != null) {
                    buf.append(new String(content, htmlCharacterEncoding));
                }
            }
        }
        String styledHtml = this.getSwingEnvironment().styleHtmlText(this, buf.toString());
        HashMap<String, URL> cidToUrlMapping = new HashMap<String, URL>();
        for (SwingMailAttachment a : this.m_attachments) {
            String cid = a.getContentId();
            if (cid == null) continue;
            cidToUrlMapping.put(cid, a.getFile().toURI().toURL());
        }
        HTMLDocument htmlDoc = HTMLUtility.toHtmlDocument((String)styledHtml);
        htmlDoc = HTMLUtility.replaceContendIDs((HTMLDocument)htmlDoc, cidToUrlMapping);
        styledHtml = HTMLUtility.toHtmlText((HTMLDocument)htmlDoc);
        this.m_htmlDoc = (HTMLDocument)this.m_htmlKit.createDefaultDocument();
        this.m_styleSheet = this.m_htmlDoc.getStyleSheet();
        this.m_htmlView.setDocument(this.m_htmlDoc);
        this.m_htmlView.setText(styledHtml);
        this.m_htmlView.setCaretPosition(0);
    }

    public JTextPane getSwingMailField() {
        return this.m_htmlView;
    }

    protected JScrollPane getScrollPane() {
        return this.m_scrollPane;
    }

    protected HTMLEditorKit getHtmlKit() {
        return this.m_htmlKit;
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        this.m_htmlView.setEditable(((IMailField)this.getScoutObject()).isMailEditor());
    }

    protected void setAddressesFromScout(Address[] addresses, String addressKey, boolean invisibleWhenEmpty) {
        P_AddressComponent comp = this.m_addressComponents.get(addressKey);
        if (comp != null) {
            comp.setAddresses(addresses, invisibleWhenEmpty);
        }
    }

    private void updateSentLabelFromScout() {
        this.m_sentLabel.setText(((IMailField)this.getScoutObject()).getLabelSent());
    }

    private void updateSubjectLabelFromScout() {
        this.m_subjectLabel.setText(((IMailField)this.getScoutObject()).getLabelSubject());
    }

    private void updateCcLabelFromScout() {
        this.m_addressComponents.get(KEY_CC).getLabel().setText(((IMailField)this.getScoutObject()).getLabelCc());
    }

    private void updateToLabelFromScout() {
        this.m_addressComponents.get(KEY_TO).getLabel().setText(((IMailField)this.getScoutObject()).getLabelTo());
    }

    private void updateFromLabelFromScout() {
        this.m_addressComponents.get(KEY_FROM).getLabel().setText(((IMailField)this.getScoutObject()).getLabelFrom());
    }

    protected void fireHyperlinkActionFromSwing(final URL url) {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IMailField)SwingScoutMailField.this.getScoutObject()).getUIFacade().fireHyperlinkActionFromUI(url);
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    protected void fireAttachementActionFromSwing(final File file) {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IMailField)SwingScoutMailField.this.getScoutObject()).getUIFacade().fireAttachementActionFromUI(file);
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 2345L);
    }

    protected void handleSwingPopup(final SwingMailAttachmentView target) {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                IMenu[] scoutMenus = new IMenu[]{new P_AttachmentPopupMenu(target.getAttachment().getFile())};
                new SwingPopupWorker(SwingScoutMailField.this.getSwingEnvironment(), target, new Point(0, target.getHeight()), scoutMenus).enqueue();
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 5678L);
    }

    protected File getTempFolder() {
        if (this.m_tempFolder == null) {
            File folder = null;
            try {
                folder = File.createTempFile("attachements." + this.hashCode(), "");
                folder.delete();
                folder.mkdir();
                folder.deleteOnExit();
            }
            catch (IOException e) {
                LOG.error("could not create temp directory for mail attachement.", (Throwable)e);
            }
            this.m_tempFolder = folder;
        }
        return this.m_tempFolder;
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if ("labelFrom".equals(name)) {
            this.updateFromLabelFromScout();
        } else if ("labelTo".equals(name)) {
            this.updateToLabelFromScout();
        } else if ("labelCC".equals(name)) {
            this.updateCcLabelFromScout();
        } else if ("labelSent".equals(name)) {
            this.updateSentLabelFromScout();
        } else if ("labelSubject".equals(name)) {
            this.updateSubjectLabelFromScout();
        }
        super.handleScoutPropertyChange(name, newValue);
    }

    private class P_AddressComponent
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabelEx m_addressField;
        private InternetAddress[] m_addresses;
        private JLabelEx m_label;

        public P_AddressComponent() {
            super(new GridBagLayout());
            this.createComponent();
        }

        void createComponent() {
            this.m_label = new JLabelEx();
            this.m_label.setMinimumSize(new Dimension(80, 20));
            this.m_label.setPreferredSize(new Dimension(80, 20));
            this.m_addressField = new JLabelEx();
            GridBagConstraints constrains = new GridBagConstraints();
            constrains.insets = new Insets(2, 2, 2, 2);
            constrains.gridx = 0;
            constrains.gridy = 0;
            constrains.weightx = 0.0;
            this.add((Component)this.m_label, constrains);
            constrains.gridx = 1;
            constrains.gridy = 0;
            constrains.weightx = 0.5;
            constrains.fill = 1;
            this.add((Component)this.m_addressField, constrains);
        }

        public JLabelEx getLabel() {
            return this.m_label;
        }

        void setAddresses(Address[] addresses, boolean invisibleWhenEmpty) {
            boolean hasAddresses;
            ArrayList<InternetAddress> inetAddresses = new ArrayList<InternetAddress>();
            if (addresses != null) {
                Address[] addressArray = addresses;
                int n = addresses.length;
                int n2 = 0;
                while (n2 < n) {
                    Address a = addressArray[n2];
                    if (a instanceof InternetAddress) {
                        inetAddresses.add((InternetAddress)a);
                    }
                    ++n2;
                }
            }
            this.m_addresses = inetAddresses.toArray(new InternetAddress[inetAddresses.size()]);
            StringBuffer buf = new StringBuffer();
            boolean bl = hasAddresses = this.m_addresses != null && this.m_addresses.length > 0;
            if (invisibleWhenEmpty) {
                this.setVisible(hasAddresses);
            }
            if (hasAddresses) {
                InternetAddress[] internetAddressArray = this.m_addresses;
                int n = this.m_addresses.length;
                int n3 = 0;
                while (n3 < n) {
                    String adString;
                    InternetAddress address = internetAddressArray[n3];
                    if (buf.length() > 0) {
                        buf.append("; ");
                    }
                    adString = (adString = address.getPersonal()) != null ? String.valueOf(adString) + "<" + address.getAddress() + ">" : address.getAddress();
                    buf.append(adString);
                    ++n3;
                }
            }
            this.m_addressField.setText(buf.toString());
            this.getParent().doLayout();
        }
    }

    private class P_AttachementMouseListener
    extends MouseAdapter {
        MouseClickedBugFix fix;

        private P_AttachementMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Object source;
            this.fix = new MouseClickedBugFix(e);
            if (e.isPopupTrigger() && (source = e.getSource()) instanceof SwingMailAttachmentView) {
                SwingScoutMailField.this.handleSwingPopup((SwingMailAttachmentView)source);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Object source;
            if (e.isPopupTrigger() && (source = e.getSource()) instanceof SwingMailAttachmentView) {
                SwingScoutMailField.this.handleSwingPopup((SwingMailAttachmentView)source);
            }
            if (this.fix != null) {
                this.fix.mouseReleased(this, e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.fix.mouseClicked()) {
                return;
            }
            Object source = e.getSource();
            if (source instanceof SwingMailAttachmentView) {
                File file = ((SwingMailAttachmentView)source).getAttachment().getFile();
                switch (e.getButton()) {
                    case 1: {
                        SwingScoutMailField.this.fireAttachementActionFromSwing(file);
                        break;
                    }
                }
            }
        }
    }

    private class P_AttachmentPopupMenu
    extends AbstractMenu {
        private File m_file;

        public P_AttachmentPopupMenu(File file) {
            this.m_file = file;
        }

        protected String getConfiguredText() {
            return SwingUtility.getNlsText("FormStateStoreAs", new String[0]);
        }

        public void doAction() throws ProcessingException {
            String[] extensions = new String[]{};
            try {
                String fileName = this.m_file.getName();
                String fileExt = this.m_file.getName().substring(fileName.lastIndexOf(".") + 1, fileName.length());
                extensions = new String[]{fileExt};
            }
            catch (Exception exception) {
                LOG.warn("could not find extension of '" + this.m_file.getName() + "'");
            }
            File path = null;
            File dir = null;
            FileChooser fileChooser = new FileChooser(dir, extensions, false);
            fileChooser.setFileName(this.m_file.getName());
            File[] a = fileChooser.startChooser();
            if (a.length > 0) {
                path = a[0];
                try {
                    IOUtility.writeContent((OutputStream)new FileOutputStream(path), (byte[])IOUtility.getContent((InputStream)new FileInputStream(this.m_file)));
                }
                catch (Exception e) {
                    LOG.warn(null, (Throwable)e);
                }
            }
        }
    }
}

