/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.treebox;

import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.ITreeBox;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.basic.tree.SwingScoutTree;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JTreeEx;
import org.eclipse.scout.rt.ui.swing.form.fields.ISwingScoutFormField;
import org.eclipse.scout.rt.ui.swing.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.treebox.ISwingScoutTreeBox;

public class SwingScoutTreeBox
extends SwingScoutValueFieldComposite<ITreeBox<?>>
implements ISwingScoutTreeBox {
    private SwingScoutTree m_treeComposite;

    @Override
    protected void initializeSwing() {
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
        container.add(label);
        this.m_treeComposite = new SwingScoutTree();
        this.m_treeComposite.createField(((ITreeBox)this.getScoutObject()).getTree(), this.getSwingEnvironment());
        JTreeEx tree = this.m_treeComposite.getSwingTree();
        int rowHeight = -1;
        if (UIManager.get("TreeBox.rowHeight") != null) {
            rowHeight = UIManager.getInt("TreeBox.rowHeight");
        }
        if (rowHeight <= 0 && UIManager.get("ListBox.rowHeight") != null) {
            rowHeight = UIManager.getInt("ListBox.rowHeight");
        }
        if (rowHeight > 0) {
            tree.setRowHeight(rowHeight);
        }
        LogicalGridData fieldData = LogicalGridDataBuilder.createField(this.getSwingEnvironment(), ((ITreeBox)this.getScoutObject()).getGridData());
        this.m_treeComposite.getSwingScrollPane().putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, fieldData);
        container.add(this.m_treeComposite.getSwingScrollPane());
        IFormField[] childFields = ((ITreeBox)this.getScoutObject()).getFields();
        if (childFields.length > 0) {
            ISwingScoutFormField filterComposite = this.getSwingEnvironment().createFormField(container, childFields[0]);
            LogicalGridData filterData = LogicalGridDataBuilder.createField(this.getSwingEnvironment(), childFields[0].getGridData());
            filterData.gridx = fieldData.gridx;
            filterData.gridy = fieldData.gridy + fieldData.gridh;
            filterData.gridw = fieldData.gridw;
            filterData.weightx = fieldData.weightx;
            filterComposite.getSwingContainer().putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, filterData);
            container.add(filterComposite.getSwingContainer());
        }
        this.setSwingContainer(container);
        this.setSwingLabel(label);
        this.setSwingField(this.m_treeComposite.getSwingTree());
        this.getSwingContainer().setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    @Override
    public JScrollPane getSwingScrollPane() {
        return this.m_treeComposite.getSwingScrollPane();
    }

    @Override
    public JTreeEx getSwingTree() {
        return this.m_treeComposite.getSwingTree();
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        this.getSwingLabel().setEnabled(b);
        this.getSwingField().repaint();
        this.getSwingScrollPane().getViewport().setOpaque(b);
    }
}

