/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.checkbox.ICheckBoxMenu;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.action.SwtScoutAction;
import org.eclipse.scout.rt.ui.swt.action.SwtScoutCheckboxMenu;
import org.eclipse.scout.rt.ui.swt.action.SwtScoutMenuAction;
import org.eclipse.scout.rt.ui.swt.action.SwtScoutMenuGroup;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public final class SwtMenuUtility {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(SwtMenuUtility.class);

    private SwtMenuUtility() {
    }

    public static IContributionItem[] getMenuContribution(IActionNode<?>[] scoutActionNodes, ISwtEnvironment environment) {
        ArrayList<Object> contributionItems = new ArrayList<Object>();
        IActionNode<?>[] iActionNodeArray = scoutActionNodes;
        int n = scoutActionNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IActionNode<?> scoutAction = iActionNodeArray[n2];
            if (scoutAction.isVisible()) {
                if (scoutAction.isSeparator()) {
                    if (contributionItems.size() <= 0 || !((IContributionItem)contributionItems.get(contributionItems.size() - 1)).isSeparator()) {
                        contributionItems.add(new Separator());
                    }
                } else if (scoutAction.hasChildActions()) {
                    MenuManager manager = new MenuManager(scoutAction.getText(), scoutAction.getActionId());
                    SwtMenuUtility.fillMenuManager(scoutAction.getChildActions().toArray(new IActionNode[scoutAction.getChildActionCount()]), (IMenuManager)manager, environment);
                    contributionItems.add(manager);
                } else if (scoutAction instanceof ICheckBoxMenu) {
                    contributionItems.add(new ActionContributionItem((org.eclipse.jface.action.IAction)new SwtScoutAction((IAction)scoutAction, environment, 32).getSwtAction()));
                } else {
                    contributionItems.add(new ActionContributionItem((org.eclipse.jface.action.IAction)new SwtScoutAction((IAction)scoutAction, environment).getSwtAction()));
                }
            }
            ++n2;
        }
        return contributionItems.toArray(new IContributionItem[contributionItems.size()]);
    }

    public static IContributionItem getMenuContributionItem(IActionNode<?> scoutAction, ISwtEnvironment environment) {
        Separator item = null;
        if (scoutAction.isVisible()) {
            if (scoutAction.isSeparator()) {
                item = new Separator();
            } else if (scoutAction.hasChildActions()) {
                MenuManager manager = new MenuManager(scoutAction.getText(), scoutAction.getActionId());
                SwtMenuUtility.fillMenuManager(scoutAction.getChildActions().toArray(new IActionNode[scoutAction.getChildActionCount()]), (IMenuManager)manager, environment);
                item = manager;
            } else {
                item = scoutAction instanceof ICheckBoxMenu ? new ActionContributionItem((org.eclipse.jface.action.IAction)new SwtScoutAction((IAction)scoutAction, environment, 32).getSwtAction()) : new ActionContributionItem((org.eclipse.jface.action.IAction)new SwtScoutAction((IAction)scoutAction, environment).getSwtAction());
            }
        }
        return item;
    }

    private static void fillMenuManager(IActionNode<?>[] scoutActionNodes, IMenuManager manager, ISwtEnvironment environment) {
        IActionNode<?>[] iActionNodeArray = scoutActionNodes;
        int n = scoutActionNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IActionNode<?> scoutAction = iActionNodeArray[n2];
            if (scoutAction.isVisible()) {
                if (scoutAction.isSeparator()) {
                    if (manager.getItems().length <= 0 || !manager.getItems()[manager.getItems().length - 1].isSeparator()) {
                        manager.add((IContributionItem)new Separator());
                    }
                } else if (scoutAction.hasChildActions()) {
                    MenuManager childManager = new MenuManager(scoutAction.getText(), scoutAction.getActionId());
                    SwtMenuUtility.fillMenuManager(scoutAction.getChildActions().toArray(new IActionNode[scoutAction.getChildActionCount()]), (IMenuManager)childManager, environment);
                    manager.add((IContributionItem)childManager);
                } else if (scoutAction instanceof ICheckBoxMenu) {
                    manager.add((IContributionItem)new ActionContributionItem((org.eclipse.jface.action.IAction)new SwtScoutAction((IAction)scoutAction, environment, 32).getSwtAction()));
                } else {
                    manager.add((IContributionItem)new ActionContributionItem((org.eclipse.jface.action.IAction)new SwtScoutAction((IAction)scoutAction, environment).getSwtAction()));
                }
            }
            ++n2;
        }
    }

    public static void fillContextMenu(IMenu[] scoutMenus, Menu menu, ISwtEnvironment environment) {
        if (scoutMenus == null || scoutMenus.length == 0) {
            return;
        }
        LinkedList<IMenu> scoutActionNodes = new LinkedList<IMenu>();
        IMenu[] iMenuArray = scoutMenus;
        int n = scoutMenus.length;
        int n2 = 0;
        while (n2 < n) {
            IMenu scoutMenu = iMenuArray[n2];
            scoutActionNodes.add(scoutMenu);
            ++n2;
        }
        SwtMenuUtility.fillContextMenu(scoutActionNodes, menu, environment);
    }

    public static void fillContextMenu(List<? extends IActionNode> scoutActionNodes, Menu menu, ISwtEnvironment environment) {
        if (scoutActionNodes == null || scoutActionNodes.size() == 0) {
            return;
        }
        List<IActionNode> cleanedScoutActions = SwtMenuUtility.cleanup(scoutActionNodes);
        for (IActionNode scoutActionNode : cleanedScoutActions) {
            SwtMenuUtility.fillContextMenuRec(scoutActionNode, menu, environment);
        }
    }

    private static void fillContextMenuRec(IActionNode<?> scoutActionNode, Menu menu, ISwtEnvironment environment) {
        if (!scoutActionNode.isVisible()) {
            return;
        }
        if (scoutActionNode.isSeparator()) {
            new MenuItem(menu, 2);
        } else if (scoutActionNode instanceof ICheckBoxMenu) {
            new SwtScoutCheckboxMenu(menu, (ICheckBoxMenu)scoutActionNode, environment);
        } else if (scoutActionNode.getChildActionCount() > 0) {
            SwtScoutMenuGroup group = new SwtScoutMenuGroup(menu, (IAction)scoutActionNode, environment);
            Menu subMenu = new Menu(menu);
            group.getSwtMenuItem().setMenu(subMenu);
            List<IActionNode> childActions = SwtMenuUtility.cleanup(scoutActionNode.getChildActions());
            for (IActionNode subAction : childActions) {
                SwtMenuUtility.fillContextMenuRec(subAction, subMenu, environment);
            }
        } else {
            new SwtScoutMenuAction(menu, (IAction)scoutActionNode, environment);
        }
    }

    public static IMenu[] collectMenus(final ITree tree, final boolean emptySpaceActions, final boolean nodeActions, ISwtEnvironment uiEnvironment) {
        final LinkedList menuList = new LinkedList();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                if (emptySpaceActions) {
                    menuList.addAll(Arrays.asList(tree.getUIFacade().fireEmptySpacePopupFromUI()));
                }
                if (nodeActions) {
                    menuList.addAll(Arrays.asList(tree.getUIFacade().fireNodePopupFromUI()));
                }
            }
        };
        JobEx job = uiEnvironment.invokeScoutLater(t, 5000L);
        try {
            job.join(1200L);
        }
        catch (InterruptedException ex) {
            LOG.warn("Exception occured while collecting menus.", (Throwable)ex);
        }
        return menuList.toArray(new IMenu[menuList.size()]);
    }

    public static IMenu[] collectMenus(final ITable table, final boolean emptySpaceActions, final boolean rowActions, ISwtEnvironment uiEnvironment) {
        final LinkedList menuList = new LinkedList();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                if (emptySpaceActions) {
                    menuList.addAll(Arrays.asList(table.getUIFacade().fireEmptySpacePopupFromUI()));
                }
                if (rowActions) {
                    menuList.addAll(Arrays.asList(table.getUIFacade().fireRowPopupFromUI()));
                }
            }
        };
        JobEx job = uiEnvironment.invokeScoutLater(t, 5000L);
        try {
            job.join(1200L);
        }
        catch (InterruptedException ex) {
            LOG.warn("Exception occured while collecting menus.", (Throwable)ex);
        }
        return menuList.toArray(new IMenu[menuList.size()]);
    }

    public static IMenu[] collectRowMenus(ITable table, ISwtEnvironment uiEnvironment) {
        return SwtMenuUtility.collectMenus(table, false, true, uiEnvironment);
    }

    public static IMenu[] collectEmptySpaceMenus(ITable table, ISwtEnvironment uiEnvironment) {
        return SwtMenuUtility.collectMenus(table, true, false, uiEnvironment);
    }

    public static IMenu[] collectNodeMenus(ITree tree, ISwtEnvironment uiEnvironment) {
        return SwtMenuUtility.collectMenus(tree, false, true, uiEnvironment);
    }

    public static IMenu[] collectEmptySpaceMenus(ITree tree, ISwtEnvironment uiEnvironment) {
        return SwtMenuUtility.collectMenus(tree, true, false, uiEnvironment);
    }

    public static List<IActionNode> cleanup(List<? extends IActionNode> scoutActionNodes) {
        if (scoutActionNodes == null) {
            return null;
        }
        LinkedList<IActionNode> cleanedActions = new LinkedList<IActionNode>();
        int i = 0;
        while (i < scoutActionNodes.size()) {
            IAction nextVisibleAction;
            IActionNode actionNode = scoutActionNodes.get(i);
            if (actionNode.isVisible() && (!actionNode.isSeparator() || i != 0 && i != scoutActionNodes.size() - 1 && (nextVisibleAction = SwtMenuUtility.getFirstVisibleAction(scoutActionNodes, i + 1)) != null && !nextVisibleAction.isSeparator())) {
                cleanedActions.add(actionNode);
            }
            ++i;
        }
        return cleanedActions;
    }

    private static IAction getFirstVisibleAction(List<? extends IActionNode> scoutActionNodes, int startIndex) {
        if (scoutActionNodes == null) {
            return null;
        }
        int i = startIndex;
        while (i < scoutActionNodes.size()) {
            IActionNode action = scoutActionNodes.get(i);
            if (action.isVisible()) {
                return action;
            }
            ++i;
        }
        return null;
    }
}

