/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar.widgets;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.scout.rt.client.ui.basic.calendar.DateTimeFormatFactory;
import org.eclipse.scout.rt.ui.swt.basic.calendar.SwtColors;
import org.eclipse.scout.rt.ui.swt.basic.calendar.layout.MonthCellLayout;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.AbstractCell;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.DayNamesBar;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.MonthCell;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.SwtCalendar;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.TimelineColumn;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.WeekCell;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class CentralPanel
extends Composite {
    private SwtCalendar m_calendar;
    private Composite m_emptyComposite;
    private DayNamesBar m_dayNames;
    private TimelineColumn m_timeline;
    private ArrayList<WeekCell> m_weekCells = null;
    private ArrayList<ArrayList<MonthCell>> m_monthCells = null;
    private HashMap<Date, AbstractCell> m_dateMap;
    private Composite m_cells;
    private int m_panelWidth = 0;
    private int m_panelHeight = 0;
    private int m_timelessMaxCount;

    public CentralPanel(Composite parent, int style, SwtCalendar calendar) {
        super(parent, style);
        this.m_calendar = calendar;
        this.createControls();
    }

    protected void createControls() {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.setLayoutData(gd);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 2;
        layout.verticalSpacing = 2;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.setBackground(SwtColors.getInstance().getWhite());
        this.addListener(1, new Listener(){

            public void handleEvent(Event e) {
            }
        });
    }

    protected void setState() {
        this.disposeWidgets();
        this.m_dateMap = new HashMap();
        switch (this.m_calendar.getDisplayMode()) {
            case 1: {
                this.setupDay();
                break;
            }
            case 2: 
            case 4: {
                this.setupWeek();
                break;
            }
            case 3: {
                this.setupMonth();
            }
        }
        this.layout();
    }

    protected void setupDay() {
        Calendar viewDate = this.m_calendar.getViewDate();
        int weekNo = viewDate.get(3);
        this.m_timeline = new TimelineColumn(this, 0, false);
        this.m_cells = new Composite((Composite)this, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.m_cells.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 2;
        layout.verticalSpacing = 0;
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        this.m_cells.setLayout((Layout)layout);
        this.m_cells.setBackground(SwtColors.getInstance().getWhite());
        this.m_weekCells = new ArrayList();
        WeekCell c = new WeekCell(this.m_cells, 0, this.m_calendar, viewDate.getTime(), false, true);
        this.m_weekCells.add(c);
        this.m_dateMap.put(viewDate.getTime(), c);
        SimpleDateFormat weekDayFmt = new SimpleDateFormat("EEEEE", Locale.getDefault());
        DateFormat dateFmt = new DateTimeFormatFactory().getDayMonthYear(1);
        this.m_calendar.setDateBrowserHeader(String.valueOf(weekDayFmt.format(viewDate.getTime())) + " " + dateFmt.format(viewDate.getTime()) + " - " + SwtUtility.getNlsText(Display.getCurrent(), "Week", new String[0]) + " " + weekNo);
        this.addItemsToCells();
        this.calcTimelessMaxCount();
        this.setWeekItemsLayoutData();
        this.m_timeline.init();
        this.m_cells.layout();
    }

    protected void setupWeek() {
        Calendar viewDate = this.m_calendar.getViewDate();
        int weekNo = viewDate.get(3);
        this.m_weekCells = new ArrayList();
        this.m_emptyComposite = new Composite((Composite)this, 0);
        this.m_emptyComposite.setBackground(SwtColors.getInstance().getWhite());
        GridData gd = new GridData();
        gd.widthHint = 50;
        gd.heightHint = 1;
        gd.horizontalAlignment = 1;
        this.m_emptyComposite.setLayoutData((Object)gd);
        int nbDays = this.m_calendar.getDisplayMode() == 4 ? 5 : 7;
        int nbCols = nbDays;
        if (this.m_calendar.getCondensedMode() && this.m_calendar.getDisplayMode() == 2) {
            --nbCols;
        }
        if (this.m_calendar.getDisplayMode() != 1) {
            this.m_dayNames = new DayNamesBar(this, 0, this.m_calendar, nbDays, this.m_calendar.getCondensedMode());
        }
        this.m_timeline = new TimelineColumn(this, 0);
        this.m_cells = new Composite((Composite)this, 0);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.m_cells.setLayoutData((Object)gd);
        GridLayout layout3 = new GridLayout();
        layout3.marginWidth = 0;
        layout3.marginHeight = 0;
        layout3.horizontalSpacing = 2;
        layout3.verticalSpacing = 0;
        layout3.numColumns = nbCols;
        layout3.makeColumnsEqualWidth = true;
        this.m_cells.setLayout((Layout)layout3);
        this.m_cells.setBackground(SwtColors.getInstance().getWhite());
        this.m_cells.addListener(1, new Listener(){

            public void handleEvent(Event e) {
            }
        });
        int selectedMonth = this.m_calendar.getViewDate().get(2);
        Calendar currentDate = Calendar.getInstance();
        currentDate.setTime(this.m_calendar.getViewDateStart().getTime());
        int d = 0;
        while (d < nbDays) {
            boolean cellCurrentMonth = currentDate.get(2) == selectedMonth;
            WeekCell cell = new WeekCell(this.m_cells, 0, this.m_calendar, currentDate.getTime(), d == 0, cellCurrentMonth);
            this.m_weekCells.add(cell);
            this.m_dateMap.put(currentDate.getTime(), cell);
            currentDate.add(5, 1);
            ++d;
        }
        this.m_calendar.setDateBrowserHeader(String.valueOf(new SimpleDateFormat("MMMM yyyy", Locale.getDefault()).format(viewDate.getTime())) + " - " + SwtUtility.getNlsText(Display.getCurrent(), "Week", new String[0]) + " " + weekNo);
        this.addItemsToCells();
        this.calcTimelessMaxCount();
        this.setWeekItemsLayoutData();
        this.m_timeline.init();
        this.m_cells.layout();
    }

    protected void setWeekItemsLayoutData() {
        if (this.m_weekCells != null) {
            for (WeekCell day : this.m_weekCells) {
                day.setItemsLayoutData();
            }
        }
    }

    protected void setupMonth() {
        Calendar viewDate = this.m_calendar.getViewDate();
        this.m_monthCells = new ArrayList();
        int nbCols = this.m_calendar.getCondensedMode() ? 6 : 7;
        this.m_dayNames = new DayNamesBar(this, 0, this.m_calendar, 7, this.m_calendar.getCondensedMode());
        ((GridData)this.m_dayNames.getLayoutData()).horizontalSpan = 2;
        this.m_cells = new Composite((Composite)this, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.horizontalSpan = 2;
        this.m_cells.setLayoutData((Object)gd);
        MonthCellLayout layout = new MonthCellLayout();
        layout.setNumColumns(nbCols);
        layout.setNumLines(12);
        this.m_cells.setLayout((Layout)layout);
        this.m_cells.setBackground(SwtColors.getInstance().getWhite());
        Calendar currentDate = Calendar.getInstance();
        currentDate.setTime(this.m_calendar.getViewDateStart().getTime());
        int selectedMonth = this.m_calendar.getViewDate().get(2);
        int w = 0;
        while (w < 6) {
            ArrayList<MonthCell> week = new ArrayList<MonthCell>();
            int d = 0;
            while (d < 7) {
                boolean cellCurrentMonth = currentDate.get(2) == selectedMonth;
                MonthCell mc = new MonthCell(this.m_cells, 0, this.m_calendar, currentDate.getTime(), d == 0, cellCurrentMonth);
                week.add(mc);
                this.m_dateMap.put(currentDate.getTime(), mc);
                currentDate.add(5, 1);
                ++d;
            }
            this.m_monthCells.add(week);
            ++w;
        }
        this.m_calendar.setDateBrowserHeader(new SimpleDateFormat("MMMM yyyy", Locale.getDefault()).format(viewDate.getTime()));
        this.m_cells.layout();
    }

    public AbstractCell getCellFromDate(Date d) {
        d = SwtCalendar.truncDate(d);
        return this.m_dateMap.get(d);
    }

    protected void calcTimelessMaxCount() {
        this.m_timelessMaxCount = 0;
        if (this.m_weekCells != null) {
            for (WeekCell day : this.m_weekCells) {
                this.m_timelessMaxCount = Math.max(this.m_timelessMaxCount, day.getCountTimelessItems());
            }
        } else {
            for (ArrayList<MonthCell> week : this.m_monthCells) {
                for (MonthCell day : week) {
                    this.m_timelessMaxCount = Math.max(this.m_timelessMaxCount, day.getCountTimelessItems());
                }
            }
        }
    }

    protected void addItemsToCells() {
        if (this.m_weekCells != null) {
            for (WeekCell day : this.m_weekCells) {
                day.addCalendarItems();
            }
        }
    }

    public int getTimelessMaxCount() {
        return this.m_timelessMaxCount;
    }

    protected void disposeWidgets() {
        if (this.m_monthCells != null) {
            for (ArrayList arrayList : this.m_monthCells) {
                for (MonthCell cell : arrayList) {
                    if (cell == null || cell.isDisposed()) continue;
                    cell.dispose();
                }
            }
        }
        if (this.m_weekCells != null) {
            for (WeekCell weekCell : this.m_weekCells) {
                if (weekCell == null || weekCell.isDisposed()) continue;
                weekCell.dispose();
            }
        }
        if (this.m_emptyComposite != null && !this.m_emptyComposite.isDisposed()) {
            this.m_emptyComposite.dispose();
        }
        if (this.m_dayNames != null && !this.m_dayNames.isDisposed()) {
            this.m_dayNames.dispose();
        }
        if (this.m_timeline != null && !this.m_timeline.isDisposed()) {
            this.m_timeline.dispose();
        }
        this.m_weekCells = null;
        this.m_monthCells = null;
        this.m_dateMap = null;
        if (this.m_cells != null && !this.m_cells.isDisposed()) {
            this.m_cells.dispose();
        }
    }

    public void reloadCalendarItems() {
        if (this.m_weekCells != null) {
            for (WeekCell weekCell : this.m_weekCells) {
                weekCell.reloadCalendarItems();
            }
            this.calcTimelessMaxCount();
            this.setWeekItemsLayoutData();
            this.m_timeline.init();
        }
        if (this.m_monthCells != null) {
            for (ArrayList arrayList : this.m_monthCells) {
                for (MonthCell day : arrayList) {
                    day.reloadCalendarItems();
                }
            }
        }
        this.m_cells.layout();
        if (this.m_weekCells != null) {
            for (WeekCell weekCell : this.m_weekCells) {
                weekCell.layout();
            }
        }
        if (this.m_monthCells != null) {
            for (ArrayList arrayList : this.m_monthCells) {
                for (MonthCell day : arrayList) {
                    day.layout();
                }
            }
        }
    }

    public void updateSelection(Calendar selectedDate) {
        if (this.m_weekCells != null) {
            for (WeekCell day : this.m_weekCells) {
                if (selectedDate.getTime().equals(day.getDate().getTime())) {
                    day.setSelected(true);
                    continue;
                }
                day.setSelected(false);
            }
        } else {
            for (ArrayList<MonthCell> week : this.m_monthCells) {
                for (MonthCell day : week) {
                    if (selectedDate.getTime().equals(day.getDate().getTime())) {
                        day.setSelected(true);
                        continue;
                    }
                    day.setSelected(false);
                }
            }
        }
    }

    public void dispose() {
        this.disposeWidgets();
        super.dispose();
    }
}

