/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar.widgets;

import java.util.ArrayList;
import org.eclipse.scout.rt.ui.swt.basic.calendar.SwtColors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class LabelledCombo
extends Composite {
    private Label label;
    private Combo combo;
    private ArrayList<SelectionListener> listeners = new ArrayList();

    public LabelledCombo(Composite parent, int style) {
        super(parent, style);
        this.createControls();
        this.hookListeners();
    }

    protected void createControls() {
        GridData gd = new GridData();
        gd.horizontalAlignment = 32;
        this.setLayoutData(gd);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 3;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.label = new Label((Composite)this, 0);
        this.label.setBackground(SwtColors.getInstance().getWhite());
        gd = new GridData();
        gd.horizontalAlignment = 32;
        this.label.setLayoutData((Object)gd);
        this.combo = new Combo((Composite)this, 12);
        gd = new GridData();
        gd.horizontalAlignment = 32;
        this.combo.setLayoutData((Object)gd);
    }

    public void comboAdd(String entry) {
        this.combo.add(entry);
    }

    public void comboSelect(int position) {
        this.combo.select(position);
    }

    public int comboGetSelection() {
        return this.combo.getSelectionIndex();
    }

    public void labelSetText(String text) {
        this.label.setText(text);
    }

    public void comboSetVisibleItemCount(int count) {
        this.combo.setVisibleItemCount(count);
    }

    public void hookListeners() {
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (SelectionListener l : LabelledCombo.this.listeners) {
                    if (l == null) continue;
                    l.widgetSelected(e);
                }
            }
        });
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }
}

