/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.table;

import java.net.URL;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.IDNDSupport;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.table.IHeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.RowIndexComparator;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.shared.security.CopyToClipboardPermission;
import org.eclipse.scout.rt.shared.services.common.security.ACCESS;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.SwtMenuUtility;
import org.eclipse.scout.rt.ui.swt.basic.SwtScoutComposite;
import org.eclipse.scout.rt.ui.swt.basic.table.ISwtScoutTable;
import org.eclipse.scout.rt.ui.swt.basic.table.SwtScoutTableEvent;
import org.eclipse.scout.rt.ui.swt.basic.table.SwtScoutTableModel;
import org.eclipse.scout.rt.ui.swt.basic.table.TableColumnManager;
import org.eclipse.scout.rt.ui.swt.basic.table.TableKeyboardNavigationSupport;
import org.eclipse.scout.rt.ui.swt.basic.table.celleditor.SwtScoutTableCellEditor;
import org.eclipse.scout.rt.ui.swt.ext.table.TableEx;
import org.eclipse.scout.rt.ui.swt.ext.table.util.TableRolloverSupport;
import org.eclipse.scout.rt.ui.swt.form.fields.AbstractSwtScoutDndSupport;
import org.eclipse.scout.rt.ui.swt.keystroke.ISwtKeyStroke;
import org.eclipse.scout.rt.ui.swt.util.SwtTransferObject;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.scout.rt.ui.swt.util.UiRedrawHandler;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class SwtScoutTable
extends SwtScoutComposite<ITable>
implements ISwtScoutTable {
    private P_ScoutTableListener m_scoutTableListener;
    private UiRedrawHandler m_redrawHandler;
    private Listener m_autoResizeColumnListener;
    private Listener m_columnListener = new P_TableColumnListener();
    private SelectionListener m_columnSortListener = new P_ColumnSortListener();
    private TableColumnManager m_columnManager = new TableColumnManager();
    private SwtScoutTableCellEditor m_cellEditorComposite;
    private int[] m_uiColumnOrder;
    private Menu m_contextMenu;
    private Menu m_headerMenu;
    private TableViewer m_viewer;
    private ISwtKeyStroke[] m_keyStrokes;
    private ClientSyncJob m_storeColumnWidthsJob;
    private TableKeyboardNavigationSupport m_keyboardNavigationSupport;

    @Override
    protected void initializeSwt(Composite parent) {
        this.m_redrawHandler = new UiRedrawHandler((Control)parent);
        int style = this.getScoutObject() != null && ((ITable)this.getScoutObject()).isMultiSelect() ? 2 : 4;
        TableEx table = this.getEnvironment().getFormToolkit().createTable(parent, style |= 0x10B00, ((ITable)this.getScoutObject()).isMultilineText());
        table.setLinesVisible(false);
        table.setHeaderVisible(true);
        new TableRolloverSupport(table);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SwtScoutTable.this.m_headerMenu != null && !SwtScoutTable.this.m_headerMenu.isDisposed()) {
                    SwtScoutTable.this.m_headerMenu.dispose();
                }
                if (SwtScoutTable.this.m_contextMenu != null && !SwtScoutTable.this.m_contextMenu.isDisposed()) {
                    SwtScoutTable.this.m_contextMenu.dispose();
                }
            }
        });
        TableViewer viewer = new TableViewer((Table)table);
        viewer.setUseHashlookup(true);
        this.setSwtTableViewer(viewer);
        this.setSwtField((Control)table);
        this.m_cellEditorComposite = new SwtScoutTableCellEditor(this);
        this.m_headerMenu = new Menu((Decorations)viewer.getTable().getShell(), 8);
        table.addMenuDetectListener(new P_SwtHeaderMenuDetectListener());
        this.initializeColumns();
        SwtScoutTableModel tableModel = this.createTableModel();
        viewer.setContentProvider((IContentProvider)tableModel);
        viewer.setLabelProvider((IBaseLabelProvider)tableModel);
        viewer.setInput((Object)tableModel);
        viewer.addSelectionChangedListener((ISelectionChangedListener)new P_SwtSelectionListener());
        P_SwtTableListener swtTableListener = new P_SwtTableListener();
        table.addListener(3, swtTableListener);
        table.addListener(4, swtTableListener);
        table.addListener(8, swtTableListener);
        table.addListener(35, swtTableListener);
        table.addListener(2, swtTableListener);
        Menu contextMenu = new Menu((Decorations)viewer.getTable().getShell(), 8);
        contextMenu.addMenuListener((MenuListener)new P_ContextMenuListener());
        this.m_contextMenu = contextMenu;
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & SWT.MOD1) == 0 || e.keyCode != 99) {
                    return;
                }
                TransferObject scoutTransferable = SwtScoutTable.this.handleSwtCopyRequest();
                if (scoutTransferable == null) {
                    return;
                }
                SwtTransferObject[] swtTransferables = SwtUtility.createSwtTransferables(scoutTransferable);
                if (swtTransferables.length == 0) {
                    return;
                }
                Clipboard clipboard = new Clipboard(SwtScoutTable.this.getEnvironment().getDisplay());
                try {
                    Transfer[] dataTypes = new Transfer[swtTransferables.length];
                    Object[] data = new Object[swtTransferables.length];
                    int i = 0;
                    while (i < swtTransferables.length) {
                        dataTypes[i] = swtTransferables[i].getTransfer();
                        data[i] = swtTransferables[i].getData();
                        ++i;
                    }
                    clipboard.setContents(data, dataTypes);
                }
                finally {
                    clipboard.dispose();
                }
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return this.getSwtField() == null || this.getSwtField().isDisposed();
    }

    protected SwtScoutTableModel createTableModel() {
        return new SwtScoutTableModel((ITable)this.getScoutObject(), this, this.getEnvironment(), this.m_columnManager);
    }

    public TableColumnManager getColumnManager() {
        return this.m_columnManager;
    }

    public void initializeColumns() {
        this.m_redrawHandler.pushControlChanging();
        try {
            IColumn[] scoutColumnsOrdered;
            TableColumn[] tableColumnArray = this.getSwtField().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn col = tableColumnArray[n2];
                col.dispose();
                ++n2;
            }
            TableColumn dummyCol = new TableColumn((Table)this.getSwtField(), 16384);
            dummyCol.setWidth(0);
            dummyCol.setResizable(false);
            dummyCol.setMoveable(false);
            boolean sortEnabled = false;
            if (this.getScoutObject() != null) {
                scoutColumnsOrdered = ((ITable)this.getScoutObject()).getColumnSet().getVisibleColumns();
                sortEnabled = ((ITable)this.getScoutObject()).isSortEnabled();
            } else {
                scoutColumnsOrdered = new IColumn[]{};
            }
            if (this.m_columnManager == null) {
                this.m_columnManager = new TableColumnManager();
            }
            this.m_columnManager.initialize(scoutColumnsOrdered);
            IColumn[] iColumnArray = scoutColumnsOrdered;
            int n3 = scoutColumnsOrdered.length;
            int n4 = 0;
            while (n4 < n3) {
                IColumn scoutColumn = iColumnArray[n4];
                IHeaderCell cell = scoutColumn.getHeaderCell();
                int style = SwtUtility.getHorizontalAlignment(cell.getHorizontalAlignment());
                TableColumn swtCol = new TableColumn((Table)this.getSwtField(), style);
                swtCol.setData("scoutColumn", (Object)scoutColumn);
                swtCol.setMoveable(true);
                swtCol.setToolTipText(cell.getTooltipText());
                this.updateHeaderText(swtCol, scoutColumn);
                swtCol.setWidth(scoutColumn.getWidth());
                if (cell.isSortActive()) {
                    this.getSwtField().setSortColumn(swtCol);
                    this.getSwtField().setSortDirection(cell.isSortAscending() ? 128 : 1024);
                }
                if (sortEnabled) {
                    swtCol.addSelectionListener(this.m_columnSortListener);
                }
                swtCol.addListener(10, this.m_columnListener);
                swtCol.addListener(11, this.m_columnListener);
                ++n4;
            }
            this.m_uiColumnOrder = this.getSwtField().getColumnOrder();
            this.m_cellEditorComposite.initialize();
        }
        finally {
            this.m_redrawHandler.popControlChanging();
        }
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.getScoutObject() == null) {
            return;
        }
        if (this.m_scoutTableListener == null) {
            this.m_scoutTableListener = new P_ScoutTableListener();
            ((ITable)this.getScoutObject()).addUITableListener((TableListener)this.m_scoutTableListener);
        }
        this.setHeaderVisibleFromScout(((ITable)this.getScoutObject()).isHeaderVisible());
        this.setSelectionFromScout(((ITable)this.getScoutObject()).getSelectedRows());
        this.updateKeyStrokeFormScout();
        this.updateKeyboardNavigationFromScout();
        this.updateAutoResizeColumnsFromScout();
        new P_DndSupport((IPropertyObserver)this.getScoutObject(), (IDNDSupport)this.getScoutObject(), (Control)this.getSwtField(), this.getEnvironment());
        final IEventHistory h = ((ITable)this.getScoutObject()).getEventHistory();
        if (h != null) {
            this.getEnvironment().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (TableEvent e : h.getRecentEvents()) {
                        SwtScoutTable.this.handleScoutTableEventInSwt(e);
                    }
                }
            });
        }
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        if (this.getScoutObject() != null && this.m_scoutTableListener != null) {
            ((ITable)this.getScoutObject()).removeTableListener((TableListener)this.m_scoutTableListener);
            this.m_scoutTableListener = null;
        }
        this.removeAutoResizeColumnListener();
    }

    public TableEx getSwtField() {
        return (TableEx)super.getSwtField();
    }

    @Override
    public TableViewer getSwtTableViewer() {
        return this.m_viewer;
    }

    public void setSwtTableViewer(TableViewer viewer) {
        this.m_viewer = viewer;
    }

    public ITableRow getSwtSelectedRow() {
        ITableRow[] rows = this.getSwtSelectedRows();
        if (rows.length > 0) {
            return rows[0];
        }
        return null;
    }

    public ITableRow[] getSwtSelectedRows() {
        StructuredSelection uiSelection = (StructuredSelection)this.getSwtTableViewer().getSelection();
        TreeSet<ITableRow> sortedRows = new TreeSet<ITableRow>((Comparator<ITableRow>)new RowIndexComparator());
        if (uiSelection != null && !uiSelection.isEmpty()) {
            Object[] objectArray = uiSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ITableRow row = (ITableRow)o;
                sortedRows.add(row);
                ++n2;
            }
        }
        return sortedRows.toArray(new ITableRow[sortedRows.size()]);
    }

    protected void updateKeyStrokeFormScout() {
        IKeyStroke[] scoutKeyStrokes;
        if (this.m_keyStrokes != null) {
            ISwtKeyStroke[] iSwtKeyStrokeArray = this.m_keyStrokes;
            int n = this.m_keyStrokes.length;
            int n2 = 0;
            while (n2 < n) {
                ISwtKeyStroke swtKeyStroke = iSwtKeyStrokeArray[n2];
                this.getEnvironment().removeKeyStroke((Widget)this.getSwtField(), swtKeyStroke);
                ++n2;
            }
        }
        ArrayList<ISwtKeyStroke> newSwtKeyStrokes = new ArrayList<ISwtKeyStroke>();
        IKeyStroke[] iKeyStrokeArray = scoutKeyStrokes = ((ITable)this.getScoutObject()).getKeyStrokes();
        int n = scoutKeyStrokes.length;
        int n3 = 0;
        while (n3 < n) {
            ISwtKeyStroke[] swtStrokes;
            IKeyStroke scoutKeyStroke = iKeyStrokeArray[n3];
            ISwtKeyStroke[] iSwtKeyStrokeArray = swtStrokes = SwtUtility.getKeyStrokes(scoutKeyStroke, this.getEnvironment());
            int n4 = swtStrokes.length;
            int n5 = 0;
            while (n5 < n4) {
                ISwtKeyStroke swtStroke = iSwtKeyStrokeArray[n5];
                this.getEnvironment().addKeyStroke((Widget)this.getSwtField(), swtStroke);
                newSwtKeyStrokes.add(swtStroke);
                ++n5;
            }
            ++n3;
        }
        this.m_keyStrokes = newSwtKeyStrokes.toArray(new ISwtKeyStroke[newSwtKeyStrokes.size()]);
    }

    protected void updateKeyboardNavigationFromScout() {
        if (((ITable)this.getScoutObject()).hasKeyboardNavigation()) {
            if (this.m_keyboardNavigationSupport == null) {
                this.m_keyboardNavigationSupport = new P_KeyBoardNavigationSupport(this.getSwtField());
            }
        } else if (this.m_keyboardNavigationSupport != null) {
            this.m_keyboardNavigationSupport.dispose();
            this.m_keyboardNavigationSupport = null;
        }
    }

    private void updateAutoResizeColumnsFromScout() {
        if (this.getSwtField() != null && !this.getSwtField().getParent().isDisposed()) {
            Composite parent = this.getSwtField().getParent();
            if (((ITable)this.getScoutObject()).isAutoResizeColumns()) {
                if (this.m_autoResizeColumnListener == null) {
                    this.m_autoResizeColumnListener = new P_SwtResizeListener();
                    parent.addListener(11, this.m_autoResizeColumnListener);
                    this.scheduleHandleAutoResizeColumn();
                }
            } else {
                this.removeAutoResizeColumnListener();
            }
        }
    }

    private void scheduleHandleAutoResizeColumn() {
        this.getSwtField().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SwtScoutTable.this.handleAutoSizeColumns();
            }
        });
    }

    private void removeAutoResizeColumnListener() {
        if (this.m_autoResizeColumnListener == null) {
            return;
        }
        Composite parent = this.getSwtField().getParent();
        parent.removeListener(11, this.m_autoResizeColumnListener);
        this.m_autoResizeColumnListener = null;
    }

    @Override
    protected void handleScoutPropertyChange(String propName, Object newValue) {
        if (propName.equals("headerVisible")) {
            this.setHeaderVisibleFromScout((Boolean)newValue);
        } else if (propName.equals("keyStroks")) {
            this.updateKeyStrokeFormScout();
        } else if (propName.equals("keyboardNavigation")) {
            this.updateKeyboardNavigationFromScout();
        } else if (propName.equals("autoResizeColumns")) {
            this.updateAutoResizeColumnsFromScout();
        } else if (propName.equals("scrollToSelection")) {
            this.updateScrollToSelectionFromScout();
        }
    }

    protected boolean isHandleScoutTableEvent(TableEvent[] a) {
        TableEvent[] tableEventArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            TableEvent element = tableEventArray[n2];
            switch (element.getType()) {
                case 1: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 105: 
                case 200: 
                case 210: 
                case 770: 
                case 780: 
                case 800: 
                case 805: 
                case 830: {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    protected void handleScoutTableEventInSwt(TableEvent e) {
        if (this.isDisposed()) {
            return;
        }
        SwtScoutTableEvent swtTableEvent = null;
        switch (e.getType()) {
            case 800: {
                this.getSwtField().setFocus();
                break;
            }
            case 805: {
                int swtCol = -1;
                TableColumn[] swtColumns = this.getSwtField().getColumns();
                int c = 0;
                while (c < swtColumns.length) {
                    if (swtColumns[c].getData("scoutColumn") == e.getFirstColumn()) {
                        swtCol = c;
                        break;
                    }
                    ++c;
                }
                ITableRow scoutRow = e.getFirstRow();
                if (scoutRow == null || swtCol < 0) break;
                this.getSwtTableViewer().editElement((Object)scoutRow, swtCol);
                break;
            }
            case 830: {
                this.scrollToSelection();
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 200: 
            case 210: {
                swtTableEvent = new SwtScoutTableEvent();
                break;
            }
            case 770: {
                break;
            }
            case 780: {
                this.headerUpdateFromScout();
                break;
            }
            case 1: {
                this.initializeColumns();
                if (((ITable)this.getScoutObject()).isAutoResizeColumns()) {
                    this.handleAutoSizeColumns();
                }
                swtTableEvent = new SwtScoutTableEvent();
                break;
            }
            case 103: {
                this.setSelectionFromScout(e.getRows());
            }
        }
        if (swtTableEvent != null) {
            this.getSwtTableViewer().refresh();
        }
        switch (e.getType()) {
            case 210: {
                TableColumn[] tableColumnArray = this.getSwtField().getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn swtCol = tableColumnArray[n2];
                    this.updateHeaderText(swtCol);
                    ++n2;
                }
                this.setSelectionFromScout(e.getTable().getSelectedRows());
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 200: {
                this.setSelectionFromScout(e.getTable().getSelectedRows());
            }
        }
    }

    private void updateHeaderText(TableColumn swtCol) {
        if (swtCol == null) {
            return;
        }
        Object data = swtCol.getData("scoutColumn");
        if (data instanceof IColumn) {
            this.updateHeaderText(swtCol, (IColumn)data);
        }
    }

    private void updateHeaderText(TableColumn swtCol, IColumn<?> scoutCol) {
        IHeaderCell cell = scoutCol.getHeaderCell();
        String text = cell.getText();
        if (text == null) {
            text = "";
        }
        if (scoutCol.isColumnFilterActive()) {
            text = "((" + text + "))";
        }
        swtCol.setText(text);
    }

    private void updateScrollToSelectionFromScout() {
        if (((ITable)this.getScoutObject()).isScrollToSelection()) {
            this.scrollToSelection();
        }
    }

    protected void scrollToSelection() {
        this.getSwtField().showSelection();
    }

    protected void setHeaderVisibleFromScout(boolean headerVisible) {
        this.getSwtField().setHeaderVisible(headerVisible);
    }

    @Override
    public void setEnabledFromScout(boolean enabledFromScout) {
        this.getSwtField().setReadOnly(!enabledFromScout);
    }

    protected void setSelectionFromScout(ITableRow[] selectedRows) {
        if (this.getSwtField().isDisposed()) {
            return;
        }
        ITableRow[] uiSelection = this.getSwtSelectedRows();
        if (CompareUtility.equals((Object)uiSelection, (Object)selectedRows)) {
            return;
        }
        if (selectedRows == null) {
            selectedRows = new ITableRow[]{};
        }
        this.getSwtTableViewer().setSelection((ISelection)new StructuredSelection((Object[])selectedRows), true);
        if (selectedRows.length > 0) {
            this.getSwtTableViewer().reveal((Object)selectedRows[0]);
        }
        if (((ITable)this.getScoutObject()).isScrollToSelection()) {
            this.scrollToSelection();
        }
    }

    protected void setContextColumnFromSwt(TableColumn swtColumn) {
        if (this.getScoutObject() != null && swtColumn != null) {
            Point pDisp = this.getSwtField().toDisplay(-this.getSwtField().getHorizontalBar().getSelection(), 0);
            TableColumn[] tableColumnArray = this.getSwtField().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn c = tableColumnArray[n2];
                if (c == swtColumn) break;
                pDisp.x += c.getWidth();
                ++n2;
            }
            this.getEnvironment().setPopupOwner((Control)this.getSwtField(), new Rectangle(pDisp.x - 2, pDisp.y, 1, this.getSwtField().getHeaderHeight()));
            final IColumn finalCol = (IColumn)swtColumn.getData("scoutColumn");
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITable)SwtScoutTable.this.getScoutObject()).getUIFacade().setContextColumnFromUI(finalCol);
                }
            };
            this.getEnvironment().invokeScoutLater(t, 0L);
        }
    }

    private int getVisualCellIndex(TableItem tableItem, int columnIndex) {
        int[] columnOrder;
        int visualCellIndex = columnIndex;
        int[] nArray = columnOrder = tableItem.getParent().getColumnOrder();
        int n = columnOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            if (element == columnIndex) {
                visualCellIndex = columnIndex;
            }
            ++n2;
        }
        return visualCellIndex;
    }

    private TableColumn getSwtColumnAt(Point p) {
        int[] order;
        Table table = this.getSwtTableViewer().getTable();
        int x = p.x + this.getSwtField().getHorizontalBar().getSelection();
        int[] nArray = order = table.getColumnOrder();
        int n = order.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TableColumn c = table.getColumn(index);
            if (c != null) {
                if (x >= 0 && x <= c.getWidth()) {
                    return c;
                }
                x -= c.getWidth();
            }
            ++n2;
        }
        return null;
    }

    protected void setSelectionFromSwt(final StructuredSelection selection) {
        if (this.getUpdateSwtFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        SwtScoutTable.this.addIgnoredScoutEvent(TableEvent.class, "103");
                        ((ITable)SwtScoutTable.this.getScoutObject()).getUIFacade().setSelectedRowsFromUI(SwtUtility.getItemsOfSelection(ITableRow.class, selection));
                    }
                    finally {
                        SwtScoutTable.this.removeIgnoredScoutEvent(TableEvent.class, "103");
                    }
                }
            };
            this.getEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void headerUpdateFromScout() {
        this.getSwtField().setSortColumn(null);
        TableColumn[] tableColumnArray = this.getSwtField().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn cell;
            TableColumn col = tableColumnArray[n2];
            Object data = col.getData("scoutColumn");
            if (data instanceof IColumn && (cell = (IColumn)data).isSortExplicit()) {
                this.getSwtField().setSortColumn(col);
                this.getSwtField().setSortDirection(cell.isSortAscending() ? 128 : 1024);
            }
            ++n2;
        }
    }

    protected void handleSwtRowClick(final ITableRow row) {
        if (this.getScoutObject() != null && row != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITable)SwtScoutTable.this.getScoutObject()).getUIFacade().fireRowClickFromUI(row);
                }
            };
            this.getEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void handleSwtRowAction(final ITableRow row) {
        if (this.getScoutObject() != null && !((ITable)this.getScoutObject()).isCheckable() && row != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITable)SwtScoutTable.this.getScoutObject()).getUIFacade().fireRowActionFromUI(row);
                }
            };
            this.getEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void handleSwtHyperlinkAction(final ITableRow row, final IColumn col, final URL url) {
        if (this.getScoutObject() != null && row != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITable)SwtScoutTable.this.getScoutObject()).getUIFacade().fireHyperlinkActionFromUI(row, col, url);
                }
            };
            this.getEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void handleAutoSizeColumns() {
        int width;
        if (this.getSwtField() == null || this.getSwtField().isDisposed()) {
            return;
        }
        int totalWidth = this.getSwtField().getClientArea().width;
        if (this.getSwtField().getVerticalBar() != null) {
            this.getSwtField().getVerticalBar().getVisible();
        }
        if (totalWidth < 32) {
            return;
        }
        int totalWeight = 0;
        int actualWidth = 0;
        HashMap<TableColumn, Integer> columnWeights = new HashMap<TableColumn, Integer>();
        TableColumn[] tableColumnArray = this.getSwtField().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            if (col != null && !col.isDisposed()) {
                actualWidth += col.getWidth();
                Object data = col.getData("scoutColumn");
                if (data instanceof IColumn) {
                    width = ((IColumn)data).getInitialWidth();
                    columnWeights.put(col, width);
                    totalWeight += width;
                } else {
                    totalWidth -= col.getWidth();
                }
            }
            ++n2;
        }
        if (actualWidth == totalWidth) {
            return;
        }
        double factor = (double)totalWidth / (double)totalWeight;
        if (factor < 1.0) {
            factor = 1.0;
        }
        int i = 0;
        for (Map.Entry entry : columnWeights.entrySet()) {
            if (i < columnWeights.size() - 1) {
                width = (int)(factor * (double)((Integer)entry.getValue()).intValue());
                ((TableColumn)entry.getKey()).setWidth(width);
                totalWidth -= width;
                ++i;
                continue;
            }
            width = Math.max(totalWidth, (Integer)entry.getValue());
            ((TableColumn)entry.getKey()).setWidth(width);
        }
    }

    protected void handleSwtColumnResized(TableColumn column) {
        if (column.isDisposed()) {
            return;
        }
        if (!column.getParent().isVisible()) {
            return;
        }
        if (this.getUpdateSwtFromScoutLock().isAcquired()) {
            return;
        }
        final int width = column.getWidth();
        final IColumn scoutColumn = (IColumn)column.getData("scoutColumn");
        if (scoutColumn != null && scoutColumn.getWidth() != width) {
            if (this.m_storeColumnWidthsJob != null) {
                this.m_storeColumnWidthsJob.cancel();
            }
            this.m_storeColumnWidthsJob = new ClientSyncJob("Store column widths", this.getEnvironment().getClientSession()){

                protected IStatus runStatus(IProgressMonitor monitor) {
                    try {
                        SwtScoutTable.this.addIgnoredScoutEvent(TableEvent.class, "1");
                        ((ITable)SwtScoutTable.this.getScoutObject()).getUIFacade().setColumnWidthFromUI(scoutColumn, width);
                    }
                    finally {
                        SwtScoutTable.this.removeIgnoredScoutEvent(TableEvent.class, "1");
                    }
                    return Status.OK_STATUS;
                }
            };
            this.m_storeColumnWidthsJob.schedule(400L);
        }
    }

    protected TransferObject handleSwtCopyRequest() {
        if (this.getUpdateSwtFromScoutLock().isAcquired()) {
            return null;
        }
        final Holder result = new Holder(TransferObject.class, null);
        if (this.getScoutObject() != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    if (!ACCESS.check((Permission)new CopyToClipboardPermission())) {
                        return;
                    }
                    TransferObject scoutTransferable = ((ITable)SwtScoutTable.this.getScoutObject()).getUIFacade().fireRowsCopyRequestFromUI();
                    result.setValue((Object)scoutTransferable);
                }
            };
            try {
                this.getEnvironment().invokeScoutLater(t, 20000L).join(20000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return (TransferObject)result.getValue();
    }

    protected void handleSwtColumnMoved() {
        if (this.getUpdateSwtFromScoutLock().isAcquired()) {
            return;
        }
        int[] uiColumnOrder = this.getSwtField().getColumnOrder();
        if (uiColumnOrder[0] != 0) {
            this.getSwtField().setColumnOrder(this.m_uiColumnOrder);
            return;
        }
        if (uiColumnOrder[1] != this.m_uiColumnOrder[1] && ((ITable)this.getScoutObject()).getRowCount() > 0 && StringUtility.hasText((String)((ITable)this.getScoutObject()).getRow(0).getIconId())) {
            this.getSwtTableViewer().refresh();
        }
        int[] truncatedColOrder = new int[uiColumnOrder.length - 1];
        int i = 0;
        while (i < truncatedColOrder.length) {
            truncatedColOrder[i] = uiColumnOrder[i + 1] - 1;
            ++i;
        }
        final IColumn<?>[] newOrder = this.m_columnManager.getOrderedColumns(truncatedColOrder);
        if (this.m_columnManager.applyNewOrder(newOrder)) {
            this.m_uiColumnOrder = uiColumnOrder;
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        SwtScoutTable.this.addIgnoredScoutEvent(TableEvent.class, "770");
                        SwtScoutTable.this.addIgnoredScoutEvent(TableEvent.class, "1");
                        ((ITable)SwtScoutTable.this.getScoutObject()).getUIFacade().fireVisibleColumnsChangedFromUI(newOrder);
                    }
                    finally {
                        SwtScoutTable.this.removeIgnoredScoutEvent(TableEvent.class, "770");
                        SwtScoutTable.this.removeIgnoredScoutEvent(TableEvent.class, "1");
                    }
                }
            };
            this.getEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void handleKeyboardNavigationFromSwt(TableItem item) {
        if (((ITable)this.getScoutObject()).isCheckable()) {
            return;
        }
        this.getSwtField().setSelection(item);
        Event selectionEvent = new Event();
        selectionEvent.type = 14;
        selectionEvent.widget = this.getSwtField();
        Listener[] listenerArray = this.getSwtField().getListeners(14);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Listener l = listenerArray[n2];
            l.handleEvent(selectionEvent);
            ++n2;
        }
    }

    private class P_ColumnSortListener
    extends SelectionAdapter {
        private P_ColumnSortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn col = (TableColumn)e.getSource();
            SwtScoutTable.this.setContextColumnFromSwt(col);
            final IColumn newColumn = (IColumn)col.getData("scoutColumn");
            if (SwtScoutTable.this.getScoutObject() != null) {
                Runnable job = new Runnable(){

                    @Override
                    public void run() {
                        ((ITable)SwtScoutTable.this.getScoutObject()).getUIFacade().fireHeaderSortFromUI(newColumn, false);
                    }
                };
                SwtScoutTable.this.getEnvironment().invokeScoutLater(job, 0L);
            }
        }
    }

    private class P_ContextMenuListener
    extends MenuAdapter {
        private P_ContextMenuListener() {
        }

        public void menuShown(MenuEvent e) {
            if (SwtScoutTable.this.m_contextMenu != null) {
                MenuItem[] menuItemArray = SwtScoutTable.this.m_contextMenu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    this.disposeMenuItem(item);
                    ++n2;
                }
            }
            boolean emptySelection = SwtScoutTable.this.getSwtTableViewer().getSelection().isEmpty();
            IMenu[] menus = SwtMenuUtility.collectMenus((ITable)SwtScoutTable.this.getScoutObject(), emptySelection, !emptySelection, SwtScoutTable.this.getEnvironment());
            SwtMenuUtility.fillContextMenu(menus, SwtScoutTable.this.m_contextMenu, SwtScoutTable.this.getEnvironment());
        }

        private void disposeMenuItem(MenuItem item) {
            Menu menu = item.getMenu();
            if (menu != null) {
                MenuItem[] menuItemArray = menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem childItem = menuItemArray[n2];
                    this.disposeMenuItem(childItem);
                    ++n2;
                }
                menu.dispose();
            }
            item.dispose();
        }
    }

    private class P_DndSupport
    extends AbstractSwtScoutDndSupport {
        public P_DndSupport(IPropertyObserver scoutObject, IDNDSupport scoutDndSupportable, Control control, ISwtEnvironment environment) {
            super(scoutObject, scoutDndSupportable, control, environment);
        }

        @Override
        protected TransferObject handleSwtDragRequest() {
            final Holder result = new Holder(TransferObject.class, null);
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    TransferObject scoutTransferable = ((ITable)SwtScoutTable.this.getScoutObject()).getUIFacade().fireRowsDragRequestFromUI();
                    result.setValue((Object)scoutTransferable);
                }
            };
            try {
                SwtScoutTable.this.getEnvironment().invokeScoutLater(t, 20000L).join(20000L);
            }
            catch (InterruptedException interruptedException) {}
            return (TransferObject)result.getValue();
        }

        @Override
        protected void handleSwtDropAction(DropTargetEvent event, final TransferObject scoutTransferObject) {
            Object dropTarget = event.item != null ? event.item.getData() : null;
            final ITableRow row = dropTarget instanceof ITableRow ? (ITableRow)dropTarget : null;
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    ((ITable)SwtScoutTable.this.getScoutObject()).getUIFacade().fireRowDropActionFromUI(row, scoutTransferObject);
                }
            };
            SwtScoutTable.this.getEnvironment().invokeScoutLater(job, 200L);
        }
    }

    private class P_KeyBoardNavigationSupport
    extends TableKeyboardNavigationSupport {
        public P_KeyBoardNavigationSupport(TableEx table) {
            super(table);
        }

        @Override
        void handleKeyboardNavigation(TableItem tableItem) {
            SwtScoutTable.this.handleKeyboardNavigationFromSwt(tableItem);
        }
    }

    private class P_ScoutTableListener
    implements TableListener {
        private P_ScoutTableListener() {
        }

        public void tableChanged(final TableEvent e) {
            if (SwtScoutTable.this.isHandleScoutTableEvent(new TableEvent[]{e})) {
                if (SwtScoutTable.this.isIgnoredScoutEvent(TableEvent.class, "" + e.getType())) {
                    return;
                }
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SwtScoutTable.this.getUpdateSwtFromScoutLock().acquire();
                            SwtScoutTable.this.handleScoutTableEventInSwt(e);
                        }
                        finally {
                            SwtScoutTable.this.getUpdateSwtFromScoutLock().release();
                        }
                    }
                };
                SwtScoutTable.this.getEnvironment().invokeSwtLater(t);
            }
        }

        public void tableChangedBatch(TableEvent[] a) {
            if (SwtScoutTable.this.isHandleScoutTableEvent(a)) {
                final ArrayList<TableEvent> filteredList = new ArrayList<TableEvent>();
                int i = 0;
                while (i < a.length) {
                    if (!SwtScoutTable.this.isIgnoredScoutEvent(TableEvent.class, "" + a[i].getType())) {
                        filteredList.add(a[i]);
                    }
                    ++i;
                }
                if (filteredList.size() == 0) {
                    return;
                }
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        if (SwtScoutTable.this.isDisposed()) {
                            return;
                        }
                        SwtScoutTable.this.m_redrawHandler.pushControlChanging();
                        try {
                            try {
                                SwtScoutTable.this.getUpdateSwtFromScoutLock().acquire();
                                for (TableEvent element : filteredList) {
                                    SwtScoutTable.this.handleScoutTableEventInSwt(element);
                                }
                            }
                            finally {
                                SwtScoutTable.this.getUpdateSwtFromScoutLock().release();
                            }
                        }
                        finally {
                            SwtScoutTable.this.m_redrawHandler.popControlChanging();
                        }
                    }
                };
                SwtScoutTable.this.getEnvironment().invokeSwtLater(t);
            }
        }
    }

    private class P_SwtHeaderMenuDetectListener
    implements MenuDetectListener {
        private P_SwtHeaderMenuDetectListener() {
        }

        public void menuDetected(MenuDetectEvent event) {
            boolean header;
            TableEx table = SwtScoutTable.this.getSwtField();
            Point pTable = table.getDisplay().map(null, (Control)table, new Point(event.x, event.y));
            Rectangle clientArea = table.getClientArea();
            boolean bl = header = clientArea.y <= pTable.y && pTable.y < clientArea.y + table.getHeaderHeight();
            if (!header) {
                return;
            }
            if (SwtScoutTable.this.m_headerMenu != null) {
                MenuItem[] menuItemArray = SwtScoutTable.this.m_headerMenu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    this.disposeMenuItem(item);
                    ++n2;
                }
            }
            SwtScoutTable.this.setContextColumnFromSwt(SwtScoutTable.this.getSwtColumnAt(pTable));
            final AtomicReference scoutMenusRef = new AtomicReference();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    IMenu[] scoutMenus = ((ITable)SwtScoutTable.this.getScoutObject()).getUIFacade().fireHeaderPopupFromUI();
                    scoutMenusRef.set(scoutMenus);
                }
            };
            JobEx job = SwtScoutTable.this.getEnvironment().invokeScoutLater(t, 1200L);
            try {
                job.join(1200L);
            }
            catch (InterruptedException interruptedException) {}
            if (scoutMenusRef.get() != null) {
                SwtMenuUtility.fillContextMenu((IMenu[])scoutMenusRef.get(), SwtScoutTable.this.m_headerMenu, SwtScoutTable.this.getEnvironment());
            }
        }

        private void disposeMenuItem(MenuItem item) {
            Menu menu = item.getMenu();
            if (menu != null) {
                MenuItem[] menuItemArray = menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem childItem = menuItemArray[n2];
                    this.disposeMenuItem(childItem);
                    ++n2;
                }
                menu.dispose();
            }
            item.dispose();
        }
    }

    private class P_SwtResizeListener
    implements Listener {
        private P_SwtResizeListener() {
        }

        public void handleEvent(Event event) {
            if (SwtScoutTable.this.getSwtField() != null && !SwtScoutTable.this.getSwtField().isDisposed()) {
                SwtScoutTable.this.scheduleHandleAutoResizeColumn();
            }
        }
    }

    public class P_SwtSelectionListener
    implements ISelectionChangedListener {
        public void selectionChanged(SelectionChangedEvent event) {
            SwtScoutTable.this.setSelectionFromSwt((StructuredSelection)event.getSelection());
        }
    }

    private class P_SwtTableListener
    implements Listener {
        private P_SwtTableListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 3: {
                    SwtScoutTable.this.setContextColumnFromSwt(SwtScoutTable.this.getSwtColumnAt(new Point(event.x, event.y)));
                    if (SwtScoutTable.this.getSwtField().getItem(new Point(event.x, event.y)) != null) break;
                    SwtScoutTable.this.getSwtTableViewer().setSelection(null);
                    SwtScoutTable.this.setSelectionFromSwt(new StructuredSelection());
                    break;
                }
                case 4: {
                    StructuredSelection selection;
                    if (event.count != 1 || (selection = (StructuredSelection)SwtScoutTable.this.getSwtTableViewer().getSelection()).size() != 1) break;
                    SwtScoutTable.this.handleSwtRowClick((ITableRow)selection.getFirstElement());
                    break;
                }
                case 8: {
                    StructuredSelection selection = (StructuredSelection)SwtScoutTable.this.getSwtTableViewer().getSelection();
                    if (selection.size() != 1) break;
                    SwtScoutTable.this.handleSwtRowAction((ITableRow)selection.getFirstElement());
                    break;
                }
                case 35: {
                    Point pt = SwtScoutTable.this.getSwtField().getDisplay().map(null, (Control)SwtScoutTable.this.getSwtField(), new Point(event.x, event.y));
                    Rectangle clientArea = SwtScoutTable.this.getSwtField().getClientArea();
                    boolean header = clientArea.y <= pt.y && pt.y < clientArea.y + SwtScoutTable.this.getSwtField().getHeaderHeight();
                    SwtScoutTable.this.getSwtField().setMenu(header ? SwtScoutTable.this.m_headerMenu : SwtScoutTable.this.m_contextMenu);
                    break;
                }
                case 2: {
                    if (!event.doit || !((ITable)SwtScoutTable.this.getScoutObject()).isCheckable() || event.stateMask != 0) break;
                    switch (event.keyCode) {
                        case 13: 
                        case 32: {
                            ITableRow[] selectedRows = SwtUtility.getItemsOfSelection(ITableRow.class, (StructuredSelection)SwtScoutTable.this.getSwtTableViewer().getSelection());
                            if (selectedRows != null && selectedRows.length > 0) {
                                SwtScoutTable.this.handleSwtRowClick(selectedRows[0]);
                            }
                            event.doit = false;
                        }
                    }
                }
            }
        }
    }

    private class P_TableColumnListener
    implements Listener {
        private P_TableColumnListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 10: {
                    SwtScoutTable.this.handleSwtColumnMoved();
                    break;
                }
                case 11: {
                    if (!(event.widget instanceof TableColumn)) break;
                    SwtScoutTable.this.handleSwtColumnResized((TableColumn)event.widget);
                }
            }
        }
    }
}

