/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.table;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SwtScoutTooltipSupport
extends DefaultToolTip {
    private Cell cell;
    private ColumnViewer viewer;

    protected SwtScoutTooltipSupport(ColumnViewer viewer, int style, boolean manualActivation) {
        super(viewer.getControl(), style, manualActivation);
        this.viewer = viewer;
    }

    protected Object getToolTipArea(Event event) {
        Table table = (Table)event.widget;
        int columns = table.getColumnCount();
        Point point = new Point(event.x, event.y);
        TableItem item = table.getItem(point);
        if (item != null) {
            int i = 0;
            while (i < columns) {
                if (item.getBounds(i).contains(point)) {
                    this.cell = new Cell((Item)item, i);
                    return this.cell;
                }
                ++i;
            }
        }
        return null;
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FillLayout());
        Text b = new Text(comp, 2);
        b.setText(((ITableLabelProvider)this.viewer.getLabelProvider()).getColumnText(this.cell.getData(), this.cell.index));
        return comp;
    }

    public static void enableFor(ColumnViewer viewer) {
        new SwtScoutTooltipSupport(viewer, 2, false);
    }

    private static class Cell {
        private Item item;
        private int index;

        public Cell(Item item, int index) {
            this.item = item;
            this.index = index;
        }

        public Object getData() {
            return this.item.getData();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.index;
            result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Cell other = (Cell)obj;
            if (this.index != other.index) {
                return false;
            }
            return !(this.item == null ? other.item != null : !this.item.equals(other.item));
        }
    }
}

