/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.table;

import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;

public class TableColumnManager {
    private IColumn<?>[] m_initialColumns;
    private IColumn<?>[] m_currentOrder;

    public void initialize(IColumn<?>[] initialColumns) {
        this.m_initialColumns = initialColumns;
        this.m_currentOrder = this.m_initialColumns;
    }

    public IColumn<?>[] getOrderedColumns(int[] columnOrder) {
        IColumn[] columns = new IColumn[columnOrder.length];
        int i = 0;
        while (i < columnOrder.length) {
            columns[i] = this.m_initialColumns[columnOrder[i]];
            ++i;
        }
        return columns;
    }

    public boolean applyNewOrder(IColumn<?>[] newOrder) {
        if (CompareUtility.equals(newOrder, this.m_currentOrder)) {
            return false;
        }
        this.m_currentOrder = newOrder;
        return true;
    }

    public IColumn<?> getColumnByModelIndex(int modelIndex) {
        if (modelIndex >= 0 && modelIndex < this.m_initialColumns.length) {
            return this.m_initialColumns[modelIndex];
        }
        return null;
    }

    public IColumn<?> getColumnByVisualIndex(int visualIndex) {
        if (visualIndex - 1 >= 0 && visualIndex - 1 < this.m_currentOrder.length) {
            return this.m_currentOrder[visualIndex - 1];
        }
        return null;
    }

    public boolean isIconColumn(int columnIndex) {
        return false;
    }
}

