/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.table.internal;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public final class SnippetForTableHeaderMenu {
    static String[][] files = new String[][]{{"ver.txt", "1 KB", "Text Document", "28/09/2005 9:57 AM", "admin"}, {"Thumbs.db", "76 KB", "Data Base file", "13/03/2006 3:56 PM", "john"}, {"daddy.bmp", "148 MB", "Bitmap", "27/10/2008 1:34 PM", "bill"}, {"io.sys", "48 KB", "File System", "16/12/2008 6:14 AM", "admin"}, {"Programs", "0 KB", "File Folder", "04/02/2009 12:18 PM", "anne"}, {"test.rnd", "55 MB", "RND File", "19/02/2009 5:49 PM", "john"}, {"arial.ttf", "94 KB", "True Type Font", "25/08/2008 1:25 PM", "john"}};

    private SnippetForTableHeaderMenu() {
    }

    static void createMenuItem(Menu parent, final TableColumn column) {
        final MenuItem itemName = new MenuItem(parent, 32);
        itemName.setText(column.getText());
        itemName.setSelection(column.getResizable());
        itemName.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (itemName.getSelection()) {
                    column.setWidth(150);
                    column.setResizable(true);
                } else {
                    column.setWidth(0);
                    column.setResizable(false);
                }
            }
        });
    }

    public static void main(String[] args) {
        final Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        final Table table = new Table((Composite)shell, 2816);
        table.setHeaderVisible(true);
        final Menu headerMenu = new Menu((Decorations)shell, 8);
        TableColumn columnName = new TableColumn(table, 0);
        columnName.setText("Name");
        columnName.setWidth(150);
        SnippetForTableHeaderMenu.createMenuItem(headerMenu, columnName);
        TableColumn columnSize = new TableColumn(table, 0);
        columnSize.setText("Size");
        columnSize.setWidth(150);
        SnippetForTableHeaderMenu.createMenuItem(headerMenu, columnSize);
        TableColumn columnType = new TableColumn(table, 0);
        columnType.setText("Type");
        columnType.setWidth(150);
        SnippetForTableHeaderMenu.createMenuItem(headerMenu, columnType);
        TableColumn columnDate = new TableColumn(table, 0);
        columnDate.setText("Date");
        columnDate.setWidth(150);
        SnippetForTableHeaderMenu.createMenuItem(headerMenu, columnDate);
        TableColumn columnOwner = new TableColumn(table, 0);
        columnOwner.setText("Owner");
        columnOwner.setWidth(0);
        columnOwner.setResizable(false);
        SnippetForTableHeaderMenu.createMenuItem(headerMenu, columnOwner);
        String[][] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String[] file = stringArray[n2];
            TableItem item = new TableItem(table, 0);
            item.setText(file);
            ++n2;
        }
        final Menu tableMenu = new Menu((Decorations)shell, 8);
        MenuItem item = new MenuItem(tableMenu, 8);
        item.setText("Open");
        item = new MenuItem(tableMenu, 8);
        item.setText("Open With");
        new MenuItem(tableMenu, 2);
        item = new MenuItem(tableMenu, 8);
        item.setText("Cut");
        item = new MenuItem(tableMenu, 8);
        item.setText("Copy");
        item = new MenuItem(tableMenu, 8);
        item.setText("Paste");
        new MenuItem(tableMenu, 2);
        item = new MenuItem(tableMenu, 8);
        item.setText("Delete");
        table.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                System.out.println(event.x + "," + event.y);
                Point pt = display.map(null, (Control)table, new Point(event.x, event.y));
                Rectangle clientArea = table.getClientArea();
                boolean header = clientArea.y <= pt.y && pt.y < clientArea.y + table.getHeaderHeight();
                table.setMenu(header ? headerMenu : tableMenu);
            }
        });
        table.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                headerMenu.dispose();
                tableMenu.dispose();
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

