/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.busy;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class AnimatedBusyImage
implements Runnable {
    private static final int IMAGE_COUNT = 8;
    private static final int MILLISECONDS_OF_DELAY = 100;
    private static final Image[] animatedImage = new Image[8];
    private final Display m_display;
    private boolean m_busy;
    private int m_animationIndex;

    static {
        int i = 0;
        while (i < animatedImage.length) {
            AnimatedBusyImage.animatedImage[i] = AnimatedBusyImage.createImage("$nl$/icons/progress/ani/" + (i + 1) + ".png");
            ++i;
        }
    }

    private static Image createImage(String subPath) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.forms");
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(subPath), null);
        if (url == null) {
            return null;
        }
        try {
            url = FileLocator.resolve((URL)url);
            return ImageDescriptor.createFromURL((URL)url).createImage();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public AnimatedBusyImage(Display display) {
        this.m_display = display;
    }

    public synchronized void setBusy(boolean b) {
        if (this.m_busy == b) {
            return;
        }
        this.m_busy = b;
        if (this.m_busy) {
            this.m_animationIndex = 0;
            this.m_display.timerExec(100, (Runnable)this);
        }
    }

    public boolean isBusy() {
        return this.m_busy;
    }

    protected void notifyImage(Image image) {
    }

    @Override
    public synchronized void run() {
        if (!this.m_busy) {
            return;
        }
        this.notifyImage(animatedImage[this.m_animationIndex]);
        this.m_animationIndex = (this.m_animationIndex + 1) % 8;
        this.m_display.timerExec(100, (Runnable)this);
    }
}

