/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.busy.strategy.workbench;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.busy.BusyJob;
import org.eclipse.scout.rt.client.busy.IBusyHandler;
import org.eclipse.scout.rt.ui.swt.busy.SwtBusyHandler;
import org.eclipse.scout.rt.ui.swt.busy.strategy.workbench.SwtScoutPartBlockingDecorator;
import org.eclipse.scout.rt.ui.swt.window.ISwtScoutPart;
import org.eclipse.swt.widgets.Display;

public class BlockPartsJob
extends BusyJob {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BlockPartsJob.class);
    private final List<ISwtScoutPart> m_parts;

    public BlockPartsJob(String name, SwtBusyHandler handler, List<ISwtScoutPart> parts) {
        super(name, (IBusyHandler)handler);
        this.setSystem(true);
        this.m_parts = parts;
    }

    protected SwtBusyHandler getBusyHandler() {
        return (SwtBusyHandler)super.getBusyHandler();
    }

    protected void runBusy(IProgressMonitor monitor) {
    }

    protected void runBlocking(final IProgressMonitor monitor) {
        if (this.m_parts == null || this.m_parts.size() == 0) {
            return;
        }
        final ArrayList decoList = new ArrayList();
        Display display = this.getBusyHandler().getDisplay();
        try {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    ISwtScoutPart activePart = (ISwtScoutPart)BlockPartsJob.this.m_parts.get(0);
                    for (ISwtScoutPart p : BlockPartsJob.this.m_parts) {
                        if (p == null) continue;
                        decoList.add(new SwtScoutPartBlockingDecorator(p, p == activePart));
                    }
                    for (SwtScoutPartBlockingDecorator deco : decoList) {
                        try {
                            deco.attach(monitor);
                        }
                        catch (Exception e1) {
                            LOG.warn("attach", (Throwable)e1);
                        }
                    }
                }
            });
            BlockPartsJob.super.runBlocking(monitor);
        }
        catch (Throwable throwable) {
            display.syncExec(new Runnable(decoList){
                private final /* synthetic */ ArrayList val$decoList;
                {
                    this.val$decoList = arrayList;
                }

                @Override
                public void run() {
                    for (SwtScoutPartBlockingDecorator deco : this.val$decoList) {
                        try {
                            deco.detach();
                        }
                        catch (Exception e1) {
                            LOG.warn("detach", (Throwable)e1);
                        }
                    }
                }
            });
            throw throwable;
        }
        display.syncExec(new /* invalid duplicate definition of identical inner class */);
    }
}

