/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.ext;

import java.util.ArrayList;
import org.eclipse.scout.rt.ui.swt.Activator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public class ButtonEx
extends Button {
    public static final int SELECTION_ACTION = 44;
    public static final int SELECTION_MENU = 45;
    private boolean m_hasDropDown;
    private boolean m_dropDownEnabled;
    private Object m_listenerLock = new Object();
    private Listener[] m_actionSelectionListener;
    private Listener[] m_menuSelectionListener;
    private Image m_dropDownIcon;
    private P_DropDownPaintListener m_dropDownPaintListener;
    private Listener m_paintListener = new Listener(){

        public void handleEvent(Event event) {
            ButtonEx.this.redraw();
        }
    };

    public ButtonEx(Composite parent, int style) {
        super(parent, style);
        this.m_dropDownIcon = Activator.getIcon("dropdownfield_arrowdown");
        P_DelegateSelectionListener delegateListener = new P_DelegateSelectionListener();
        if ((style & 4) != 0) {
            this.m_hasDropDown = true;
            this.m_dropDownPaintListener = new P_DropDownPaintListener();
            this.addPaintListener(this.m_dropDownPaintListener);
            super.addListener(4, (Listener)delegateListener);
            this.getParent().getParent().addListener(9, this.m_paintListener);
        }
        super.addListener(13, (Listener)delegateListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ButtonEx.this.freeResources();
            }
        });
    }

    public void freeResources() {
        this.getParent().getParent().removeListener(9, this.m_paintListener);
    }

    public void addListener(int eventType, Listener listener) {
        switch (eventType) {
            case 44: {
                this.m_actionSelectionListener = this.addListenerToList(listener, this.m_actionSelectionListener);
                break;
            }
            case 45: {
                this.m_menuSelectionListener = this.addListenerToList(listener, this.m_menuSelectionListener);
                break;
            }
            default: {
                super.addListener(eventType, listener);
            }
        }
    }

    public void removeListener(int eventType, Listener listener) {
        switch (eventType) {
            case 44: {
                this.m_actionSelectionListener = this.removeListenerFromList(listener, this.m_actionSelectionListener);
                break;
            }
            case 45: {
                this.m_menuSelectionListener = this.removeListenerFromList(listener, this.m_menuSelectionListener);
                break;
            }
            default: {
                super.removeListener(eventType, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Listener[] addListenerToList(Listener l, Listener[] arr) {
        Object object = this.m_listenerLock;
        synchronized (object) {
            if (arr == null) {
                arr = new Listener[]{l};
            } else {
                Listener[] newArr = new Listener[arr.length + 1];
                System.arraycopy(arr, 0, newArr, 0, arr.length);
                arr = newArr;
                arr[arr.length - 1] = l;
            }
            return arr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Listener[] removeListenerFromList(Listener l, Listener[] arr) {
        Object object = this.m_listenerLock;
        synchronized (object) {
            if (arr == null) {
                return arr;
            }
            ArrayList<Listener> newList = new ArrayList<Listener>();
            Listener[] listenerArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                Listener ref = listenerArray[n2];
                if (!ref.equals(l)) {
                    newList.add(ref);
                }
                ++n2;
            }
            arr = newList.toArray(new Listener[newList.size()]);
            return arr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMenuSelection(Event e) {
        int backupedType = e.type;
        try {
            e.type = 45;
            Object object = this.m_listenerLock;
            synchronized (object) {
                if (this.m_menuSelectionListener != null) {
                    Listener[] listenerArray = this.m_menuSelectionListener;
                    int n = this.m_menuSelectionListener.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Listener l = listenerArray[n2];
                        l.handleEvent(e);
                        ++n2;
                    }
                }
            }
        }
        finally {
            e.type = backupedType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionSelection(Event e) {
        if (this.m_actionSelectionListener != null) {
            int backupedType = e.type;
            try {
                e.type = 44;
                Object object = this.m_listenerLock;
                synchronized (object) {
                    Listener[] listenerArray = this.m_actionSelectionListener;
                    int n = this.m_actionSelectionListener.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Listener l = listenerArray[n2];
                        l.handleEvent(e);
                        ++n2;
                    }
                }
            }
            finally {
                e.type = backupedType;
            }
        }
    }

    public void setDropDownEnabled(boolean enabled) {
        this.m_dropDownEnabled = enabled;
    }

    public boolean isDropDownEnabled() {
        return this.m_dropDownEnabled;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public Point computeSize(int hint, int hint2, boolean changed) {
        Point computedSize = super.computeSize(hint, hint2, changed);
        Point p = new Point(computedSize.x, computedSize.y);
        if (this.m_hasDropDown) {
            p.x += 12;
        }
        return p;
    }

    protected void checkSubclass() {
    }

    protected void handleButtonSelection(Event event) {
        this.fireActionSelection(event);
    }

    protected void handlePopupSelectionEvent(Event e) {
        Menu menu;
        if (this.m_dropDownEnabled && (menu = this.getMenu()) != null) {
            menu.setVisible(true);
        }
        this.fireMenuSelection(e);
    }

    private class P_DelegateSelectionListener
    implements Listener {
        private long timeLastEvent = 0L;

        private P_DelegateSelectionListener() {
        }

        public void handleEvent(Event event) {
            block0 : switch (event.type) {
                case 4: {
                    if (this.timeLastEvent == (long)event.time) {
                        return;
                    }
                    this.timeLastEvent = event.time;
                    switch (event.button) {
                        case 1: {
                            if (event.x > ButtonEx.this.getBounds().width - 12) {
                                ButtonEx.this.handlePopupSelectionEvent(event);
                                break block0;
                            }
                            ButtonEx.this.handleButtonSelection(event);
                            break block0;
                        }
                        case 3: {
                            break block0;
                        }
                    }
                    break;
                }
                case 13: {
                    if (this.timeLastEvent == (long)event.time) {
                        return;
                    }
                    this.timeLastEvent = event.time;
                    ButtonEx.this.handleButtonSelection(event);
                }
            }
        }
    }

    private class P_DropDownPaintListener
    implements PaintListener {
        private P_DropDownPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            gc.setAdvanced(true);
            if (ButtonEx.this.m_dropDownEnabled) {
                gc.setForeground(ButtonEx.this.getDisplay().getSystemColor(24));
                gc.setBackground(ButtonEx.this.getDisplay().getSystemColor(24));
            } else {
                gc.setForeground(ButtonEx.this.getDisplay().getSystemColor(18));
                gc.setBackground(ButtonEx.this.getDisplay().getSystemColor(18));
            }
            Rectangle bounds = ButtonEx.this.getBounds();
            gc.drawLine(bounds.width - 12, 3, bounds.width - 12, bounds.height - 4);
            gc.drawImage(ButtonEx.this.m_dropDownIcon, bounds.width - 11, (bounds.height - ((ButtonEx)ButtonEx.this).m_dropDownIcon.getBounds().height) / 2);
        }
    }
}

