/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.checkbox;

import org.eclipse.scout.commons.BooleanUtility;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.ui.swt.LogicalGridData;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.ext.ILabelComposite;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.checkbox.ISwtScoutCheckbox;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class SwtScoutCheckbox
extends SwtScoutValueFieldComposite<IBooleanField>
implements ISwtScoutCheckbox {
    private P_SwtButtonListener m_swtButtonListener;
    private boolean m_mandatoryCached;
    private StatusLabelEx m_labelPlaceholder;
    private boolean m_handleActionPending;

    @Override
    protected void initializeSwt(Composite parent) {
        super.initializeSwt(parent);
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        this.m_labelPlaceholder = new StatusLabelEx(container, 0, this.getEnvironment());
        this.getEnvironment().getFormToolkit().getFormToolkit().adapt((Control)this.m_labelPlaceholder, false, false);
        this.m_labelPlaceholder.setLayoutData(LogicalGridDataBuilder.createLabel(((IBooleanField)this.getScoutObject()).getGridData()));
        Button checkbox = this.getEnvironment().getFormToolkit().createButton(container, "", 32);
        LogicalGridData checkboxData = LogicalGridDataBuilder.createField(((IBooleanField)this.getScoutObject()).getGridData());
        checkboxData.fillHorizontal = false;
        checkboxData.useUiWidth = true;
        checkboxData.weightx = 0.0;
        checkbox.setLayoutData((Object)checkboxData);
        StatusLabelEx dispatcherLabel = new StatusLabelEx(container, 0, this.getEnvironment());
        dispatcherLabel.setVisible(false);
        this.setSwtLabel(dispatcherLabel);
        this.setSwtContainer(container);
        this.setSwtField((Control)checkbox);
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.m_swtButtonListener == null) {
            this.m_swtButtonListener = new P_SwtButtonListener();
        }
        this.getSwtField().addListener(13, (Listener)this.m_swtButtonListener);
    }

    @Override
    protected void setErrorStatusFromScout(IProcessingStatus s) {
        this.m_labelPlaceholder.setStatus(s);
    }

    @Override
    protected void setMandatoryFromScout(boolean b) {
        super.setMandatoryFromScout(b);
        this.updateLabel();
    }

    protected void updateLabel() {
        if (this.getSwtLabel() instanceof StatusLabelEx) {
            StatusLabelEx swtLabel = (StatusLabelEx)this.getSwtLabel();
            if (swtLabel.getText() != null) {
                this.getSwtField().setText(swtLabel.getText());
            }
            this.getSwtField().setFont(swtLabel.getFont());
            this.getSwtField().setForeground(swtLabel.getForeground());
            this.getSwtField().setBackground(swtLabel.getBackground());
        }
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        this.getSwtField().removeListener(13, (Listener)this.m_swtButtonListener);
    }

    @Override
    public Button getSwtField() {
        return (Button)super.getSwtField();
    }

    @Override
    public ILabelComposite getPlaceholderLabel() {
        return this.m_labelPlaceholder;
    }

    @Override
    protected void setLabelVisibleFromScout() {
        boolean b = ((IBooleanField)this.getScoutObject()).isLabelVisible();
        if (this.m_labelPlaceholder != null && b != this.m_labelPlaceholder.getVisible()) {
            this.m_labelPlaceholder.setVisible(b);
            if (this.getSwtContainer() != null && this.isConnectedToScout()) {
                this.getSwtContainer().layout(true, true);
            }
        }
    }

    @Override
    protected void setLabelFromScout(String s) {
        super.setLabelFromScout(s);
        this.updateLabel();
    }

    @Override
    protected void setValueFromScout() {
        this.getSwtField().setSelection(BooleanUtility.nvl(this.getScoutObject() == null ? null : (Boolean)((IBooleanField)this.getScoutObject()).getValue()));
    }

    protected void handleSwtAction() {
        if (this.getSwtField().isEnabled()) {
            final boolean b = this.getSwtField().getSelection();
            if (!this.m_handleActionPending) {
                this.m_handleActionPending = true;
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ((IBooleanField)SwtScoutCheckbox.this.getScoutObject()).getUIFacade().setSelectedFromUI(b);
                        }
                        finally {
                            SwtScoutCheckbox.this.m_handleActionPending = false;
                        }
                    }
                };
                this.getEnvironment().invokeScoutLater(t, 0L);
            }
        }
    }

    private class P_SwtButtonListener
    implements Listener {
        private P_SwtButtonListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 13: {
                    SwtScoutCheckbox.this.handleSwtAction();
                }
            }
        }
    }
}

