/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.services;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.rt.shared.services.common.useractivity.IUserActivityProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class UserActivityProvider
extends AbstractPropertyObserver
implements IUserActivityProvider {
    private long m_idleTrigger = 30000L;
    private boolean m_userActive;
    private UserInactiveJob m_userInactiveJob;
    private Object m_jobLock = new Object();

    public UserActivityProvider() {
        Job job = new Job("UserActivityProvider waiting for workbench"){

            protected IStatus run(IProgressMonitor monitor) {
                if (PlatformUI.isWorkbenchRunning()) {
                    UserActivityProvider.this.attachToDisplay(PlatformUI.getWorkbench().getDisplay());
                } else {
                    this.schedule(1000L);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.schedule(1000L);
    }

    private void attachToDisplay(final Display display) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                display.addFilter(5, new Listener(){

                    public void handleEvent(Event event) {
                        UserActivityProvider.this.userBusy();
                    }
                });
                display.addFilter(1, new Listener(){

                    public void handleEvent(Event event) {
                        UserActivityProvider.this.userBusy();
                    }
                });
            }
        });
    }

    public void initializeService() {
    }

    public boolean isActive() {
        return this.propertySupport.getPropertyBool("active");
    }

    private void setActiveInternal(boolean b) {
        this.m_userActive = b;
        this.propertySupport.setPropertyBool("active", b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void userBusy() {
        Object object = this.m_jobLock;
        synchronized (object) {
            if (!this.m_userActive) {
                this.setActiveInternal(true);
            }
            if (this.m_userInactiveJob == null) {
                this.m_userInactiveJob = new UserInactiveJob();
                this.m_userInactiveJob.schedule(this.m_idleTrigger + 1000L);
            }
            this.m_userInactiveJob.postponed = System.currentTimeMillis() + this.m_idleTrigger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void userIdle() {
        Object object = this.m_jobLock;
        synchronized (object) {
            if (this.m_userInactiveJob != null) {
                long delta = this.m_userInactiveJob.postponed - System.currentTimeMillis();
                if (delta < 1000L) {
                    this.setActiveInternal(false);
                    this.m_userInactiveJob = null;
                } else {
                    this.m_userInactiveJob.schedule(delta);
                }
            }
        }
    }

    private class UserInactiveJob
    extends Job {
        long postponed;

        public UserInactiveJob() {
            super("User activity");
            this.setUser(false);
            this.setSystem(true);
            this.setPriority(50);
        }

        protected IStatus run(IProgressMonitor monitor) {
            UserActivityProvider.this.userIdle();
            return Status.OK_STATUS;
        }
    }
}

