/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.HTMLUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.holders.IHolder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientAsyncJob;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.busy.IBusyHandler;
import org.eclipse.scout.rt.client.busy.IBusyManagerService;
import org.eclipse.scout.rt.client.services.common.exceptionhandler.ErrorHandler;
import org.eclipse.scout.rt.client.services.common.session.IClientSessionRegistryService;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.htmlfield.IHtmlField;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.ui.IUiDeviceType;
import org.eclipse.scout.rt.shared.ui.IUiLayer;
import org.eclipse.scout.rt.shared.ui.UiDeviceType;
import org.eclipse.scout.rt.shared.ui.UiLayer;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.ui.swt.Activator;
import org.eclipse.scout.rt.ui.swt.FormFieldFactory;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironmentListener;
import org.eclipse.scout.rt.ui.swt.SwtEnvironmentEvent;
import org.eclipse.scout.rt.ui.swt.basic.WidgetPrinter;
import org.eclipse.scout.rt.ui.swt.busy.SwtBusyHandler;
import org.eclipse.scout.rt.ui.swt.concurrency.SwtScoutSynchronizer;
import org.eclipse.scout.rt.ui.swt.form.ISwtScoutForm;
import org.eclipse.scout.rt.ui.swt.form.SwtScoutForm;
import org.eclipse.scout.rt.ui.swt.form.fields.ISwtScoutFormField;
import org.eclipse.scout.rt.ui.swt.keystroke.ISwtKeyStroke;
import org.eclipse.scout.rt.ui.swt.keystroke.ISwtKeyStrokeFilter;
import org.eclipse.scout.rt.ui.swt.keystroke.KeyStrokeManager;
import org.eclipse.scout.rt.ui.swt.util.ColorFactory;
import org.eclipse.scout.rt.ui.swt.util.FontRegistry;
import org.eclipse.scout.rt.ui.swt.util.ScoutFormToolkit;
import org.eclipse.scout.rt.ui.swt.util.SwtIconLocator;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.scout.rt.ui.swt.window.ISwtScoutPart;
import org.eclipse.scout.rt.ui.swt.window.SwtScoutPartEvent;
import org.eclipse.scout.rt.ui.swt.window.SwtScoutPartListener;
import org.eclipse.scout.rt.ui.swt.window.desktop.editor.AbstractScoutEditorPart;
import org.eclipse.scout.rt.ui.swt.window.desktop.editor.ScoutFormEditorInput;
import org.eclipse.scout.rt.ui.swt.window.desktop.tray.ISwtScoutTray;
import org.eclipse.scout.rt.ui.swt.window.desktop.tray.SwtScoutTray;
import org.eclipse.scout.rt.ui.swt.window.desktop.view.AbstractScoutView;
import org.eclipse.scout.rt.ui.swt.window.dialog.SwtScoutDialog;
import org.eclipse.scout.rt.ui.swt.window.filechooser.SwtScoutFileChooser;
import org.eclipse.scout.rt.ui.swt.window.messagebox.SwtScoutMessageBoxDialog;
import org.eclipse.scout.rt.ui.swt.window.popup.SwtScoutPopup;
import org.eclipse.scout.service.SERVICES;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.IViewDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public abstract class AbstractSwtEnvironment
extends AbstractPropertyObserver
implements ISwtEnvironment {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(AbstractSwtEnvironment.class);
    private final Bundle m_applicationBundle;
    private final String m_perspectiveId;
    private final Class<? extends IClientSession> m_clientSessionClass;
    private IClientSession m_clientSession;
    private int m_status;
    private SwtScoutSynchronizer m_synchronizer;
    private final Object m_immediateSwtJobsLock = new Object();
    private final List<Runnable> m_immediateSwtJobs = new ArrayList<Runnable>();
    private Clipboard m_clipboard;
    private ColorFactory m_colorFactory;
    private FontRegistry m_fontRegistry;
    private SwtIconLocator m_iconLocator;
    private ISwtScoutTray m_trayComposite;
    private List<ISwtKeyStroke> m_desktopKeyStrokes;
    private KeyStrokeManager m_keyStrokeManager;
    private Control m_popupOwner;
    private Rectangle m_popupOwnerBounds;
    private ScoutFormToolkit m_formToolkit;
    private FormFieldFactory m_formFieldFactory;
    private PropertyChangeSupport m_propertySupport;
    private boolean m_startDesktopCalled;
    private boolean m_activateDesktopCalled;
    private EventListenerList m_environmentListeners;
    private HashMap<String, String> m_scoutPartIdToUiPartId;
    private HashMap<IForm, ISwtScoutPart> m_openForms;
    private P_ScoutDesktopListener m_scoutDesktopListener;
    private P_ScoutDesktopPropertyListener m_desktopPropertyListener;
    private P_PerspectiveListener m_perspectiveListener;
    private Map<String, List<IForm>> openLater = new HashMap<String, List<IForm>>();

    public AbstractSwtEnvironment(Bundle applicationBundle, String perspectiveId, Class<? extends IClientSession> clientSessionClass) {
        this.m_applicationBundle = applicationBundle;
        this.m_perspectiveId = perspectiveId;
        this.m_clientSessionClass = clientSessionClass;
        this.m_environmentListeners = new EventListenerList();
        this.m_scoutPartIdToUiPartId = new HashMap();
        this.m_openForms = new HashMap();
        this.m_propertySupport = new PropertyChangeSupport(this);
        this.m_status = 0;
        this.m_desktopKeyStrokes = new ArrayList<ISwtKeyStroke>();
        this.m_startDesktopCalled = false;
    }

    public Bundle getApplicationBundle() {
        return this.m_applicationBundle;
    }

    private void stopScout() throws CoreException {
        try {
            if (this.m_desktopKeyStrokes != null) {
                for (ISwtKeyStroke swtKeyStroke : this.m_desktopKeyStrokes) {
                    this.removeGlobalKeyStroke(swtKeyStroke);
                }
                this.m_desktopKeyStrokes.clear();
            }
            if (this.m_iconLocator != null) {
                this.m_iconLocator.dispose();
                this.m_iconLocator = null;
            }
            if (this.m_colorFactory != null) {
                this.m_colorFactory.dispose();
                this.m_colorFactory = null;
            }
            this.m_keyStrokeManager = null;
            if (this.m_fontRegistry != null) {
                this.m_fontRegistry.dispose();
                this.m_fontRegistry = null;
            }
            if (this.m_formToolkit != null) {
                this.m_formToolkit.dispose();
                this.m_formToolkit = null;
            }
            this.detachScoutListeners();
            this.detachSWTListeners();
            if (this.m_synchronizer != null) {
                this.m_synchronizer = null;
            }
            this.m_clientSession = null;
            this.m_status = 8;
            this.fireEnvironmentChanged(new SwtEnvironmentEvent(this, 8));
            this.setStartDesktopCalled(false);
        }
        finally {
            if (this.m_status != 8) {
                this.m_status = 2;
                this.fireEnvironmentChanged(new SwtEnvironmentEvent(this, 2));
            }
        }
    }

    @Override
    public void registerPart(String scoutPartLocation, String uiPartId) {
        this.m_scoutPartIdToUiPartId.put(scoutPartLocation, uiPartId);
    }

    @Override
    public void unregisterPart(String scoutPartLocation) {
        this.m_scoutPartIdToUiPartId.remove(scoutPartLocation);
    }

    @Override
    public final String[] getAllPartIds() {
        HashSet<String> partIds = new HashSet<String>(this.m_scoutPartIdToUiPartId.values());
        return partIds.toArray(new String[partIds.size()]);
    }

    @Override
    public final String getSwtPartIdForScoutPartId(String scoutPartLocation) {
        return this.m_scoutPartIdToUiPartId.get(scoutPartLocation);
    }

    @Override
    public final String getScoutPartIdForSwtPartId(String partId) {
        if (partId == null) {
            return "";
        }
        for (Map.Entry<String, String> entry : this.m_scoutPartIdToUiPartId.entrySet()) {
            if (!entry.getValue().equals(partId)) continue;
            return entry.getKey();
        }
        return "";
    }

    public IViewPart findViewPart(String viewId) {
        IViewDescriptor viewRef;
        if (viewId != null && (viewRef = PlatformUI.getWorkbench().getViewRegistry().find(viewId)) != null && !viewRef.getAllowMultiple()) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(viewId);
        }
        return null;
    }

    @Override
    public AbstractScoutView getViewPart(String viewId) {
        if (viewId != null) {
            String secondaryId = null;
            IViewDescriptor viewRef = PlatformUI.getWorkbench().getViewRegistry().find(viewId);
            if (viewRef.getAllowMultiple()) {
                secondaryId = "" + System.currentTimeMillis();
            }
            try {
                IViewPart view = null;
                if (secondaryId == null) {
                    view = this.findViewPart(viewId);
                    if (view == null) {
                        view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewId);
                    }
                } else {
                    view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewId, secondaryId, 1);
                }
                if (view instanceof AbstractScoutView) {
                    return (AbstractScoutView)view;
                }
                LOG.warn("views used in scout's enviromnent must be extensions of AbstractScoutView");
            }
            catch (PartInitException e) {
                LOG.error("could not inizialize view", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public AbstractScoutEditorPart getEditorPart(IEditorInput editorInput, String editorId) {
        if (editorInput != null && editorId != null) {
            try {
                IEditorPart editor = null;
                editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor(editorInput);
                if (editor == null) {
                    editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(editorInput, editorId);
                }
                if (editor instanceof AbstractScoutEditorPart) {
                    return (AbstractScoutEditorPart)editor;
                }
                LOG.warn("editors used in scout's enviromnent must be extensions of AbstractScoutEditorPart");
            }
            catch (PartInitException e) {
                LOG.error("could not inizialize editor", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public boolean isInitialized() {
        return this.m_status == 2;
    }

    @Override
    public final void ensureInitialized() {
        if (this.m_status == 0 || this.m_status == 8) {
            try {
                this.init();
            }
            catch (CoreException e) {
                LOG.error("could not initialize Environment", (Throwable)e);
            }
        }
    }

    private synchronized void init() throws CoreException {
        if (this.m_status == 1 || this.m_status == 2 || this.m_status == 4) {
            return;
        }
        this.m_status = 0;
        if (Thread.currentThread() != this.getDisplay().getThread()) {
            throw new IllegalStateException("must be called in display thread");
        }
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null) {
            throw new IllegalStateException("workbench must be active");
        }
        try {
            String perspectiveId;
            IPerspectiveDescriptor activePerspective;
            this.m_status = 1;
            this.m_clipboard = new Clipboard(this.getDisplay());
            this.fireEnvironmentChanged(new SwtEnvironmentEvent(this, this.m_status));
            IClientSession tempClientSession = this.createAndStartClientSession();
            if (!tempClientSession.isActive()) {
                this.showClientSessionLoadError(tempClientSession.getLoadError());
                LOG.error("ClientSession is not active, there must be a problem with loading or starting");
                this.m_status = 0;
                return;
            }
            this.m_clientSession = tempClientSession;
            SwtUtility.setNlsTextsOnDisplay(this.getDisplay(), this.m_clientSession.getTexts());
            if (this.m_synchronizer == null) {
                this.m_synchronizer = new SwtScoutSynchronizer(this);
            }
            this.m_iconLocator = this.createIconLocator();
            this.m_colorFactory = new ColorFactory(this.getDisplay());
            this.m_keyStrokeManager = new KeyStrokeManager(this);
            this.m_fontRegistry = new FontRegistry(this.getDisplay());
            this.attachScoutListeners();
            this.attachSWTListeners();
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage != null && (activePerspective = activePage.getPerspective()) != null && this.handlePerspectiveOpened(perspectiveId = activePerspective.getId())) {
                this.handlePerspectiveActivated(perspectiveId);
            }
            IKeyStroke[] iKeyStrokeArray = this.getClientSession().getDesktop().getKeyStrokes();
            int n = iKeyStrokeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISwtKeyStroke[] swtStrokes;
                IKeyStroke scoutKeyStroke = iKeyStrokeArray[n2];
                ISwtKeyStroke[] iSwtKeyStrokeArray = swtStrokes = SwtUtility.getKeyStrokes(scoutKeyStroke, this);
                int n3 = swtStrokes.length;
                int n4 = 0;
                while (n4 < n3) {
                    ISwtKeyStroke swtStroke = iSwtKeyStrokeArray[n4];
                    this.m_desktopKeyStrokes.add(swtStroke);
                    this.addGlobalKeyStroke(swtStroke);
                    ++n4;
                }
                ++n2;
            }
            PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                public boolean preShutdown(IWorkbench workbench, boolean forced) {
                    return true;
                }

                public void postShutdown(IWorkbench workbench) {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            AbstractSwtEnvironment.this.getScoutDesktop().getUIFacade().fireGuiDetached();
                            AbstractSwtEnvironment.this.getScoutDesktop().getUIFacade().fireDesktopClosingFromUI();
                        }
                    };
                    JobEx job = AbstractSwtEnvironment.this.invokeScoutLater(t, 0L);
                    if (job != null) {
                        try {
                            job.join(600000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            });
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    AbstractSwtEnvironment.this.getScoutDesktop().getUIFacade().fireDesktopOpenedFromUI();
                }
            };
            this.invokeScoutLater(job, 0L);
            this.m_status = 2;
            this.fireEnvironmentChanged(new SwtEnvironmentEvent(this, this.m_status));
            this.attachBusyHandler();
        }
        finally {
            if (this.m_status == 1) {
                this.m_status = 8;
                this.fireEnvironmentChanged(new SwtEnvironmentEvent(this, this.m_status));
            }
        }
    }

    private IClientSession createAndStartClientSession() {
        Holder holder = new Holder(IClientSession.class);
        JobEx job = new JobEx("Creating and starting client session", (IHolder)holder){
            private final /* synthetic */ IHolder val$holder;
            {
                this.val$holder = iHolder;
                super($anonymous0);
            }

            protected IStatus run(IProgressMonitor monitor) {
                this.val$holder.setValue((Object)((IClientSessionRegistryService)SERVICES.getService(IClientSessionRegistryService.class)).newClientSession(AbstractSwtEnvironment.this.m_clientSessionClass, AbstractSwtEnvironment.this.initUserAgent()));
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            LOG.error("Client session startup interrupted.", (Throwable)e);
        }
        return (IClientSession)holder.getValue();
    }

    protected UserAgent initUserAgent() {
        return UserAgent.create((IUiLayer)UiLayer.SWT, (IUiDeviceType)UiDeviceType.DESKTOP);
    }

    protected SwtBusyHandler attachBusyHandler() {
        IBusyManagerService service = (IBusyManagerService)SERVICES.getService(IBusyManagerService.class);
        if (service == null) {
            return null;
        }
        SwtBusyHandler handler = this.createBusyHandler();
        this.getDisplay().addListener(12, (Listener)new P_BusyHandlerDisposeListener(service));
        service.register(this.getClientSession(), (IBusyHandler)handler);
        return handler;
    }

    protected SwtBusyHandler createBusyHandler() {
        return new SwtBusyHandler(this.getClientSession(), this);
    }

    protected void showClientSessionLoadError(Throwable error) {
        ErrorHandler handler = new ErrorHandler(error);
        MessageBox mbox = new MessageBox(this.getParentShellIgnoringPopups(196608), 32);
        mbox.setText(handler.getTitle());
        mbox.setMessage(StringUtility.join((String)"\n\n", (Object[])new Object[]{handler.getText(), handler.getDetail()}));
        mbox.open();
    }

    private void fireGuiAttachedFromUI() {
        if (this.getScoutDesktop() != null) {
            this.getScoutDesktop().getUIFacade().fireGuiAttached();
        }
        this.getDisplay().asyncExec((Runnable)new P_HideScoutViews());
    }

    private void fireGuiDetachedFromUI() {
        if (this.getScoutDesktop() != null) {
            this.getScoutDesktop().getUIFacade().fireGuiDetached();
        }
    }

    private void fireDesktopActivatedFromUI() {
        if (this.getScoutDesktop() != null) {
            this.getScoutDesktop().ensureViewStackVisible();
        }
    }

    @Override
    public String styleHtmlText(ISwtScoutFormField<?> uiComposite, String rawHtml) {
        String cleanHtml = rawHtml;
        if (cleanHtml == null) {
            cleanHtml = "";
        }
        if (uiComposite.getScoutObject() instanceof IHtmlField) {
            IHtmlField htmlField = (IHtmlField)uiComposite.getScoutObject();
            if (htmlField.isHtmlEditor()) {
                if (!StringUtility.hasText((String)cleanHtml)) {
                    cleanHtml = "<html><head></head><body></body></html>";
                }
            } else {
                cleanHtml = HTMLUtility.cleanupHtml((String)cleanHtml, (boolean)true, (boolean)false, (HTMLUtility.DefaultFont)this.createDefaultFontSettings(uiComposite.getSwtField()));
            }
        }
        return cleanHtml;
    }

    protected HTMLUtility.DefaultFont createDefaultFontSettings(Control control) {
        HTMLUtility.DefaultFont defaultFont = new HTMLUtility.DefaultFont();
        defaultFont.setSize(8);
        defaultFont.setSizeUnit("pt");
        defaultFont.setForegroundColor(0);
        defaultFont.setFamilies(new String[]{"sans-serif"});
        if (control != null) {
            Color color;
            FontData[] fontData = control.getFont().getFontData();
            if (fontData != null && fontData.length > 0) {
                String fontFamily;
                int height = fontData[0].getHeight();
                if (height > 0) {
                    defaultFont.setSize(height);
                }
                if (StringUtility.hasText((String)(fontFamily = fontData[0].getName()))) {
                    defaultFont.setFamilies(new String[]{fontFamily, "sans-serif"});
                }
            }
            if ((color = control.getForeground()) != null) {
                defaultFont.setForegroundColor(color.getRed() * 65536 + color.getGreen() * 256 + color.getBlue());
            }
        }
        return defaultFont;
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public void setBusyFromSwt(boolean b) {
    }

    @Override
    public void setClipboardText(String text) {
        this.m_clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }

    @Override
    public final void addEnvironmentListener(ISwtEnvironmentListener listener) {
        this.m_environmentListeners.add(ISwtEnvironmentListener.class, (EventListener)listener);
    }

    @Override
    public final void removeEnvironmentListener(ISwtEnvironmentListener listener) {
        this.m_environmentListeners.remove(ISwtEnvironmentListener.class, (EventListener)listener);
    }

    private void fireEnvironmentChanged(SwtEnvironmentEvent event) {
        ISwtEnvironmentListener[] iSwtEnvironmentListenerArray = (ISwtEnvironmentListener[])this.m_environmentListeners.getListeners(ISwtEnvironmentListener.class);
        int n = iSwtEnvironmentListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISwtEnvironmentListener l = iSwtEnvironmentListenerArray[n2];
            l.environmentChanged(event);
            ++n2;
        }
    }

    @Override
    public Image getIcon(String name) {
        return this.m_iconLocator.getIcon(name);
    }

    @Override
    public ImageDescriptor getImageDescriptor(String iconId) {
        return this.m_iconLocator.getImageDescriptor(iconId);
    }

    @Override
    public void addGlobalKeyStroke(ISwtKeyStroke stroke) {
        this.m_keyStrokeManager.addGlobalKeyStroke(stroke);
    }

    @Override
    public boolean removeGlobalKeyStroke(ISwtKeyStroke stroke) {
        return this.m_keyStrokeManager.removeGlobalKeyStroke(stroke);
    }

    @Override
    public void addKeyStroke(Widget widget, ISwtKeyStroke stoke) {
        this.m_keyStrokeManager.addKeyStroke(widget, stoke);
    }

    @Override
    public boolean removeKeyStroke(Widget widget, ISwtKeyStroke stoke) {
        return this.m_keyStrokeManager.removeKeyStroke(widget, stoke);
    }

    @Override
    public void addKeyStrokeFilter(Widget c, ISwtKeyStrokeFilter filter) {
        this.m_keyStrokeManager.addKeyStrokeFilter(c, filter);
    }

    @Override
    public boolean removeKeyStrokeFilter(Widget c, ISwtKeyStrokeFilter filter) {
        return this.m_keyStrokeManager.removeKeyStrokeFilter(c, filter);
    }

    @Override
    public Color getColor(String scoutColor) {
        return this.m_colorFactory.getColor(scoutColor);
    }

    @Override
    public Color getColor(RGB rgb) {
        return this.m_colorFactory.getColor(rgb);
    }

    @Override
    public Font getFont(FontSpec scoutFont, Font templateFont) {
        return this.m_fontRegistry.getFont(scoutFont, templateFont);
    }

    @Override
    public Font getFont(Font templateFont, String newName, Integer newStyle, Integer newSize) {
        return this.m_fontRegistry.getFont(templateFont, newName, newStyle, newSize);
    }

    @Override
    public ScoutFormToolkit getFormToolkit() {
        if (this.m_formToolkit == null) {
            this.m_formToolkit = this.createScoutFormToolkit(this.getDisplay());
        }
        return this.m_formToolkit;
    }

    @Override
    public final IDesktop getScoutDesktop() {
        if (this.m_clientSession != null) {
            return this.m_clientSession.getDesktop();
        }
        return null;
    }

    protected void attachScoutListeners() {
        if (this.m_scoutDesktopListener == null) {
            this.m_scoutDesktopListener = new P_ScoutDesktopListener();
            this.getScoutDesktop().addDesktopListener((DesktopListener)this.m_scoutDesktopListener);
        }
        if (this.m_desktopPropertyListener == null) {
            this.m_desktopPropertyListener = new P_ScoutDesktopPropertyListener();
            this.getScoutDesktop().addPropertyChangeListener((PropertyChangeListener)this.m_desktopPropertyListener);
        }
    }

    protected void detachScoutListeners() {
        IDesktop desktop = this.getScoutDesktop();
        if (desktop != null) {
            if (this.m_scoutDesktopListener != null) {
                desktop.removeDesktopListener((DesktopListener)this.m_scoutDesktopListener);
                this.m_scoutDesktopListener = null;
            }
            if (this.m_desktopPropertyListener != null) {
                desktop.removePropertyChangeListener((PropertyChangeListener)this.m_desktopPropertyListener);
                this.m_desktopPropertyListener = null;
            }
        }
    }

    protected void attachSWTListeners() {
        if (this.m_perspectiveListener == null) {
            this.m_perspectiveListener = new P_PerspectiveListener();
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this.m_perspectiveListener);
        }
    }

    protected void detachSWTListeners() {
        if (this.m_perspectiveListener != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this.m_perspectiveListener);
            this.m_perspectiveListener = null;
        }
    }

    protected void applyScoutState() {
        IMessageBox[] messageBoxes;
        IForm[] dialogs;
        IDesktop desktop = this.getScoutDesktop();
        IForm[] iFormArray = desktop.getViewStack();
        int n = iFormArray.length;
        int n2 = 0;
        while (n2 < n) {
            IForm form = iFormArray[n2];
            if (form.isAutoAddRemoveOnDesktop()) {
                this.showStandaloneForm(form);
            }
            ++n2;
        }
        if (desktop.isTrayVisible()) {
            this.m_trayComposite = this.createTray(desktop);
        }
        IForm[] iFormArray2 = dialogs = desktop.getDialogStack();
        int n3 = dialogs.length;
        n = 0;
        while (n < n3) {
            IForm dialog = iFormArray2[n];
            this.showStandaloneForm(dialog);
            ++n;
        }
        IMessageBox[] iMessageBoxArray = messageBoxes = desktop.getMessageBoxStack();
        int n4 = messageBoxes.length;
        n3 = 0;
        while (n3 < n4) {
            IMessageBox messageBoxe = iMessageBoxArray[n3];
            this.showMessageBoxFromScout(messageBoxe);
            ++n3;
        }
    }

    public IFormField findFocusOwnerField() {
        Control comp = this.getDisplay().getFocusControl();
        while (comp != null) {
            Object o = comp.getData("org.eclipse.scout.rt.object");
            if (o instanceof IFormField) {
                return (IFormField)o;
            }
            comp = comp.getParent();
        }
        return null;
    }

    @Override
    public void showFileChooserFromScout(IFileChooser fileChooser) {
        SwtScoutFileChooser sfc = new SwtScoutFileChooser(this.getParentShellIgnoringPopups(196608), fileChooser, this);
        sfc.showFileChooser();
    }

    @Override
    public void showMessageBoxFromScout(IMessageBox messageBox) {
        SwtScoutMessageBoxDialog box = new SwtScoutMessageBoxDialog(this.getParentShellIgnoringPopups(196608), messageBox, this);
        box.open();
    }

    @Override
    public void ensureStandaloneFormVisible(IForm form) {
        ISwtScoutPart part = this.m_openForms.get(form);
        if (part != null) {
            part.activate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showStandaloneForm(IForm form) {
        if (form == null) {
            return;
        }
        ISwtScoutPart part = this.m_openForms.get(form);
        if (part != null) {
            return;
        }
        switch (form.getDisplayHint()) {
            case 0: {
                int dialogStyle = 0xC70 | (form.isModal() ? 65536 : 128);
                Shell parentShell = form.isModal() ? this.getParentShellIgnoringPopups(196608) : this.getParentShellIgnoringPopups(0);
                SwtScoutDialog dialog = this.createSwtScoutDialog(parentShell, dialogStyle);
                try {
                    this.m_openForms.put(form, dialog);
                    dialog.showForm(form);
                    part = dialog;
                }
                catch (ProcessingException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                break;
            }
            case 12: {
                int dialogStyle = 0x10 | (form.isModal() ? 65536 : 0);
                Shell parentShell = form.isModal() ? this.getParentShellIgnoringPopups(196608) : this.getParentShellIgnoringPopups(0);
                SwtScoutDialog popupDialog = this.createSwtScoutPopupDialog(parentShell, dialogStyle);
                if (popupDialog == null) {
                    LOG.error("showing popup for " + form + ", but there is neither a focus owner nor the property 'ISwtEnvironment.getPopupOwner()'");
                    return;
                }
                try {
                    this.m_openForms.put(form, popupDialog);
                    popupDialog.showForm(form);
                    part = popupDialog;
                }
                catch (Throwable t) {
                    LOG.error(t.getMessage(), t);
                }
                break;
            }
            case 20: {
                String scoutViewId = form.getDisplayViewId();
                if (scoutViewId == null) {
                    LOG.error("The property displayViewId must not be null if the property displayHint is set to IForm.DISPLAY_HINT_VIEW.");
                    return;
                }
                String uiViewId = this.getSwtPartIdForScoutPartId(scoutViewId);
                if (uiViewId == null) {
                    LOG.warn("no view defined for scoutViewId: " + form.getDisplayViewId());
                    return;
                }
                IViewPart existingView = this.findViewPart(uiViewId);
                String formPerspectiveId = form.getPerspectiveId();
                if (formPerspectiveId == null) {
                    formPerspectiveId = "";
                }
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (StringUtility.hasText((String)formPerspectiveId) && existingView == null && activePage != null && CompareUtility.notEquals((Object)activePage.getPerspective().getId(), (Object)formPerspectiveId)) {
                    Map<String, List<IForm>> map = this.openLater;
                    synchronized (map) {
                        if (!this.openLater.containsKey(formPerspectiveId) || !this.openLater.get(formPerspectiveId).contains(form)) {
                            if (this.openLater.get(formPerspectiveId) == null) {
                                this.openLater.put(formPerspectiveId, new ArrayList());
                            }
                            this.openLater.get(formPerspectiveId).add(form);
                        }
                    }
                    return;
                }
                if (scoutViewId.startsWith("EDITOR") || scoutViewId.startsWith("EDITOR")) {
                    if (activePage == null) break;
                    ScoutFormEditorInput editorInput = new ScoutFormEditorInput(form, this);
                    part = this.getEditorPart(editorInput, uiViewId);
                    this.m_openForms.put(form, part);
                    break;
                }
                AbstractScoutView viewPart = this.getViewPart(uiViewId);
                try {
                    viewPart.showForm(form);
                    part = viewPart;
                    this.m_openForms.put(form, viewPart);
                }
                catch (ProcessingException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                break;
            }
            case 10: {
                SwtScoutPopup popupWindow = this.createSwtScoutPopupWindow();
                if (popupWindow == null) {
                    LOG.error("showing popup for " + form + ", but there is neither a focus owner nor the property 'ISwtEnvironment.getPopupOwner()'");
                    return;
                }
                try {
                    this.m_openForms.put(form, popupWindow);
                    popupWindow.showForm(form);
                    part = popupWindow;
                    break;
                }
                catch (Throwable e1) {
                    LOG.error("Failed opening popup for " + form, e1);
                    try {
                        popupWindow.showForm(form);
                        break;
                    }
                    catch (Throwable t) {
                        LOG.error(t.getMessage(), t);
                    }
                }
            }
        }
    }

    protected SwtScoutDialog createSwtScoutDialog(Shell shell, int dialogStyle) {
        return new SwtScoutDialog(shell, this, dialogStyle);
    }

    protected SwtScoutDialog createSwtScoutPopupDialog(Shell shell, int dialogStyle) {
        Control owner = this.getPopupOwner();
        if (owner == null) {
            owner = this.getDisplay().getFocusControl();
        }
        if (owner == null) {
            return null;
        }
        Rectangle ownerBounds = this.getPopupOwnerBounds();
        if (ownerBounds == null) {
            ownerBounds = owner.getBounds();
            Point pDisp = owner.toDisplay(0, 0);
            ownerBounds.x = pDisp.x;
            ownerBounds.y = pDisp.y;
        }
        SwtScoutDialog dialog = new SwtScoutDialog(shell, this, dialogStyle);
        dialog.setInitialLocation(new Point(ownerBounds.x, ownerBounds.y + ownerBounds.height));
        return dialog;
    }

    protected SwtScoutPopup createSwtScoutPopupWindow() {
        Control owner = this.getPopupOwner();
        if (owner == null) {
            owner = this.getDisplay().getFocusControl();
        }
        if (owner == null) {
            return null;
        }
        Rectangle ownerBounds = this.getPopupOwnerBounds();
        if (ownerBounds == null) {
            ownerBounds = owner.getBounds();
            Point pDisp = owner.toDisplay(0, 0);
            ownerBounds.x = pDisp.x;
            ownerBounds.y = pDisp.y;
        }
        final SwtScoutPopup popup = new SwtScoutPopup(this, owner, ownerBounds, 16);
        popup.setMaxHeightHint(280);
        popup.addSwtScoutPartListener(new SwtScoutPartListener(){

            @Override
            public void partChanged(SwtScoutPartEvent e) {
                switch (e.getType()) {
                    case 50: {
                        popup.closePart();
                        break;
                    }
                    case 40: {
                        popup.closePart();
                    }
                }
            }
        });
        owner.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ((Shell)e.getSource()).removeShellListener((ShellListener)this);
                popup.closePart();
            }

            public void shellActivated(ShellEvent e) {
                ((Shell)e.getSource()).removeShellListener((ShellListener)this);
                popup.closePart();
            }
        });
        return popup;
    }

    @Override
    public Control getPopupOwner() {
        return this.m_popupOwner;
    }

    @Override
    public Rectangle getPopupOwnerBounds() {
        return this.m_popupOwnerBounds != null ? new Rectangle(this.m_popupOwnerBounds.x, this.m_popupOwnerBounds.y, this.m_popupOwnerBounds.width, this.m_popupOwnerBounds.height) : null;
    }

    @Override
    public void setPopupOwner(Control owner, Rectangle ownerBounds) {
        this.m_popupOwner = owner;
        this.m_popupOwnerBounds = ownerBounds;
    }

    @Override
    public void hideStandaloneForm(IForm form) {
        if (form == null) {
            return;
        }
        ISwtScoutPart part = this.m_openForms.remove(form);
        if (part != null && part.getForm().equals(form)) {
            try {
                part.closePart();
            }
            catch (ProcessingException e) {
                LOG.warn("could not close part.", (Throwable)e);
            }
        }
    }

    protected void handleDesktopPropertyChanged(String propertyName, Object oldVal, Object newValue) {
        if ("status".equals(propertyName)) {
            this.setStatusFromScout();
        }
    }

    protected void setStatusFromScout() {
        if (this.getScoutDesktop() != null) {
            IProcessingStatus newValue = this.getScoutDesktop().getStatus();
            TrayItem trayItem = null;
            if (this.getTrayComposite() != null) {
                trayItem = this.getTrayComposite().getSwtTrayItem();
            }
            if (trayItem != null) {
                String s;
                String string = s = newValue != null ? newValue.getMessage() : null;
                if (newValue != null && s != null) {
                    int iconId;
                    switch (newValue.getSeverity()) {
                        case 2: {
                            iconId = 8;
                            break;
                        }
                        case 4: 
                        case 16: {
                            iconId = 1;
                            break;
                        }
                        case 8: {
                            Version frameworkVersion = new Version(Activator.getDefault().getBundle().getBundleContext().getProperty("osgi.framework.version"));
                            if (frameworkVersion.getMajor() == 3 && frameworkVersion.getMinor() <= 4) {
                                iconId = 2;
                                break;
                            }
                            iconId = 256;
                            break;
                        }
                        default: {
                            iconId = 2;
                        }
                    }
                    ToolTip tip = new ToolTip(this.getParentShellIgnoringPopups(0), 0x1000 | iconId);
                    tip.setMessage(s);
                    trayItem.setToolTip(tip);
                    tip.setVisible(true);
                } else {
                    ToolTip tip = new ToolTip(this.getParentShellIgnoringPopups(0), 0);
                    trayItem.setToolTip(tip);
                    tip.setVisible(true);
                }
            } else {
                String message = null;
                if (newValue != null) {
                    message = newValue.getMessage();
                }
                this.setStatusLineMessage(null, message);
            }
        }
    }

    @Override
    public void setStatusLineMessage(Image image, String message) {
        for (ISwtScoutPart part : this.m_openForms.values()) {
            part.setStatusLineMessage(image, message);
        }
    }

    @Override
    public Collection<ISwtScoutPart> getOpenFormParts() {
        return new ArrayList<ISwtScoutPart>(this.m_openForms.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postImmediateSwtJob(Runnable r) {
        Object object = this.m_immediateSwtJobsLock;
        synchronized (object) {
            this.m_immediateSwtJobs.add(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchImmediateSwtJobs() {
        ArrayList<Runnable> list;
        Object object = this.m_immediateSwtJobsLock;
        synchronized (object) {
            list = new ArrayList<Runnable>(this.m_immediateSwtJobs);
            this.m_immediateSwtJobs.clear();
        }
        for (Runnable r : list) {
            try {
                r.run();
            }
            catch (Throwable t) {
                LOG.warn("running " + r, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobEx invokeScoutLater(Runnable job, long cancelTimeout) {
        Object object = this.m_immediateSwtJobsLock;
        synchronized (object) {
            this.m_immediateSwtJobs.clear();
        }
        if (this.m_synchronizer != null) {
            return this.m_synchronizer.invokeScoutLater(job, cancelTimeout);
        }
        LOG.warn("synchronizer is null; clientSession did not start");
        return null;
    }

    @Override
    public void invokeSwtLater(Runnable job) {
        if (this.m_synchronizer != null) {
            this.m_synchronizer.invokeSwtLater(job);
        } else {
            LOG.warn("synchronizer is null; clientSession did not start");
        }
    }

    @Override
    public Display getDisplay() {
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        LOG.warn("Workbench is not yet started, accessing the display is unusual: " + new Exception().getStackTrace()[1]);
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    @Override
    public Shell getParentShellIgnoringPopups(int modalities) {
        return SwtUtility.getParentShellIgnoringPopups(this.getDisplay(), modalities);
    }

    @Override
    public IClientSession getClientSession() {
        return this.m_clientSession;
    }

    protected SwtIconLocator createIconLocator() {
        return new SwtIconLocator(this.getClientSession().getIconLocator());
    }

    protected ScoutFormToolkit createScoutFormToolkit(Display display) {
        return new ScoutFormToolkit(new FormToolkit(display){

            public Form createForm(Composite parent) {
                Form f = super.createForm(parent);
                this.decorateFormHeading(f);
                return f;
            }
        });
    }

    @Override
    public ISwtScoutTray getTrayComposite() {
        return this.m_trayComposite;
    }

    protected ISwtScoutTray createTray(IDesktop desktop) {
        SwtScoutTray ui = new SwtScoutTray();
        ui.createField(null, desktop, this);
        return ui;
    }

    @Override
    public ISwtScoutForm createForm(Composite parent, IForm scoutForm) {
        SwtScoutForm uiForm = new SwtScoutForm();
        uiForm.createField(parent, scoutForm, this);
        return uiForm;
    }

    @Override
    public ISwtScoutFormField createFormField(Composite parent, IFormField model) {
        if (this.m_formFieldFactory == null) {
            this.m_formFieldFactory = new FormFieldFactory(this.m_applicationBundle);
        }
        ISwtScoutFormField<IFormField> uiField = this.m_formFieldFactory.createFormField(parent, model, this);
        return uiField;
    }

    @Override
    public void checkThread() {
        if (this.getDisplay().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Must be called in swt thread");
        }
    }

    private synchronized boolean handlePerspectiveOpened(String perspectiveId) {
        if (this.m_perspectiveId.equals(perspectiveId)) {
            if (!this.isStartDesktopCalled()) {
                P_PerspecitveOpenedJob j = new P_PerspecitveOpenedJob(this.getDesktopOpenedTaskText(), this.getClientSession());
                j.schedule();
                this.setStartDesktopCalled(true);
            }
            this.m_keyStrokeManager.setGlobalKeyStrokesActivated(true);
            return this.isStartDesktopCalled();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean handlePerspectiveActivated(String perspectiveId) {
        if (this.openLater.containsKey(perspectiveId)) {
            List<IForm> list;
            Map<String, List<IForm>> map = this.openLater;
            synchronized (map) {
                list = this.openLater.remove(perspectiveId);
            }
            for (IForm form : list) {
                this.showStandaloneForm(form);
            }
            this.setActivateDesktopCalled(CompareUtility.notEquals((Object)this.m_perspectiveId, (Object)perspectiveId));
        }
        if (this.m_perspectiveId.equals(perspectiveId) && this.isStartDesktopCalled()) {
            if (!this.isActivateDesktopCalled()) {
                P_PerspectiveActivatedJob j = new P_PerspectiveActivatedJob(this.getDesktopOpenedTaskText(), this.getClientSession());
                j.schedule();
                this.setActivateDesktopCalled(true);
            }
            this.m_keyStrokeManager.setGlobalKeyStrokesActivated(true);
            return this.isActivateDesktopCalled();
        }
        return false;
    }

    private synchronized boolean handlePerspectiveClosed(String perspectiveId) {
        boolean called = false;
        if (this.m_perspectiveId.equals(perspectiveId)) {
            P_PerspectiveClosedJob j = new P_PerspectiveClosedJob(this.getDesktopClosedTaskText(), this.getClientSession());
            j.schedule();
            called = true;
            this.setStartDesktopCalled(false);
            this.setActivateDesktopCalled(false);
            this.m_keyStrokeManager.setGlobalKeyStrokesActivated(false);
        }
        return called;
    }

    protected void handleScoutPrintInSwt(DesktopEvent e) {
        block5: {
            WidgetPrinter wp = new WidgetPrinter((Control)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            try {
                try {
                    wp.print(e.getPrintDevice(), e.getPrintParameters());
                }
                catch (Throwable ex) {
                    LOG.error(null, ex);
                    Runnable r = new Runnable(wp){
                        private final /* synthetic */ WidgetPrinter val$wp;
                        {
                            this.val$wp = widgetPrinter;
                        }

                        @Override
                        public void run() {
                            AbstractSwtEnvironment.this.getScoutDesktop().getUIFacade().fireDesktopPrintedFromUI(this.val$wp.getOutputFile());
                        }
                    };
                    this.invokeScoutLater(r, 0L);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Runnable r = new /* invalid duplicate definition of identical inner class */;
                this.invokeScoutLater(r, 0L);
                throw throwable;
            }
            Runnable r = new /* invalid duplicate definition of identical inner class */;
            this.invokeScoutLater(r, 0L);
        }
    }

    protected String getDesktopOpenedTaskText() {
        return SwtUtility.getNlsText(Display.getCurrent(), "ScoutStarting", new String[0]);
    }

    protected String getDesktopClosedTaskText() {
        return SwtUtility.getNlsText(Display.getCurrent(), "ScoutStoping", new String[0]);
    }

    private boolean isStartDesktopCalled() {
        return this.m_startDesktopCalled;
    }

    private void setStartDesktopCalled(boolean startDesktopCalled) {
        this.m_startDesktopCalled = startDesktopCalled;
    }

    private boolean isActivateDesktopCalled() {
        return this.m_activateDesktopCalled;
    }

    private void setActivateDesktopCalled(boolean activateDesktopCalled) {
        this.m_activateDesktopCalled = activateDesktopCalled;
    }

    @Override
    public String getPerspectiveId() {
        return this.m_perspectiveId;
    }

    @Override
    public FormEvent[] fetchPendingPrintEvents(IForm form) {
        return new FormEvent[0];
    }

    private class P_BusyHandlerDisposeListener
    implements Listener {
        private IBusyManagerService m_busyManagerService;

        public P_BusyHandlerDisposeListener(IBusyManagerService busyManagerService) {
            this.m_busyManagerService = busyManagerService;
        }

        public void handleEvent(Event event) {
            this.m_busyManagerService.unregister(AbstractSwtEnvironment.this.getClientSession());
        }
    }

    private class P_HideScoutViews
    implements Runnable {
        private P_HideScoutViews() {
        }

        @Override
        public void run() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage != null) {
                IViewReference[] iViewReferenceArray = activePage.getViewReferences();
                int n = iViewReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewReference = iViewReferenceArray[n2];
                    IViewPart view = viewReference.getView(false);
                    if (view != null && view instanceof AbstractScoutView) {
                        if (((AbstractScoutView)view).getForm() == null) {
                            activePage.hideView(viewReference);
                        }
                    } else if (AbstractSwtEnvironment.this.m_scoutPartIdToUiPartId.containsValue(viewReference.getId())) {
                        activePage.hideView(viewReference);
                    }
                    ++n2;
                }
            }
        }
    }

    private final class P_PerspecitveOpenedJob
    extends ClientAsyncJob {
        public P_PerspecitveOpenedJob(String name, IClientSession session) {
            super(name, session);
        }

        protected void runVoid(IProgressMonitor monitor) throws Throwable {
            AbstractSwtEnvironment.this.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractSwtEnvironment.this.applyScoutState();
                }
            });
            ClientSyncJob clienSyncJob = new ClientSyncJob(AbstractSwtEnvironment.this.getDesktopOpenedTaskText(), super.getClientSession()){

                protected void runVoid(IProgressMonitor syncMonitor) throws Throwable {
                    AbstractSwtEnvironment.this.fireGuiAttachedFromUI();
                }
            };
            clienSyncJob.schedule();
        }
    }

    private final class P_PerspectiveActivatedJob
    extends ClientAsyncJob {
        public P_PerspectiveActivatedJob(String name, IClientSession session) {
            super(name, session);
        }

        protected void runVoid(IProgressMonitor monitor) throws Throwable {
            ClientSyncJob clienSyncJob = new ClientSyncJob(AbstractSwtEnvironment.this.getDesktopOpenedTaskText(), super.getClientSession()){

                protected void runVoid(IProgressMonitor syncMonitor) throws Throwable {
                    AbstractSwtEnvironment.this.fireDesktopActivatedFromUI();
                }
            };
            clienSyncJob.schedule();
        }
    }

    private final class P_PerspectiveClosedJob
    extends ClientAsyncJob {
        public P_PerspectiveClosedJob(String name, IClientSession session) {
            super(name, session);
        }

        protected void runVoid(IProgressMonitor monitor) throws Throwable {
            ClientSyncJob clienSyncJob = new ClientSyncJob(AbstractSwtEnvironment.this.getDesktopOpenedTaskText(), super.getClientSession()){

                protected void runVoid(IProgressMonitor syncMonitor) throws Throwable {
                    AbstractSwtEnvironment.this.fireGuiDetachedFromUI();
                }
            };
            clienSyncJob.schedule();
        }
    }

    private class P_PerspectiveListener
    extends PerspectiveAdapter {
        private P_PerspectiveListener() {
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            String perspectiveId = perspective.getId();
            if (AbstractSwtEnvironment.this.handlePerspectiveOpened(perspectiveId)) {
                AbstractSwtEnvironment.this.handlePerspectiveActivated(perspectiveId);
            }
        }

        public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            if (AbstractSwtEnvironment.this.m_perspectiveId.equals(perspective.getId())) {
                AbstractSwtEnvironment.this.m_keyStrokeManager.setGlobalKeyStrokesActivated(false);
            }
        }

        public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            AbstractSwtEnvironment.this.handlePerspectiveClosed(perspective.getId());
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            String perspectiveId = perspective.getId();
            if ("reset".equals(changeId)) {
                AbstractSwtEnvironment.this.handlePerspectiveClosed(perspectiveId);
            } else if ("resetComplete".equals(changeId) && AbstractSwtEnvironment.this.handlePerspectiveOpened(perspectiveId)) {
                AbstractSwtEnvironment.this.handlePerspectiveActivated(perspectiveId);
            }
        }
    }

    private class P_ScoutDesktopListener
    implements DesktopListener {
        private P_ScoutDesktopListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void desktopChanged(final DesktopEvent e) {
            switch (e.getType()) {
                case 600: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            AbstractSwtEnvironment.this.showStandaloneForm(e.getForm());
                        }
                    };
                    AbstractSwtEnvironment.this.invokeSwtLater(t);
                    break;
                }
                case 610: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            AbstractSwtEnvironment.this.hideStandaloneForm(e.getForm());
                        }
                    };
                    AbstractSwtEnvironment.this.invokeSwtLater(t);
                    break;
                }
                case 620: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            AbstractSwtEnvironment.this.ensureStandaloneFormVisible(e.getForm());
                        }
                    };
                    AbstractSwtEnvironment.this.invokeSwtLater(t);
                    break;
                }
                case 700: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            AbstractSwtEnvironment.this.showMessageBoxFromScout(e.getMessageBox());
                        }
                    };
                    AbstractSwtEnvironment.this.invokeSwtLater(t);
                    break;
                }
                case 910: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            AbstractSwtEnvironment.this.showFileChooserFromScout(e.getFileChooser());
                        }
                    };
                    AbstractSwtEnvironment.this.invokeSwtLater(t);
                    break;
                }
                case 100: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AbstractSwtEnvironment.this.stopScout();
                            }
                            catch (CoreException ex) {
                                LOG.error("desktop closed", (Throwable)ex);
                            }
                        }
                    };
                    AbstractSwtEnvironment.this.invokeSwtLater(t);
                    break;
                }
                case 900: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            AbstractSwtEnvironment.this.handleScoutPrintInSwt(e);
                        }
                    };
                    AbstractSwtEnvironment.this.invokeSwtLater(t);
                    break;
                }
                case 1000: {
                    final Object lock = new Object();
                    Runnable t = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                IFormField f = AbstractSwtEnvironment.this.findFocusOwnerField();
                                if (f != null) {
                                    e.setFocusedField(f);
                                }
                            }
                            catch (Throwable throwable) {
                                Object object = lock;
                                synchronized (object) {
                                    lock.notifyAll();
                                }
                                throw throwable;
                            }
                            Object object = lock;
                            synchronized (object) {
                                lock.notifyAll();
                            }
                        }
                    };
                    Object object = lock;
                    synchronized (object) {
                        AbstractSwtEnvironment.this.invokeSwtLater(t);
                        try {
                            lock.wait(2000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        break;
                    }
                }
            }
        }
    }

    private class P_ScoutDesktopPropertyListener
    implements PropertyChangeListener {
        private P_ScoutDesktopPropertyListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    AbstractSwtEnvironment.this.handleDesktopPropertyChanged(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                }
            };
            AbstractSwtEnvironment.this.invokeSwtLater(job);
        }
    }
}

