/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt;

import java.util.LinkedList;
import org.eclipse.scout.rt.ui.swt.IValidateRoot;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class LayoutValidateManager {
    private static final String RUNNABLE_DISPLAY_DATA = "LayoutValidateManager.runnable";
    private final LinkedList<IValidateRoot> m_dirtyList = new LinkedList();

    public void invalidate(Control c) {
        Display display;
        Runnable runnable;
        if (c == null) {
            return;
        }
        boolean changed = false;
        Control tmp = c;
        while (tmp != null) {
            IValidateRoot v = (IValidateRoot)tmp.getData("LayoutValidateManager.validateRoot");
            if (v != null) {
                changed = true;
                this.m_dirtyList.remove(v);
                this.m_dirtyList.add(0, v);
            }
            tmp = tmp.getParent();
        }
        if (changed && (runnable = (Runnable)(display = c.getDisplay()).getData(RUNNABLE_DISPLAY_DATA)) == null && display != null && !display.isDisposed()) {
            runnable = new P_ValidateRunnable();
            display.setData(RUNNABLE_DISPLAY_DATA, null);
            display.asyncExec(runnable);
        }
    }

    private class P_ValidateRunnable
    implements Runnable {
        private P_ValidateRunnable() {
        }

        @Override
        public void run() {
            try {
                for (IValidateRoot v : LayoutValidateManager.this.m_dirtyList) {
                    v.validate();
                }
            }
            finally {
                LayoutValidateManager.this.m_dirtyList.clear();
                Display.getCurrent().setData(LayoutValidateManager.RUNNABLE_DISPLAY_DATA, null);
            }
        }
    }
}

