/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.action;

import org.eclipse.jface.action.Action;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;

public class SwtScoutAction {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutAction.class);
    private final IAction m_scoutAction;
    private final Action m_swtAction;
    private final ISwtEnvironment m_environment;
    private boolean m_handleActionPending;

    public SwtScoutAction(IAction scoutAction, ISwtEnvironment environment) {
        this(scoutAction, environment, 8);
    }

    public SwtScoutAction(IAction scoutAction, ISwtEnvironment environment, int style) {
        this.m_scoutAction = scoutAction;
        this.m_environment = environment;
        this.m_swtAction = new P_SwtAction(style);
        String keyStroke = this.m_scoutAction.getKeyStroke();
        this.m_swtAction.setText(this.m_scoutAction.getText());
        this.m_swtAction.setToolTipText(this.m_scoutAction.getTooltipText());
        this.m_swtAction.setImageDescriptor(this.m_environment.getImageDescriptor(this.m_scoutAction.getIconId()));
        this.setKeyStrokeFromScout(keyStroke);
    }

    protected void handleSwtAction() {
        if (!this.m_handleActionPending) {
            this.m_handleActionPending = true;
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    try {
                        SwtScoutAction.this.getScoutAction().getUIFacade().fireActionFromUI();
                    }
                    finally {
                        SwtScoutAction.this.m_handleActionPending = false;
                    }
                }
            };
            this.getEnvironment().invokeScoutLater(job, 0L);
        }
    }

    public IAction getScoutAction() {
        return this.m_scoutAction;
    }

    public Action getSwtAction() {
        return this.m_swtAction;
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    private void setKeyStrokeFromScout(String keyStroke) {
        if (keyStroke != null) {
            int keyCode = SwtUtility.getSwtKeyCode((IKeyStroke)new KeyStroke(keyStroke));
            int stateMask = SwtUtility.getSwtStateMask((IKeyStroke)new KeyStroke(keyStroke));
            this.getSwtAction().setAccelerator(stateMask | keyCode);
        } else {
            this.getSwtAction().setAccelerator(0);
        }
    }

    private class P_SwtAction
    extends Action {
        P_SwtAction(int style) {
            super("", style);
        }

        public void run() {
            SwtScoutAction.this.handleSwtAction();
        }
    }
}

