/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.stringfield;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.IDNDSupport;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.ui.swt.Activator;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.ext.StyledTextEx;
import org.eclipse.scout.rt.ui.swt.form.fields.AbstractSwtScoutDndSupport;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.stringfield.ISwtScoutStringField;
import org.eclipse.scout.rt.ui.swt.internal.StyledTextFieldUndoRedoSupport;
import org.eclipse.scout.rt.ui.swt.internal.TextFieldEditableSupport;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Version;

public class SwtScoutStringField
extends SwtScoutValueFieldComposite<IStringField>
implements ISwtScoutStringField {
    public static final int DEFAULT_CASE = 0;
    public static final int UPPER_CASE = 1;
    public static final int LOWER_CASE = 2;
    private int m_characterType = -1;
    private MouseListener m_linkTrigger;
    private boolean m_validateOnAnyKey;
    private boolean m_linkDecoration;
    private TextFieldEditableSupport m_editableSupport;
    private StyledTextFieldUndoRedoSupport m_undoRedoSupport;
    private Point m_backupSelection = null;

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getEnvironment().getFormToolkit().createStatusLabel(container, this.getEnvironment(), (IFormField)this.getScoutObject());
        int style = 2048;
        if (((IStringField)this.getScoutObject()).isInputMasked()) {
            style |= 0x400000;
        }
        style = ((IStringField)this.getScoutObject()).isMultilineText() ? (style |= 0x202) : (style |= 4);
        if (((IStringField)this.getScoutObject()).isWrapText()) {
            style |= 0x40;
        }
        StyledText textField = this.getEnvironment().getFormToolkit().createStyledText(container, style);
        Version frameworkVersion = new Version(Activator.getDefault().getBundle().getBundleContext().getProperty("osgi.framework.version"));
        if (frameworkVersion.getMajor() != 3 || frameworkVersion.getMinor() > 5) {
            try {
                Method setWrapIndent = StyledText.class.getMethod("setWrapIndent", Integer.TYPE);
                setWrapIndent.invoke((Object)textField, textField.getIndent());
                if ((textField.getStyle() & 2) != 0) {
                    Method setMargins = StyledText.class.getMethod("setMargins", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    setMargins.invoke((Object)textField, 2, 2, 2, 2);
                }
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.scout.rt.ui.swt", "could not access methods 'setWrapIndent' and 'setMargins' on 'StyledText'.", (Throwable)e));
            }
        }
        textField.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SwtScoutStringField.this.m_undoRedoSupport != null && !SwtScoutStringField.this.m_undoRedoSupport.isDisposed()) {
                    SwtScoutStringField.this.m_undoRedoSupport.dispose();
                }
            }
        });
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.setSwtField((Control)textField);
        this.addDefaultUiListeners(textField);
        if (this.m_undoRedoSupport == null) {
            this.m_undoRedoSupport = new StyledTextFieldUndoRedoSupport(this.getSwtField());
        }
        LogicalGridLayout layout = new LogicalGridLayout(1, 0);
        this.getSwtContainer().setLayout((Layout)layout);
    }

    protected void addDefaultUiListeners(StyledText textField) {
        textField.addModifyListener((ModifyListener)new P_SwtTextListener());
        textField.addSelectionListener((SelectionListener)new P_SwtTextSelectionListener());
        textField.addVerifyListener((VerifyListener)new P_TextVerifyListener());
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IStringField f = (IStringField)this.getScoutObject();
        this.setDecorationLinkFromScout(f.isDecorationLink());
        this.setFormatFromScout(f.getFormat());
        this.setMaxLengthFromScout(f.getMaxLength());
        this.setValidateOnAnyKeyFromScout(f.isValidateOnAnyKey());
        this.setSelectionFromScout(f.getSelectionStart(), f.getSelectionEnd());
        this.setTextWrapFromScout(f.isWrapText());
        new P_DndSupport((IPropertyObserver)this.getScoutObject(), (IDNDSupport)this.getScoutObject(), (Control)this.getSwtField(), this.getEnvironment());
        if (this.m_undoRedoSupport != null) {
            this.m_undoRedoSupport.clearStacks();
        }
    }

    @Override
    public StyledTextEx getSwtField() {
        return (StyledTextEx)super.getSwtField();
    }

    @Override
    protected void setFieldEnabled(Control swtField, boolean enabled) {
        if (this.m_editableSupport == null) {
            this.m_editableSupport = new TextFieldEditableSupport(this.getSwtField());
        }
        this.m_editableSupport.setEditable(enabled);
    }

    protected void setDecorationLinkFromScout(boolean b) {
        if (this.m_linkDecoration != b) {
            this.m_linkDecoration = b;
            if (this.m_linkDecoration) {
                this.m_linkTrigger = new P_SwtLinkTrigger();
                this.getSwtField().addMouseListener(this.m_linkTrigger);
                this.getSwtField().setCursor(this.getSwtField().getDisplay().getSystemCursor(21));
                this.setForegroundFromScout(((IStringField)this.getScoutObject()).getForegroundColor());
            } else {
                this.getSwtField().removeMouseListener(this.m_linkTrigger);
                this.m_linkTrigger = null;
                this.getSwtField().setCursor(null);
                this.setForegroundFromScout(((IStringField)this.getScoutObject()).getForegroundColor());
            }
        }
    }

    @Override
    protected void setForegroundFromScout(String scoutColor) {
        if (scoutColor == null && this.m_linkDecoration) {
            scoutColor = "0000FF";
        }
        super.setForegroundFromScout(scoutColor);
    }

    protected void setFormatFromScout(String s) {
        this.m_characterType = "A".equals(s) ? 1 : ("a".equals(s) ? 2 : 0);
    }

    protected void setMaxLengthFromScout(int n) {
        this.getSwtField().setTextLimit(n);
    }

    protected void setDoInsertFromScout(String s) {
        if (s != null && s.length() > 0) {
            StyledTextEx swtField = this.getSwtField();
            int offset = swtField.getCaretOffset();
            int a = swtField.getSelection().x;
            int b = swtField.getSelection().y;
            String uiText = swtField.getText();
            StringBuilder builder = new StringBuilder(uiText);
            if (a >= 0 && b > a) {
                builder.replace(a, b, s);
            } else if (offset >= 0) {
                builder.insert(offset, s);
            } else {
                builder = null;
            }
            if (builder != null) {
                swtField.setText(builder.toString());
            }
        }
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        if (this.m_validateOnAnyKey && this.getSwtField().isFocusControl()) {
            return;
        }
        StyledTextEx swtField = this.getSwtField();
        String oldText = swtField.getText();
        if (s == null) {
            s = "";
        }
        if (oldText == null) {
            oldText = "";
        }
        if (oldText.equals(s)) {
            return;
        }
        int startIndex = swtField.getSelection().x;
        int caretOffset = swtField.getCaretOffset();
        int endIndex = -swtField.getSelection().y;
        swtField.setText(s);
        int textLength = swtField.getText().length();
        if (caretOffset > 0) {
            startIndex = Math.min(Math.max(startIndex, 0), textLength);
            endIndex = Math.min(Math.max(endIndex, 0), textLength);
            swtField.setCaretOffset(caretOffset);
            this.m_backupSelection = new Point(startIndex, endIndex);
            if (this.getSwtField().isFocusControl()) {
                swtField.setSelection(startIndex, endIndex);
            }
        }
    }

    protected void setValidateOnAnyKeyFromScout(boolean b) {
        this.m_validateOnAnyKey = b;
    }

    protected void setSelectionFromScout(int startIndex, int endIndex) {
        StyledTextEx swtField = this.getSwtField();
        int start = swtField.getSelection().x;
        int end = swtField.getSelection().y;
        if (startIndex < 0) {
            startIndex = start;
        }
        if (endIndex < 0) {
            endIndex = end;
        }
        this.m_backupSelection = new Point(startIndex, endIndex);
        if (this.getSwtField().isFocusControl()) {
            swtField.setSelection(startIndex, endIndex);
        }
    }

    protected void setTextWrapFromScout(boolean booleanValue) {
        if (((IStringField)this.getScoutObject()).isMultilineText()) {
            this.getSwtField().setWordWrap(booleanValue);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("decorationLink")) {
            this.setDecorationLinkFromScout((Boolean)newValue);
        } else if (name.equals("maxLength")) {
            this.setMaxLengthFromScout(((Number)newValue).intValue());
        } else if (name.equals("insertText")) {
            this.setDoInsertFromScout((String)newValue);
        } else if (name.equals("validateOnAnyKey")) {
            this.setValidateOnAnyKeyFromScout((Boolean)newValue);
        } else if (name.equals("selectionStart")) {
            IStringField f = (IStringField)this.getScoutObject();
            this.setSelectionFromScout(f.getSelectionStart(), f.getSelectionEnd());
        } else if (name.equals("selectionEnd")) {
            IStringField f = (IStringField)this.getScoutObject();
            this.setSelectionFromScout(f.getSelectionStart(), f.getSelectionEnd());
        } else if (name.equals("wrapText")) {
            this.setTextWrapFromScout((Boolean)newValue);
        }
    }

    protected void handleSwtLinkTrigger() {
        final String text = this.getSwtField().getText();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IStringField)SwtScoutStringField.this.getScoutObject()).getUIFacade().fireLinkActionFromUI(text);
            }
        };
        this.getEnvironment().invokeScoutLater(t, 0L);
    }

    protected void setSelectionFromSwt(final int startIndex, final int endIndex) {
        if (this.getUpdateSwtFromScoutLock().isAcquired()) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    SwtScoutStringField.this.addIgnoredScoutEvent(PropertyChangeEvent.class, "selectionStart");
                    SwtScoutStringField.this.addIgnoredScoutEvent(PropertyChangeEvent.class, "selectionEnd");
                    ((IStringField)SwtScoutStringField.this.getScoutObject()).getUIFacade().setSelectionFromUI(startIndex, endIndex);
                }
                finally {
                    SwtScoutStringField.this.removeIgnoredScoutEvent(PropertyChangeEvent.class, "selectionStart");
                    SwtScoutStringField.this.removeIgnoredScoutEvent(PropertyChangeEvent.class, "selectionEnd");
                }
            }
        };
        this.getEnvironment().invokeScoutLater(t, 0L);
    }

    @Override
    protected boolean filterKeyEvent(Event e) {
        if (((IStringField)this.getScoutObject()).isMultilineText() && (e.keyCode == 13 || e.keyCode == 0x1000050)) {
            return false;
        }
        return super.filterKeyEvent(e);
    }

    @Override
    protected boolean handleSwtInputVerifier() {
        final String text = this.getSwtField().getText();
        if (CompareUtility.equals((Object)text, (Object)((IStringField)this.getScoutObject()).getDisplayText()) && ((IStringField)this.getScoutObject()).getErrorStatus() == null) {
            return true;
        }
        final Holder result = new Holder(Boolean.class, (Object)false);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((IStringField)SwtScoutStringField.this.getScoutObject()).getUIFacade().setTextFromUI(text);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {}
        this.getEnvironment().dispatchImmediateSwtJobs();
        return true;
    }

    @Override
    protected void handleSwtFocusGained() {
        super.handleSwtFocusGained();
        if (((IStringField)this.getScoutObject()).isSelectAllOnFocus()) {
            this.scheduleSelectAll();
        } else if (this.m_backupSelection != null && this.m_backupSelection.x != this.m_backupSelection.y) {
            this.getSwtField().setSelection(this.m_backupSelection);
        }
    }

    protected void scheduleSelectAll() {
        this.getEnvironment().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SwtScoutStringField.this.getSwtField().isDisposed()) {
                    return;
                }
                SwtScoutStringField.this.getSwtField().setSelection(0, SwtScoutStringField.this.getSwtField().getText().length());
            }
        });
    }

    @Override
    protected void handleSwtFocusLost() {
        this.m_backupSelection = this.getSwtField().getSelection();
        if (this.getSwtField().getSelectionCount() > 0) {
            this.getSwtField().setSelection(0, 0);
        }
    }

    private class P_DndSupport
    extends AbstractSwtScoutDndSupport {
        public P_DndSupport(IPropertyObserver scoutObject, IDNDSupport scoutDndSupportable, Control control, ISwtEnvironment environment) {
            super(scoutObject, scoutDndSupportable, control, environment);
        }

        @Override
        protected TransferObject handleSwtDragRequest() {
            final Holder result = new Holder(TransferObject.class, null);
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    TransferObject scoutTransferable = ((IStringField)SwtScoutStringField.this.getScoutObject()).getUIFacade().fireDragRequestFromUI();
                    result.setValue((Object)scoutTransferable);
                }
            };
            JobEx job = SwtScoutStringField.this.getEnvironment().invokeScoutLater(t, 2345L);
            try {
                job.join(2345L);
            }
            catch (InterruptedException interruptedException) {}
            return (TransferObject)result.getValue();
        }

        @Override
        protected void handleSwtDropAction(DropTargetEvent event, final TransferObject scoutTransferObject) {
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    if (((IStringField)SwtScoutStringField.this.getScoutObject()).isEnabled()) {
                        ((IStringField)SwtScoutStringField.this.getScoutObject()).getUIFacade().fireDropActionFromUi(scoutTransferObject);
                    }
                }
            };
            SwtScoutStringField.this.getEnvironment().invokeScoutLater(job, 200L);
        }
    }

    private class P_SwtLinkTrigger
    extends MouseAdapter {
        private P_SwtLinkTrigger() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            SwtScoutStringField.this.handleSwtLinkTrigger();
        }
    }

    private class P_SwtTextListener
    implements ModifyListener {
        private P_SwtTextListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (SwtScoutStringField.this.m_validateOnAnyKey && SwtScoutStringField.this.getUpdateSwtFromScoutLock().isReleased()) {
                this.sendVerifyToScoutAndIgnoreResponses();
            }
        }

        private void sendVerifyToScoutAndIgnoreResponses() {
            final String text = SwtScoutStringField.this.getSwtField().getText();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((IStringField)SwtScoutStringField.this.getScoutObject()).getUIFacade().setTextFromUI(text);
                }
            };
            SwtScoutStringField.this.getEnvironment().invokeScoutLater(t, 0L);
        }
    }

    private class P_SwtTextSelectionListener
    extends SelectionAdapter {
        private P_SwtTextSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            SwtScoutStringField.this.setSelectionFromSwt(e.x, e.y);
        }
    }

    private class P_TextVerifyListener
    implements VerifyListener {
        private P_TextVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            switch (SwtScoutStringField.this.m_characterType) {
                case 1: {
                    e.text = e.text.toUpperCase();
                    break;
                }
                case 2: {
                    e.text = e.text.toLowerCase();
                }
            }
        }
    }
}

