/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.scout.sdk;

/**
 * <h3>{@link RuntimeClasses}</h3> ...
 * 
 * @author Andreas Hoegger
 * @since 1.0.8 24.01.2009
 */
public final class RuntimeClasses {
  private RuntimeClasses() {
  }

// CHECKSTYLE:OFF
  public static final String ScoutSharedBundleId = "org.eclipse.scout.rt.shared"; // NO_UCD
  public static final String ScoutClientBundleId = "org.eclipse.scout.rt.client"; // NO_UCD
  public static final String ScoutServerBundleId = "org.eclipse.scout.rt.server"; // NO_UCD
  public static final String ScoutUiSwtBundleId = "org.eclipse.scout.rt.ui.swt"; // NO_UCD
  public static final String ScoutUiSwingBundleId = "org.eclipse.scout.rt.ui.swing"; // NO_UCD
  public static final String ScoutClientSvgBundleId = "org.eclipse.scout.svg.client"; // NO_UCD

  public static final String AbstractActivityMap = "org.eclipse.scout.rt.client.ui.basic.activitymap.AbstractActivityMap"; // NO_UCD
  public static final String AbstractBigDecimalField = "org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.AbstractBigDecimalField"; // NO_UCD
  public static final String AbstractBookmarkMenu = "org.eclipse.scout.rt.client.ui.desktop.bookmark.menu.AbstractBookmarkMenu"; // NO_UCD
  public static final String AbstractBookmarkStorageService = "org.eclipse.scout.rt.server.services.common.bookmark.AbstractSqlBookmarkStorageService"; // NO_UCD
  public static final String AbstractBooleanField = "org.eclipse.scout.rt.client.ui.form.fields.booleanfield.AbstractBooleanField"; // NO_UCD
  public static final String AbstractButton = "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton"; // NO_UCD
  public static final String AbstractCalendar = "org.eclipse.scout.rt.client.ui.basic.calendar.AbstractCalendar"; // NO_UCD
  public static final String AbstractCalendarField = "org.eclipse.scout.rt.client.ui.form.fields.calendarfield.AbstractCalendarField"; // NO_UCD
  public static final String AbstractCalendarItem = "org.eclipse.scout.rt.shared.services.common.calendar.AbstractCalendarItem"; // NO_UCD
  public static final String AbstractCalendarItemProvider = "org.eclipse.scout.rt.client.ui.basic.calendar.provider.AbstractCalendarItemProvider"; // NO_UCD
  public static final String AbstractCancelButton = "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCancelButton"; // NO_UCD
  public static final String AbstractChartBox = "org.eclipse.scout.rt.client.ui.form.fields.chartbox.AbstractChartBox"; // NO_UCD
  public static final String AbstractCheckBox = "org.eclipse.scout.rt.client.ui.form.fields.checkbox.AbstractCheckBox"; // NO_UCD
  public static final String AbstractCheckBoxMenu = "org.eclipse.scout.rt.client.ui.action.menu.checkbox.AbstractCheckBoxMenu"; // NO_UCD
  public static final String AbstractCloseButton = "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCloseButton"; // NO_UCD
  public static final String AbstractCode = "org.eclipse.scout.rt.shared.services.common.code.AbstractCode"; // NO_UCD
  public static final String AbstractCodeType = "org.eclipse.scout.rt.shared.services.common.code.AbstractCodeType"; // NO_UCD
  public static final String AbstractColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn"; // NO_UCD
  public static final String AbstractBooleanColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractBooleanColumn"; // NO_UCD
  public static final String AbstractBigDecimalColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractBigDecimalColumn"; // NO_UCD
  public static final String AbstractDateColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractDateColumn"; // NO_UCD
  public static final String AbstractDoubleColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractDoubleColumn"; // NO_UCD
  public static final String AbstractIntegerColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractIntegerColumn"; // NO_UCD
  public static final String AbstractLongColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractLongColumn"; // NO_UCD // NO_UCD
  public static final String AbstractObjectColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractObjectColumn"; // NO_UCD
  public static final String AbstractSmartColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractSmartColumn"; // NO_UCD
  public static final String AbstractStringColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn"; // NO_UCD
  public static final String AbstractSwingEnvironment = "org.eclipse.scout.rt.ui.swing.AbstractSwingEnvironment"; // NO_UCD
  public static final String AbstractComposerAttribute = "org.eclipse.scout.rt.client.ui.form.fields.composer.attribute.AbstractComposerAttribute"; // NO_UCD
  public static final String AbstractComposerEntity = "org.eclipse.scout.rt.client.ui.form.fields.composer.entity.AbstractComposerEntity"; // NO_UCD
  public static final String AbstractComposerField = "org.eclipse.scout.rt.client.ui.form.fields.composer.AbstractComposerField"; // NO_UCD
  public static final String AbstractComposerData = "org.eclipse.scout.rt.shared.data.form.fields.composer.AbstractComposerData"; // NO_UCD
  public static final String AbstractComposerEntityData = "org.eclipse.scout.rt.shared.data.form.fields.composer.AbstractComposerEntityData"; // NO_UCD
  public static final String AbstractComposerAttributeData = "org.eclipse.scout.rt.shared.data.form.fields.composer.AbstractComposerAttributeData"; // NO_UCD
  public static final String AbstractComposerField_Tree = "org.eclipse.scout.rt.client.ui.form.fields.composer.AbstractComposerField.Tree"; // NO_UCD
  public static final String AbstractCompositeField = "org.eclipse.scout.rt.client.ui.form.fields.AbstractCompositeField"; // NO_UCD
  public static final String AbstractCustomField = "org.eclipse.scout.rt.client.ui.form.fields.customfield.AbstractCustomField"; // NO_UCD
  public static final String AbstractDateField = "org.eclipse.scout.rt.client.ui.form.fields.datefield.AbstractDateField"; // NO_UCD
  public static final String AbstractDesktop = "org.eclipse.scout.rt.client.ui.desktop.AbstractDesktop"; // NO_UCD
  public static final String AbstractDesktopExtension = "org.eclipse.scout.rt.client.ui.desktop.AbstractDesktopExtension"; // NO_UCD
  public static final String AbstractDoubleField = "org.eclipse.scout.rt.client.ui.form.fields.doublefield.AbstractDoubleField"; // NO_UCD
  public static final String AbstractFileChooserField = "org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.AbstractFileChooserField"; // NO_UCD
  public static final String AbstractForm = "org.eclipse.scout.rt.client.ui.form.AbstractForm"; // NO_UCD
  public static final String AbstractFormData = "org.eclipse.scout.rt.shared.data.form.AbstractFormData"; // NO_UCD
  public static final String AbstractFormField = "org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField"; // NO_UCD
  public static final String AbstractFormFieldData = "org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData"; // NO_UCD
  public static final String AbstractFormHandler = "org.eclipse.scout.rt.client.ui.form.AbstractFormHandler"; // NO_UCD
  public static final String AbstractGroupBox = "org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox"; // NO_UCD
  public static final String AbstractHtmlField = "org.eclipse.scout.rt.client.ui.form.fields.htmlfield.AbstractHtmlField"; // NO_UCD
  public static final String AbstractIcons = "org.eclipse.scout.rt.shared.AbstractIcons"; // NO_UCD
  public static final String AbstractImageField = "org.eclipse.scout.rt.client.ui.form.fields.imagebox.AbstractImageField"; // NO_UCD
  public static final String AbstractIntegerField = "org.eclipse.scout.rt.client.ui.form.fields.integerfield.AbstractIntegerField"; // NO_UCD
  public static final String AbstractKeyStroke = "org.eclipse.scout.rt.client.ui.action.keystroke.AbstractKeyStroke"; // NO_UCD
  public static final String AbstractLabelField = "org.eclipse.scout.rt.client.ui.form.fields.labelfield.AbstractLabelField"; // NO_UCD
  public static final String AbstractListBox = "org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox"; // NO_UCD
  public static final String AbstractLongField = "org.eclipse.scout.rt.client.ui.form.fields.longfield.AbstractLongField"; // NO_UCD
  public static final String AbstractLookupService = "org.eclipse.scout.rt.server.services.lookup.AbstractLookupService"; // NO_UCD
  public static final String AbstractMailField = "org.eclipse.scout.rt.client.ui.form.fields.mailfield.AbstractMailField"; // NO_UCD
  public static final String AbstractMatrixField = "org.eclipse.scout.rt.client.ui.form.fields.matrixfield.AbstractMatrixField"; // NO_UCD
  public static final String AbstractMenu = "org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu"; // NO_UCD
  public static final String AbstractOkButton = "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractOkButton"; // NO_UCD
  public static final String AbstractOutline = "org.eclipse.scout.rt.client.ui.desktop.outline.AbstractOutline"; // NO_UCD
  public static final String AbstractOutlineToolButton = "org.eclipse.scout.rt.client.ui.desktop.outline.AbstractOutlineToolButton"; // NO_UCD
  public static final String AbstractOutlineViewButton = "org.eclipse.scout.rt.client.ui.desktop.outline.AbstractOutlineViewButton"; // NO_UCD
  public static final String AbstractPageWithNodes = "org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPageWithNodes"; // NO_UCD
  public static final String AbstractPageWithTable = "org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPageWithTable"; // NO_UCD
  public static final String AbstractPlannerField = "org.eclipse.scout.rt.client.ui.form.fields.plannerfield.AbstractPlannerField"; // NO_UCD
  public static final String AbstractPropertyData = "org.eclipse.scout.rt.shared.data.form.properties.AbstractPropertyData"; // NO_UCD
  public static final String AbstractRadioButton = "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractRadioButton"; // NO_UCD
  public static final String AbstractRadioButtonGroup = "org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.AbstractRadioButtonGroup"; // NO_UCD
  public static final String AbstractResetButton = "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractResetButton"; // NO_UCD
  public static final String AbstractSaveButton = "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractSaveButton"; // NO_UCD
  public static final String AbstractSearchButton = "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractSearchButton"; // NO_UCD
  public static final String AbstractSearchForm = "org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractSearchForm"; // NO_UCD
  public static final String AbstractSequenceBox = "org.eclipse.scout.rt.client.ui.form.fields.sequencebox.AbstractSequenceBox"; // NO_UCD
  public static final String AbstractService = "org.eclipse.scout.service.AbstractService"; // NO_UCD
  public static final String AbstractSmartField = "org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartField"; // NO_UCD
  public static final String AbstractSMTPService = "org.eclipse.scout.rt.server.services.common.smtp.AbstractSMTPService"; // NO_UCD
  public static final String AbstractSqlLookupService = "org.eclipse.scout.rt.server.services.lookup.AbstractSqlLookupService"; // NO_UCD
  public static final String AbstractSqlService = "org.eclipse.scout.rt.server.services.common.jdbc.AbstractSqlService"; // NO_UCD
  public static final String AbstractDynamicNlsTextProviderService = "org.eclipse.scout.rt.shared.services.common.text.AbstractDynamicNlsTextProviderService"; // NO_UCD

  public static final String AbstractStringField = "org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField"; // NO_UCD
  public static final String AbstractTabBox = "org.eclipse.scout.rt.client.ui.form.fields.tabbox.AbstractTabBox"; // NO_UCD
  public static final String AbstractTable = "org.eclipse.scout.rt.client.ui.basic.table.AbstractTable"; // NO_UCD
  public static final String AbstractTableField = "org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField"; // NO_UCD
  public static final String AbstractTableFieldData = "org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldData"; // NO_UCD
  public static final String AbstractTimeField = "org.eclipse.scout.rt.client.ui.form.fields.timefield.AbstractTimeField"; // NO_UCD
  public static final String AbstractToolButton = "org.eclipse.scout.rt.client.ui.action.tool.AbstractToolButton"; // NO_UCD
  public static final String AbstractTree = "org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree"; // NO_UCD
  public static final String AbstractTreeBox = "org.eclipse.scout.rt.client.ui.form.fields.treebox.AbstractTreeBox"; // NO_UCD
  public static final String AbstractTreeField = "org.eclipse.scout.rt.client.ui.form.fields.treefield.AbstractTreeField"; // NO_UCD
  public static final String AbstractValueField = "org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField"; // NO_UCD
  public static final String AbstractValueFieldData = "org.eclipse.scout.rt.shared.data.form.fields.AbstractValueFieldData"; // NO_UCD
  public static final String AbstractWizard = "org.eclipse.scout.rt.client.ui.wizard.AbstractWizard"; // NO_UCD
  public static final String AbstractWizardStep = "org.eclipse.scout.rt.client.ui.wizard.AbstractWizardStep"; // NO_UCD
  public static final String ACCESS = "org.eclipse.scout.rt.shared.services.common.security.ACCESS"; // NO_UCD
  public static final String BasicHierarchyPermission = "org.eclipse.scout.rt.shared.security.BasicHierarchyPermission"; // NO_UCD
  public static final String BasicPermission = "java.security.BasicPermission"; // NO_UCD
  public static final String FormData = "org.eclipse.scout.commons.annotations.FormData"; // NO_UCD
  public static final String FormData_UpdateOperation = "org.eclipse.scout.commons.annotations.FormData.UpdateOperation"; // NO_UCD
  public static final String ClientProxyServiceFactory = "org.eclipse.scout.rt.client.services.ClientProxyServiceFactory"; // NO_UCD
  public static final String ClientServiceFactory = "org.eclipse.scout.rt.client.services.ClientServiceFactory"; // NO_UCD
  public static final String ConfigProperty = "org.eclipse.scout.commons.annotations.ConfigProperty"; // NO_UCD
  public static final String ConfigOperation = "org.eclipse.scout.commons.annotations.ConfigOperation"; // NO_UCD
  public static final String ConfigPropertyValue = "org.eclipse.scout.commons.annotations.ConfigPropertyValue"; // NO_UCD
  public static final String DefaultOutlineTableForm = "org.eclipse.scout.rt.client.ui.form.outline.DefaultOutlineTableForm"; // NO_UCD
  public static final String DefaultOutlineTreeForm = "org.eclipse.scout.rt.client.ui.form.outline.DefaultOutlineTreeForm"; // NO_UCD
  public static final String DefaultServiceFactory = "org.eclipse.scout.service.DefaultServiceFactory"; // NO_UCD

  public static final String DynamicNls = "org.eclipse.scout.nls.DynamicNls"; // NO_UCD
  public static final String ExampleWorkflowTablePage = "org.eclipse.scout.rt.client.ui.desktop.outline.pages.workflow.ExampleWorkflowTablePage"; // NO_UCD
  public static final String IActivityMap = "org.eclipse.scout.rt.client.ui.basic.activitymap.IActivityMap"; // NO_UCD
  public static final String IBigDecimalField = "org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.IBigDecimalField"; // NO_UCD
  public static final String IBookmarkStorageService = "org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkStorageService"; // NO_UCD
  public static final String IBooleanField = "org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField"; // NO_UCD
  public static final String IButton = "org.eclipse.scout.rt.client.ui.form.fields.button.IButton"; // NO_UCD
  public static final String ICalendar = "org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar"; // NO_UCD
  public static final String ICalendarField = "org.eclipse.scout.rt.client.ui.form.fields.calendarfield.ICalendarField"; // NO_UCD
  public static final String ICalendarItem = "org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem"; // NO_UCD
  public static final String ICalendarItemProvider = "org.eclipse.scout.rt.client.ui.basic.calendar.provider.ICalendarItemProvider"; // NO_UCD
  public static final String ICalendarService = "org.eclipse.scout.rt.shared.services.common.calendar.ICalendarService"; // NO_UCD
  public static final String IChartBox = "org.eclipse.scout.rt.client.ui.form.fields.chartbox.IChartBox"; // NO_UCD
  public static final String IChartField = "org.eclipse.scout.rt.client.ui.form.fields.chartfield.IChartField"; // NO_UCD
  public static final String ICheckBox = "org.eclipse.scout.rt.client.ui.form.fields.checkbox.ICheckBox"; // NO_UCD
  public static final String IClientSession = "org.eclipse.scout.rt.client.IClientSession"; // NO_UCD
  public static final String ICode = "org.eclipse.scout.rt.shared.services.common.code.ICode"; // NO_UCD
  public static final String ICodeType = "org.eclipse.scout.rt.shared.services.common.code.ICodeType"; // NO_UCD
  public static final String IColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn"; // NO_UCD
  public static final String IComposerAttribute = "org.eclipse.scout.rt.client.ui.form.fields.composer.attribute.IComposerAttribute"; // NO_UCD
  public static final String IComposerEntity = "org.eclipse.scout.rt.client.ui.form.fields.composer.entity.IComposerEntity"; // NO_UCD
  public static final String IComposerField = "org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField"; // NO_UCD
  public static final String ICompositeField = "org.eclipse.scout.rt.client.ui.form.fields.ICompositeField"; // NO_UCD
  public static final String ICustomField = "org.eclipse.scout.rt.client.ui.form.fields.customfield.ICustomField"; // NO_UCD
  public static final String IDateField = "org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField"; // NO_UCD
  public static final String IDesktop = "org.eclipse.scout.rt.client.ui.desktop.IDesktop"; // NO_UCD
  public static final String IDesktopExtension = "org.eclipse.scout.rt.client.ui.desktop.IDesktopExtension"; // NO_UCD
  public static final String IDoubleField = "org.eclipse.scout.rt.client.ui.form.fields.doublefield.IDoubleField"; // NO_UCD
  public static final String IFileChooserField = "org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.IFileChooserField"; // NO_UCD
  public static final String IForm = "org.eclipse.scout.rt.client.ui.form.IForm"; // NO_UCD
  public static final String IFormField = "org.eclipse.scout.rt.client.ui.form.fields.IFormField"; // NO_UCD
  public static final String IFormHandler = "org.eclipse.scout.rt.client.ui.form.IFormHandler"; // NO_UCD
  public static final String IGroupBox = "org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox"; // NO_UCD
  public static final String IHtmlField = "org.eclipse.scout.rt.client.ui.form.fields.htmlfield.IHtmlField"; // NO_UCD
  public static final String IImageField = "org.eclipse.scout.rt.client.ui.form.fields.imagebox.IImageField"; // NO_UCD
  public static final String IIntegerField = "org.eclipse.scout.rt.client.ui.form.fields.integerfield.IIntegerField"; // NO_UCD
  public static final String IKeyStroke = "org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke"; // NO_UCD
  public static final String ILabelField = "org.eclipse.scout.rt.client.ui.form.fields.labelfield.ILabelField"; // NO_UCD
  public static final String IListBox = "org.eclipse.scout.rt.client.ui.form.fields.listbox.IListBox"; // NO_UCD
  public static final String ILongField = "org.eclipse.scout.rt.client.ui.form.fields.longfield.ILongField"; // NO_UCD
  public static final String ILookupService = "org.eclipse.scout.rt.shared.services.lookup.ILookupService"; // NO_UCD
  public static final String IMailField = "org.eclipse.scout.rt.client.ui.form.fields.mailfield.IMailField"; // NO_UCD
  public static final String ITextProviderService = "org.eclipse.scout.rt.shared.services.common.text.ITextProviderService"; // NO_UCD

  public static final String IMatrixField = "org.eclipse.scout.rt.client.ui.form.fields.matrixfield.IMatrixField"; // NO_UCD
  public static final String IMenu = "org.eclipse.scout.rt.client.ui.action.menu.IMenu"; // NO_UCD
  public static final String IOutline = "org.eclipse.scout.rt.client.ui.desktop.outline.IOutline"; // NO_UCD
  public static final String IPage = "org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage"; // NO_UCD
  public static final String IPageWithNodes = "org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes"; // NO_UCD
  public static final String IPageWithTable = "org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable"; // NO_UCD
  public static final String IPlannerField = "org.eclipse.scout.rt.client.ui.form.fields.plannerfield.IPlannerField"; // NO_UCD
  public static final String IPropertyObserver = "org.eclipse.scout.commons.beans.IPropertyObserver"; // NO_UCD
  public static final String IRadioButtonGroup = "org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup"; // NO_UCD
  public static final String IScoutLogger = "org.eclipse.scout.commons.logger.IScoutLogger"; // NO_UCD
  public static final String ISearchForm = "org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm"; // NO_UCD
  public static final String ISequenceBox = "org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox"; // NO_UCD
  public static final String IServerSession = "org.eclipse.scout.rt.server.IServerSession"; // NO_UCD
  public static final String IService = "org.eclipse.scout.service.IService"; // NO_UCD
  public static final String IService2 = "org.eclipse.scout.service.IService2"; // NO_UCD
  public static final String ISmartField = "org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField"; // NO_UCD
  public static final String ISMTPService = "org.eclipse.scout.rt.server.services.common.smtp.ISMTPService"; // NO_UCD
  public static final String ISplitBox = "org.eclipse.scout.rt.client.ui.form.fields.splitbox.ISplitBox"; // NO_UCD
  public static final String ISqlService = "org.eclipse.scout.rt.server.services.common.jdbc.ISqlService"; // NO_UCD
  public static final String IStringField = "org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField"; // NO_UCD
  public static final String ITabBox = "org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox"; // NO_UCD
  public static final String ITable = "org.eclipse.scout.rt.client.ui.basic.table.ITable"; // NO_UCD
  public static final String ITableRow = "org.eclipse.scout.rt.client.ui.basic.table.ITableRow"; // NO_UCD
  public static final String ITableField = "org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField"; // NO_UCD
  public static final String ITimeField = "org.eclipse.scout.rt.client.ui.form.fields.timefield.ITimeField"; // NO_UCD
  public static final String IToolButton = "org.eclipse.scout.rt.client.ui.action.tool.IToolButton"; // NO_UCD
  public static final String ITree = "org.eclipse.scout.rt.client.ui.basic.tree.ITree"; // NO_UCD
  public static final String ITreeBox = "org.eclipse.scout.rt.client.ui.form.fields.treebox.ITreeBox"; // NO_UCD
  public static final String ITreeField = "org.eclipse.scout.rt.client.ui.form.fields.treefield.ITreeField"; // NO_UCD
  public static final String ITreeNode = "org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode"; // NO_UCD
  public static final String IValueField = "org.eclipse.scout.rt.client.ui.form.fields.IValueField"; // NO_UCD
  public static final String IViewButton = "org.eclipse.scout.rt.client.ui.action.view.IViewButton"; // NO_UCD
  public static final String IWizard = "org.eclipse.scout.rt.client.ui.wizard.IWizard"; // NO_UCD
  public static final String IWizardStep = "org.eclipse.scout.rt.client.ui.wizard.IWizardStep"; // NO_UCD
  public static final String LocalLookupCall = "org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall"; // NO_UCD
  public static final String LookupCall = "org.eclipse.scout.rt.shared.services.lookup.LookupCall"; // NO_UCD
  public static final String LookupRow = "org.eclipse.scout.rt.shared.services.lookup.LookupRow"; // NO_UCD
  public static final String Order = "org.eclipse.scout.commons.annotations.Order"; // NO_UCD
  public static final String Ranking = "org.eclipse.scout.commons.annotations.Priority"; // NO_UCD
  public static final String ScoutTexts = "org.eclipse.scout.rt.shared.ScoutTexts"; // NO_UCD
  public static final String SearchFilter = "org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter"; // NO_UCD
  public static final String ServerServiceFactory = "org.eclipse.scout.rt.server.services.ServerServiceFactory"; // NO_UCD
  public static final String SERVICES = "org.eclipse.scout.service.SERVICES"; // NO_UCD
  public static final String TEXTS = "org.eclipse.scout.rt.shared.TEXTS"; // NO_UCD
  public static final String IDocumentationTextProviderService = "org.eclipse.scout.rt.shared.services.common.text.IDocumentationTextProviderService"; // NO_UCD
  public static final String ProcessingException = "org.eclipse.scout.commons.exception.ProcessingException"; // NO_UCD
  public static final String ValidationRule = "org.eclipse.scout.rt.shared.data.form.ValidationRule"; // NO_UCD
  public static final String VetoException = "org.eclipse.scout.commons.exception.VetoException"; // NO_UCD

  public static final String IBigDecimalColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.IBigDecimalColumn"; // NO_UCD
  public static final String IBooleanColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn"; // NO_UCD
  public static final String IDateColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.IDateColumn"; // NO_UCD
  public static final String IDoubleColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.IDoubleColumn"; // NO_UCD
  public static final String IIntegerColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.IIntegerColumn"; // NO_UCD
  public static final String ILongColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.ILongColumn"; // NO_UCD
  public static final String ISmartColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn"; // NO_UCD
  public static final String IStringColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.IStringColumn"; // NO_UCD
  public static final String ITimeColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.ITimeColumn"; // NO_UCD
  public static final String CopyWidthsOfColumnsMenu = "org.eclipse.scout.rt.client.ui.basic.table.menus.CopyWidthsOfColumnsMenu"; // NO_UCD

  public static final String ResourceServlet = "org.eclipse.scout.rt.server.ResourceServlet"; // NO_UCD
//CHECKSTYLE:ON
}
