/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.codecompletion.sql;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.ReplaceEdit;

public class SqlBindProposal
implements ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4 {
    private final String m_prefix;
    private final int m_offset;
    private final Image m_image;
    private final String m_elementName;

    public SqlBindProposal(String elementName, String prefix, int offset, Image image) {
        this.m_elementName = elementName;
        this.m_prefix = prefix;
        this.m_offset = offset;
        this.m_image = image;
    }

    public void apply(IDocument document) {
        this.apply(null, '\u0000', 0, this.m_offset);
    }

    public Point getSelection(IDocument document) {
        return new Point(this.m_offset - this.m_prefix.length() + this.getElementName().length(), 0);
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return this.getCompletionText();
    }

    public Image getImage() {
        return this.m_image;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public void apply(IDocument document, char trigger, int offset) {
        int offDiff = offset - this.m_offset;
        ReplaceEdit replaceEdit = new ReplaceEdit(this.m_offset - this.m_prefix.length(), this.m_prefix.length() + offDiff, this.getCompletionText());
        try {
            replaceEdit.apply(document);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("could not apply proposal.", e);
        }
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.validate(document, offset, null);
    }

    public char[] getTriggerCharacters() {
        return null;
    }

    public int getContextInformationPosition() {
        return 0;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.apply(viewer.getDocument(), trigger, offset);
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            String prefix = String.valueOf(this.m_prefix) + document.get(this.m_offset, offset - this.m_offset);
            return this.getElementName().toLowerCase().startsWith(prefix.toLowerCase());
        }
        catch (BadLocationException e) {
            ScoutSdkUi.logWarning("could not validate proposal.", e);
            return false;
        }
    }

    public IInformationControlCreator getInformationControlCreator() {
        return null;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.getCompletionText();
    }

    private String getCompletionText() {
        String simpleName = this.getElementName();
        if (simpleName.length() > 1) {
            simpleName = String.valueOf(Character.toLowerCase(simpleName.charAt(0))) + simpleName.substring(1);
        }
        return simpleName;
    }

    public String getElementName() {
        return this.m_elementName;
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.m_offset - this.m_prefix.length();
    }

    public boolean isAutoInsertable() {
        return true;
    }
}

