/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.project.template;

import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.sdk.ui.extensions.project.template.IProjectTemplate;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.project.template.ProjectTemplateExtension;

public class ProjectTemplateExtensionPoint {
    private static String extensionId = "scoutProjectTemplate";
    private static String attributeId = "id";
    private static String attributeOrderNumber = "orderNumber";
    private static String attributeClass = "class";
    private static String attributeIcon = "icon";
    private static final ProjectTemplateExtensionPoint instance = new ProjectTemplateExtensionPoint();
    private TreeSet<ProjectTemplateExtension> m_extensions;

    private ProjectTemplateExtensionPoint() {
        this.init();
    }

    private void init() {
        IExtension[] extensions;
        this.m_extensions = new TreeSet<ProjectTemplateExtension>(new P_ExtensionComparator());
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", extensionId);
        IExtension[] iExtensionArray = extensions = xp.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                ProjectTemplateExtension extensionPoint = new ProjectTemplateExtension();
                extensionPoint.setExtensionId(element.getAttribute(attributeId));
                try {
                    extensionPoint.setTemplate((IProjectTemplate)element.createExecutableExtension(attributeClass));
                }
                catch (CoreException e) {
                    ScoutSdkUi.logError("could not load class '" + element.getAttribute(attributeClass) + "'.", e);
                }
                extensionPoint.setIconPath(element.getAttribute(attributeIcon));
                String attOrderNr = element.getAttribute(attributeOrderNumber);
                try {
                    extensionPoint.setOrderNr(new Long(attOrderNr).intValue());
                }
                catch (NumberFormatException e) {
                    ScoutSdkUi.logError("could not parse order number '" + attOrderNr + "' of extension '" + element.getNamespaceIdentifier() + "'.", e);
                }
                if (extensionPoint.isValidConfiguration()) {
                    this.m_extensions.add(extensionPoint);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static final ProjectTemplateExtension[] getExtensions() {
        return instance.getExtensionsImpl();
    }

    private final ProjectTemplateExtension[] getExtensionsImpl() {
        return this.m_extensions.toArray(new ProjectTemplateExtension[this.m_extensions.size()]);
    }

    private class P_ExtensionComparator
    implements Comparator<ProjectTemplateExtension> {
        private P_ExtensionComparator() {
        }

        @Override
        public int compare(ProjectTemplateExtension o1, ProjectTemplateExtension o2) {
            int diff;
            if (o1.getOrderNr() != o2.getOrderNr() && (diff = (int)(o1.getOrderNr() - o2.getOrderNr())) != 0) {
                return diff;
            }
            return o1.getExtensionId().compareTo(o2.getExtensionId());
        }
    }
}

