/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.library.LibraryBundleLinkAction;
import org.eclipse.scout.sdk.ui.action.library.LibraryBundleNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.library.LibraryNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.pde.PluginModelHelper;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class LibrariesTablePage
extends AbstractPage {
    private P_PluginModelListener m_dirtyListener;
    private final IScoutBundle m_ownerBundle;

    public LibrariesTablePage(IPage parent) {
        this(parent, null);
    }

    public LibrariesTablePage(IPage parent, IScoutBundle ownerBundle) {
        this.m_ownerBundle = ownerBundle;
        this.setParent(parent);
        this.setName(Texts.get((String)"Libraries"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("libraries.png"));
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.LibrariesTablePage";
    }

    @Override
    public void unloadPage() {
        super.unloadPage();
        if (this.m_dirtyListener != null) {
            PDECore.getDefault().getModelManager().removePluginModelListener((IPluginModelListener)this.m_dirtyListener);
        }
    }

    public IScoutBundle getScoutResource() {
        return this.m_ownerBundle;
    }

    @Override
    protected void loadChildrenImpl() {
        if (this.m_dirtyListener == null) {
            this.m_dirtyListener = new P_PluginModelListener();
            PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this.m_dirtyListener);
        }
        try {
            ArrayList<IPluginModelBase> libraries = new ArrayList<IPluginModelBase>(3);
            if (this.getScoutResource() != null) {
                PluginModelHelper helper = new PluginModelHelper(this.getScoutResource().getProject());
                IPluginImport[] allDependencies = helper.Manifest.getAllDependencies();
                HashSet<String> dependencyIds = new HashSet<String>(allDependencies.length);
                IPluginImport[] iPluginImportArray = allDependencies;
                int n = allDependencies.length;
                int n2 = 0;
                while (n2 < n) {
                    IPluginImport dependency = iPluginImportArray[n2];
                    dependencyIds.add(dependency.getId());
                    ++n2;
                }
                for (IPluginModelBase potLib : this.getAllLibrariesInWorkspace()) {
                    if (!dependencyIds.contains(potLib.getPluginBase().getId())) continue;
                    libraries.add(potLib);
                }
            } else {
                libraries.addAll(this.getAllLibrariesInWorkspace());
            }
            for (IPluginModelBase pluginModel : libraries) {
                new LibraryNodePage(this, pluginModel);
            }
        }
        catch (CoreException e) {
            ScoutSdkUi.logWarning("Could not load library table page.", e);
        }
    }

    private Collection<IPluginModelBase> getAllLibrariesInWorkspace() throws CoreException {
        IPluginModelBase[] workspaceModels = PluginRegistry.getWorkspaceModels();
        ArrayList<IPluginModelBase> libraries = new ArrayList<IPluginModelBase>();
        IPluginModelBase[] iPluginModelBaseArray = workspaceModels;
        int n = workspaceModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            IProject project = model.getUnderlyingResource().getProject();
            if (project != null && project.exists() && project.isOpen() && project.hasNature("org.eclipse.scout.sdk.ScoutLibraryNature")) {
                libraries.add(model);
            }
            ++n2;
        }
        return libraries;
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{LibraryBundleNewAction.class, LibraryBundleLinkAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof LibraryBundleNewAction) {
            ((LibraryBundleNewAction)menu).setOwnerBundle(this.getScoutResource());
        } else if (menu instanceof LibraryBundleLinkAction) {
            ((LibraryBundleLinkAction)menu).setLibraryUserBundle(this.getScoutResource());
        }
        super.prepareMenuAction(menu);
    }

    private final class P_PluginModelListener
    implements IPluginModelListener {
        private P_PluginModelListener() {
        }

        public void modelsChanged(PluginModelDelta delta) {
            LibrariesTablePage.this.markStructureDirty();
        }
    }
}

