/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared;

import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.ShowJavaReferencesAction;
import org.eclipse.scout.sdk.ui.action.create.CodeNewAction;
import org.eclipse.scout.sdk.ui.action.delete.MemberListDeleteAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.CodeNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.InnerTypePageDirtyListener;
import org.eclipse.scout.sdk.util.ScoutSourceUtility;
import org.eclipse.scout.sdk.util.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.TypeCacheAccessor;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class CodeTypeNodePage
extends AbstractScoutTypePage {
    final IType iCode = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.code.ICode");
    private InnerTypePageDirtyListener m_innerTypeListener;

    public CodeTypeNodePage(IPage parent, IType type) {
        this.setParent(parent);
        this.setType(type);
        this.setName(ScoutSourceUtility.getTranslatedMethodStringValue((IType)this.getType(), (String)"getConfiguredText"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("codeType.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.CodeTypeNodePage";
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void unloadPage() {
        super.unloadPage();
        if (this.m_innerTypeListener != null) {
            TypeCacheAccessor.getJavaResourceChangedEmitter().removeInnerTypeChangedListener(this.getType(), (IJavaResourceChangedListener)this.m_innerTypeListener);
            this.m_innerTypeListener = null;
        }
    }

    @Override
    public void loadChildrenImpl() {
        IType[] codes;
        if (this.m_innerTypeListener == null) {
            this.m_innerTypeListener = new InnerTypePageDirtyListener(this, this.iCode);
            TypeCacheAccessor.getJavaResourceChangedEmitter().addInnerTypeChangedListener(this.getType(), (IJavaResourceChangedListener)this.m_innerTypeListener);
        }
        IType[] iTypeArray = codes = ScoutTypeUtility.getCodes((IType)this.getType());
        int n = codes.length;
        int n2 = 0;
        while (n2 < n) {
            IType code = iTypeArray[n2];
            new CodeNodePage(this, code);
            ++n2;
        }
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{MemberListDeleteAction.class, CodeNewAction.class, ShowJavaReferencesAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        super.prepareMenuAction(menu);
        if (menu instanceof MemberListDeleteAction) {
            MemberListDeleteAction action = (MemberListDeleteAction)menu;
            action.setImage(ScoutSdkUi.getImageDescriptor("codeType_remove.png"));
            action.addMemberToDelete((IMember)this.getType());
        } else if (menu instanceof CodeNewAction) {
            ((CodeNewAction)menu).setType(this.getType());
        }
    }
}

