/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.MethodOverrideOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractMethodPresenter;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ExecMethodPresenter
extends AbstractMethodPresenter {
    private ImageHyperlink m_addButton;

    public ExecMethodPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected Control createContent(Composite container) {
        return null;
    }

    @Override
    protected void fillButtonArea(Composite buttonArea) {
        super.fillButtonArea(buttonArea);
        this.m_addButton = this.getToolkit().createImageHyperlink(buttonArea, 8);
        this.m_addButton.setImage(ScoutSdkUi.getImage("add.png"));
        this.m_addButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ExecMethodPresenter.this.overrideMethod();
            }
        });
        GridData buttonData = new GridData(16384, 1024, false, false);
        this.m_addButton.setLayoutData((Object)buttonData);
    }

    @Override
    protected void handleLabelLinkSelected() {
        if (this.getMethod().isImplemented()) {
            this.showJavaElementInEditor((IJavaElement)this.getMethod().peekMethod());
        } else {
            this.overrideMethod();
        }
    }

    @Override
    protected void init(ConfigurationMethod method) throws CoreException {
        super.init(method);
        ((GridData)this.m_addButton.getLayoutData()).exclude = this.getMethod().isImplemented();
        this.m_addButton.setVisible(!this.getMethod().isImplemented());
        this.m_addButton.setToolTipText(Texts.get((String)"ImplementXInY", (String[])new String[]{this.getMethod().getMethodName(), this.getMethod().getType().getElementName()}));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!this.isDisposed()) {
            this.m_addButton.setEnabled(enabled);
        }
    }

    protected void overrideMethod() {
        if (!this.getMethod().isImplemented()) {
            try {
                MethodOverrideOperation overrideOp = new MethodOverrideOperation(this.getMethod().getType(), this.getMethod().getMethodName(), true);
                IJavaElement sibling = null;
                IStructuredType structuredType = ScoutTypeUtility.createStructuredType((IType)this.getMethod().getType());
                sibling = structuredType.getSiblingMethodConfigExec(this.getMethod().getMethodName());
                overrideOp.setSibling(sibling);
                OperationJob job = new OperationJob(new IOperation[]{overrideOp});
                job.schedule();
                try {
                    job.join();
                }
                catch (InterruptedException interruptedException) {}
                if (overrideOp.getCreatedMethod() != null) {
                    this.showJavaElementInEditor((IJavaElement)overrideOp.getCreatedMethod());
                }
            }
            catch (JavaModelException e) {
                ScoutSdkUi.logWarning("could not override the method '" + this.getMethod().getMethodName() + "' on '" + this.getMethod().getType().getFullyQualifiedName() + "'", e);
            }
        }
    }
}

