/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.StaticContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.styled.SearchRangeStyledLabelProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractProposalPresenter;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class HorizontalAlignmentPresenter
extends AbstractProposalPresenter<HorizontalAlignment> {
    public HorizontalAlignmentPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected void createProposalFieldProviders(ProposalTextField proposalField) {
        SearchRangeStyledLabelProvider labelProvider = new SearchRangeStyledLabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }

            public Image getImage(Object element) {
                HorizontalAlignment value = (HorizontalAlignment)((Object)element);
                switch (value) {
                    case Left: {
                        return ScoutSdkUi.getImage("horizontal_left.gif");
                    }
                    case Center: {
                        return ScoutSdkUi.getImage("horizontal_center.gif");
                    }
                    case Right: {
                        return ScoutSdkUi.getImage("horizontal_right.gif");
                    }
                }
                return null;
            }
        };
        this.getProposalField().setLabelProvider((IBaseLabelProvider)labelProvider);
        StaticContentProvider provider = new StaticContentProvider((Object[])HorizontalAlignment.values(), labelProvider);
        this.getProposalField().setContentProvider(provider);
    }

    @Override
    protected HorizontalAlignment parseInput(String input) throws CoreException {
        int parsedInt = PropertyMethodSourceUtility.parseReturnParameterInteger((String)input, (IMethod)this.getMethod().peekMethod(), (ITypeHierarchy)this.getMethod().getSuperTypeHierarchy());
        if (parsedInt < 0) {
            return HorizontalAlignment.Left;
        }
        if (parsedInt == 0) {
            return HorizontalAlignment.Center;
        }
        return HorizontalAlignment.Right;
    }

    @Override
    protected synchronized void storeValue(HorizontalAlignment value) {
        if (value == null) {
            this.getProposalField().acceptProposal(this.getDefaultValue());
            value = (HorizontalAlignment)((Object)this.getDefaultValue());
        }
        ScoutMethodDeleteOperation op = null;
        if (UiUtility.equals((HorizontalAlignment)((Object)this.getDefaultValue()), value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            StringBuilder source = new StringBuilder("return ");
            switch (value) {
                case Left: {
                    source.append("-1");
                    break;
                }
                case Center: {
                    source.append("0");
                    break;
                }
                case Right: {
                    source.append("1");
                }
            }
            source.append(";");
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), source.toString(), true);
        }
        if (op != null) {
            OperationJob job = new OperationJob(new IOperation[]{op});
            job.schedule();
        }
    }

    protected static enum HorizontalAlignment {
        Left,
        Center,
        Right;

    }
}

