/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.annotation.AnnotationCreateOperation;
import org.eclipse.scout.sdk.ui.dialog.JavaElementSelectionDialog;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractJavaElementListPresenter;
import org.eclipse.scout.sdk.util.signature.IImportValidator;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.Composite;

public class OutlinesPresenter
extends AbstractJavaElementListPresenter {
    final IType iOutline = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.IOutline");

    public OutlinesPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    public IJavaElement[] readSource() throws CoreException {
        ArrayList<IType> props = new ArrayList<IType>();
        IType[] iTypeArray = ScoutTypeUtility.getTypeOccurenceInMethod((IMethod)this.getMethod().peekMethod());
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            props.add(type);
            ++n2;
        }
        return props.toArray(new IJavaElement[props.size()]);
    }

    @Override
    protected void handleAddComponent() {
        IJavaElement[] newOutlines;
        HashSet<IJavaElement> sourceProposals = new HashSet<IJavaElement>(Arrays.asList(this.getSourceProps()));
        ArrayList<IType> candidates = new ArrayList<IType>();
        IPrimaryTypeTypeHierarchy outlineHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.iOutline);
        ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getTypesOnClasspath((IJavaProject)this.getMethod().getType().getJavaProject()), TypeFilters.getClassFilter()});
        IType[] iTypeArray = outlineHierarchy.getAllSubtypes(this.iOutline, filter, TypeComparators.getTypeNameComparator());
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            if (!sourceProposals.contains(t)) {
                candidates.add(t);
            }
            ++n2;
        }
        JavaElementSelectionDialog dialog = new JavaElementSelectionDialog(this.getContainer().getShell(), Texts.get((String)"AddOutline"));
        dialog.addPropertyChangeListener(new P_OutlineDialogPropertyListener(dialog));
        dialog.setMultiSelect(true);
        dialog.setJavaElements(candidates.toArray(new IJavaElement[candidates.size()]));
        dialog.create();
        dialog.getOkButton().setEnabled(false);
        if (dialog.open() == 0 && (newOutlines = dialog.getSelectedElements()).length > 0) {
            ArrayList<IJavaElement> outlines = new ArrayList<IJavaElement>(Arrays.asList(this.getSourceProps()));
            outlines.addAll(Arrays.asList(newOutlines));
            this.store(outlines.toArray(new IJavaElement[outlines.size()]));
        }
    }

    @Override
    public synchronized void store(final IJavaElement[] proposals) {
        if (Arrays.equals(proposals, this.getSourceProps())) {
            return;
        }
        ConfigPropertyMethodUpdateOperation op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName()){

            protected String createMethodBody(IMethod methodToOverride, IImportValidator validator) throws JavaModelException {
                StringBuilder source = new StringBuilder();
                source.append("  return ");
                source.append("new Class[]{");
                if (proposals.length > 0) {
                    int i = 0;
                    while (i < proposals.length) {
                        source.append(String.valueOf(SignatureUtility.getTypeReference((String)Signature.createTypeSignature((String)((IType)proposals[i]).getFullyQualifiedName(), (boolean)true), (IImportValidator)validator)) + ".class");
                        if (i < proposals.length - 1) {
                            source.append(",\n  ");
                        }
                        ++i;
                    }
                }
                source.append("\n};");
                return source.toString();
            }

            public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
                super.run(monitor, workingCopyManager);
                AnnotationCreateOperation createSuppressWarning = new AnnotationCreateOperation((IMember)this.getUpdatedMethod(), Signature.createTypeSignature((String)SuppressWarnings.class.getName(), (boolean)true), false);
                createSuppressWarning.addParameter("\"unchecked\"");
                createSuppressWarning.validate();
                createSuppressWarning.run(monitor, workingCopyManager);
            }
        };
        op.setFormatSource(true);
        new OperationJob(new IOperation[]{op}).schedule();
    }

    private class P_OutlineDialogPropertyListener
    implements PropertyChangeListener {
        private final JavaElementSelectionDialog m_dialog;

        private P_OutlineDialogPropertyListener(JavaElementSelectionDialog dialog) {
            this.m_dialog = dialog;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("selectedElements")) {
                IJavaElement[] selection = (IJavaElement[])evt.getNewValue();
                this.m_dialog.getOkButton().setEnabled(selection.length > 0);
            }
        }
    }
}

