/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.part;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.extensions.view.property.IPropertyViewPart;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.TableWrapLayoutEx;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.ui.view.properties.part.Section;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class AbstractSectionBasedPart
implements IPropertyViewPart {
    private PropertyViewFormToolkit m_formToolkit;
    private ScrolledForm m_form;
    private HashMap<String, Section> m_sections;
    private Composite m_sectionContainer;
    private ArrayList<IStatus> m_stati = new ArrayList();
    private Label m_statusIcon;
    private Label m_statusText;
    private Composite m_statusArea;

    @Override
    public final void createPart(Composite parent) {
        this.init();
        this.m_formToolkit = new PropertyViewFormToolkit(parent.getDisplay());
        this.m_form = this.m_formToolkit.createScrolledForm(parent);
        try {
            this.m_form.setRedraw(false);
            this.m_form.setDelayedReflow(true);
            this.createHeadInternal(this.m_form);
            Composite formBody = this.m_form.getBody();
            this.m_sectionContainer = this.getFormToolkit().createComposite(formBody);
            formBody.setLayout((Layout)new FillLayout());
            TableWrapLayoutEx layout = new TableWrapLayoutEx();
            layout.makeColumnsEqualWidth = true;
            layout.numColumns = 1;
            layout.horizontalSpacing = 3;
            layout.verticalSpacing = 3;
            layout.rightMargin = 3;
            layout.leftMargin = 3;
            layout.topMargin = 3;
            layout.bottomMargin = 3;
            this.m_sectionContainer.setLayout((Layout)layout);
            this.m_sections = new HashMap();
            this.createSections();
            this.m_form.updateToolBar();
            this.m_form.reflow(true);
        }
        finally {
            this.m_form.setRedraw(true);
        }
    }

    @Override
    public void init(IMemento memento) {
    }

    @Override
    public void save(IMemento memento) {
    }

    @Override
    public final void dispose() {
        this.cleanup();
        this.getFormToolkit().dispose();
        this.getForm().dispose();
    }

    private void createHeadInternal(ScrolledForm form) {
        Composite headComposite = this.getFormToolkit().createComposite(this.m_form.getForm().getHead());
        headComposite.setBackground(headComposite.getDisplay().getSystemColor(9));
        Control head = this.createHead(headComposite);
        Control statusArea = this.createStatusControl(headComposite);
        this.m_form.setHeadClient((Control)headComposite);
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        headComposite.setLayout((Layout)layout);
        head.setLayoutData((Object)new GridData(1808));
        GridData statusData = new GridData(1808);
        statusArea.setLayoutData((Object)statusData);
        this.updateStatus();
    }

    private Control createStatusControl(Composite parent) {
        this.m_statusArea = this.getFormToolkit().createComposite(parent);
        this.m_statusIcon = this.getFormToolkit().createLabel(this.m_statusArea, "");
        this.m_statusText = this.getFormToolkit().createLabel(this.m_statusArea, "", 16384);
        this.m_statusArea.setLayout((Layout)new GridLayout(2, false));
        this.m_statusIcon.setLayoutData((Object)new GridData(1040));
        this.m_statusText.setLayoutData((Object)new GridData(1808));
        return this.m_statusArea;
    }

    protected Control createHead(Composite parent) {
        Composite headArea = this.getFormToolkit().createComposite(parent);
        Label title = this.getFormToolkit().createLabel(headArea, "", 72);
        headArea.setLayout((Layout)new GridLayout(1, true));
        GridData titleData = new GridData(800);
        titleData.widthHint = 100;
        title.setLayoutData((Object)titleData);
        return headArea;
    }

    protected void createSections() {
    }

    protected final Section[] getSections() {
        return this.m_sections.values().toArray(new Section[this.m_sections.values().size()]);
    }

    public ISection getSection(String sectionId) {
        Section section = this.m_sections.get(sectionId);
        return section;
    }

    public final void removeSection(String sectionId) {
        Section section = this.m_sections.remove(sectionId);
        if (section != null && !section.isDisposed()) {
            section.getUiSection().dispose();
        }
    }

    protected final ISection createSection(String sectionId, String title) {
        return this.createSection(sectionId, title, null, true);
    }

    protected final ISection createSection(String sectionId, String title, String description, boolean twistle) {
        return this.createSection(sectionId, title, description, twistle, null);
    }

    protected final ISection createSection(String sectionId, String title, String description, boolean twistle, String siblingSectionId) {
        Section section = this.m_sections.get(sectionId);
        if (section == null) {
            boolean hasDescription;
            int style = 320;
            if (twistle) {
                style |= 2;
            }
            boolean bl = hasDescription = !StringUtility.isNullOrEmpty((String)description);
            if (hasDescription) {
                style |= 0x80;
            }
            Section sibling = null;
            if (siblingSectionId != null) {
                sibling = this.m_sections.get(siblingSectionId);
            }
            section = new Section(sectionId, this.getForm());
            section.createSection(this.getFormToolkit(), this.m_sectionContainer, title, description, style, sibling);
            this.m_sections.put(sectionId, section);
        }
        return section;
    }

    public void addStatus(IStatus status) {
        this.m_stati.add(status);
        this.updateStatus();
    }

    public boolean removeStatus(IStatus status) {
        boolean removed = this.m_stati.remove(status);
        this.updateStatus();
        return removed;
    }

    private void updateStatus() {
        if (this.getForm() != null && !this.getForm().isDisposed()) {
            MultiStatus multiStatus = new MultiStatus("org.eclipse.scout.sdk.ui", -1, null, null);
            for (IStatus s : this.m_stati) {
                multiStatus.add(s);
            }
            IStatus status = this.getHighestSeverityStatus((IStatus)multiStatus, Status.OK_STATUS);
            if (status == Status.OK_STATUS) {
                status = null;
            }
            GridData ld = (GridData)this.m_statusArea.getLayoutData();
            if (status == null) {
                ld.exclude = true;
            } else {
                ld.exclude = false;
                Image img = null;
                switch (status.getSeverity()) {
                    case 4: {
                        img = ScoutSdkUi.getImage("error.gif");
                        break;
                    }
                    case 2: {
                        img = ScoutSdkUi.getImage("warning.gif");
                        break;
                    }
                    case 1: {
                        img = ScoutSdkUi.getImage("info.gif");
                    }
                }
                this.m_statusIcon.setImage(img);
                this.m_statusText.setText(status.getMessage());
            }
            this.getForm().reflow(true);
        }
    }

    private IStatus getHighestSeverityStatus(IStatus status, IStatus highestSeverity) {
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                highestSeverity = this.getHighestSeverityStatus(child, highestSeverity);
                ++n2;
            }
            return highestSeverity;
        }
        if (highestSeverity.getSeverity() < status.getSeverity()) {
            highestSeverity = status;
        }
        return highestSeverity;
    }

    public ScrolledForm getForm() {
        return this.m_form;
    }

    protected PropertyViewFormToolkit getFormToolkit() {
        return this.m_formToolkit;
    }

    protected void init() {
    }

    protected void cleanup() {
    }
}

