/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.part.singlepage;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.FormNodePage;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.LinkGroup;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.LinksPresenterModel;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.TypeOpenLink;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.LinksPresenter;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.JdtTypePropertyPart;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class FormPropertyPart
extends JdtTypePropertyPart {
    private static final String SECTION_ID_LINKS = "section.links";
    final IType abstractFormData = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.data.form.AbstractFormData");
    final IType iService = TypeUtility.getType((String)"org.eclipse.scout.service.IService");
    final IType basicPermission = TypeUtility.getType((String)"java.security.BasicPermission");

    @Override
    protected void createSections() {
        ISection linkSection = this.createSection(SECTION_ID_LINKS, Texts.get((String)"Links"));
        this.fillLinkSection(linkSection.getSectionClient());
        linkSection.setExpanded(this.wasSectionExpanded(SECTION_ID_LINKS, true));
        super.createSections();
    }

    @Override
    public FormNodePage getPage() {
        return (FormNodePage)super.getPage();
    }

    protected void fillLinkSection(Composite parent) {
        final LinksPresenter presenter = new LinksPresenter(this.getFormToolkit(), parent);
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 200;
        presenter.getContainer().setLayoutData((Object)layoutData);
        final ProgressIndicator indicator = new ProgressIndicator(presenter.getContainer(), 65538);
        indicator.beginAnimatedTask();
        GridData indicatorData = new GridData(768);
        indicatorData.horizontalSpan = 2;
        indicatorData.heightHint = 5;
        indicator.setLayoutData((Object)indicatorData);
        Job j = new Job("load links..."){

            protected IStatus run(IProgressMonitor monitor) {
                String entityName = null;
                LinksPresenterModel model = new LinksPresenterModel();
                if (FormPropertyPart.this.getPage().getType() != null) {
                    model.addGlobalLink(new TypeOpenLink(FormPropertyPart.this.getPage().getType()));
                    entityName = FormPropertyPart.this.findEntityName(FormPropertyPart.this.getPage().getType().getElementName());
                }
                if (!StringUtility.isNullOrEmpty(entityName)) {
                    String formDataName;
                    IScoutBundle clientBundle = FormPropertyPart.this.getPage().getScoutResource();
                    IScoutProject scoutProject = clientBundle.getScoutProject();
                    IScoutBundle sharedBundle = scoutProject.getSharedBundle();
                    while (sharedBundle == null) {
                        if ((scoutProject = scoutProject.getParentProject()) == null) break;
                        sharedBundle = scoutProject.getSharedBundle();
                    }
                    if (sharedBundle != null && TypeUtility.existsType((String)(formDataName = String.valueOf(sharedBundle.getPackageName(".services.process")) + "." + entityName + "FormData"))) {
                        model.addGlobalLink(new TypeOpenLink(TypeUtility.getType((String)formDataName)));
                    }
                    String formRegex = "(I)?" + entityName + "ProcessService";
                    ITypeFilter formFilter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getRegexSimpleNameFilter((String)formRegex), ScoutTypeFilters.getInScoutProject((IScoutProject)clientBundle.getScoutProject())});
                    LinkGroup serviceGroup = model.getOrCreateGroup(Texts.get((String)"Service"), 10);
                    IType[] iTypeArray = TypeUtility.getPrimaryTypeHierarchy((IType)FormPropertyPart.this.iService).getAllSubtypes(FormPropertyPart.this.iService, formFilter, TypeComparators.getTypeNameComparator());
                    int n = iTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType candidate = iTypeArray[n2];
                        serviceGroup.addLink(new TypeOpenLink(candidate));
                        ++n2;
                    }
                    String permissionRegex = "(Create|Read|Update)" + entityName + "Permission";
                    ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getRegexSimpleNameFilter((String)permissionRegex), TypeFilters.getClassFilter(), ScoutTypeFilters.getInScoutProject((IScoutProject)clientBundle.getScoutProject())});
                    LinkGroup permissionGroup = model.getOrCreateGroup(Texts.get((String)"PermissionTablePage"), 20);
                    IType[] iTypeArray2 = TypeUtility.getPrimaryTypeHierarchy((IType)FormPropertyPart.this.basicPermission).getAllSubtypes(FormPropertyPart.this.basicPermission, filter, TypeComparators.getTypeNameComparator());
                    int n3 = iTypeArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IType candidate = iTypeArray2[n4];
                        permissionGroup.addLink(new TypeOpenLink(candidate));
                        ++n4;
                    }
                }
                if (presenter != null && !presenter.isDisposed()) {
                    final LinksPresenterModel finalModel = model;
                    presenter.getContainer().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (presenter != null && !presenter.isDisposed()) {
                                indicator.dispose();
                                presenter.setLinksProperty(finalModel);
                                FormPropertyPart.this.getForm().layout(true, true);
                                FormPropertyPart.this.getForm().updateToolBar();
                                FormPropertyPart.this.getForm().reflow(true);
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        j.setSystem(true);
        j.schedule();
    }

    private String findEntityName(String serviceName) {
        if (StringUtility.isNullOrEmpty((String)serviceName)) {
            return serviceName;
        }
        if (serviceName.endsWith("Form")) {
            return serviceName.replaceAll("^(.*)Form$", "$1");
        }
        return serviceName;
    }
}

