/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.part.singlepage;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.AbstractSinglePageSectionBasedViewPart;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.ProductLaunchPresenter;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class ProductLaunchPropertyPart
extends AbstractSinglePageSectionBasedViewPart {
    private static final String SECTION_ID_LINKS = "section.links";
    final IType basicPermission = TypeUtility.getType((String)"java.security.BasicPermission");
    final IType iForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");

    @Override
    protected void createSections() {
        ISection linkSection = this.createSection(SECTION_ID_LINKS, Texts.get((String)"Links"));
        this.fillLinkSection(linkSection.getSectionClient());
        super.createSections();
    }

    protected void fillLinkSection(Composite parent) {
        IResource resource;
        IScoutBundle bundle = (IScoutBundle)this.getPage().getScoutResource();
        if (bundle != null && (resource = bundle.getProject().findMember("products")) != null && resource.exists() && resource.getType() == 2) {
            IFolder productFolder = (IFolder)resource;
            P_ProductResourceVisitor productVisitor = new P_ProductResourceVisitor();
            try {
                productFolder.accept((IResourceVisitor)productVisitor);
            }
            catch (CoreException e) {
                ScoutSdkUi.logError("error during visiting folder '" + productFolder.getFullPath() + "'.", e);
            }
            IFile[] iFileArray = productVisitor.getProductFiles();
            int n = iFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile productFile = iFileArray[n2];
                ProductLaunchPresenter p = new ProductLaunchPresenter(this.getFormToolkit(), parent, productFile, bundle);
                GridData layoutData = new GridData(768);
                layoutData.widthHint = 200;
                p.getContainer().setLayoutData((Object)layoutData);
                ++n2;
            }
        }
    }

    private class P_ProductResourceVisitor
    implements IResourceVisitor {
        private ArrayList<IFile> m_productFiels = new ArrayList();

        private P_ProductResourceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 1 && resource.getName().matches(".*\\.product")) {
                this.m_productFiels.add((IFile)resource);
            } else if (resource.getType() == 2) {
                return true;
            }
            return false;
        }

        private IFile[] getProductFiles() {
            return this.m_productFiels.toArray(new IFile[this.m_productFiels.size()]);
        }
    }
}

