/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.bundle;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.project.BundleImportOperation;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.StaticContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;

public class BundleImportWizardPage
extends AbstractWorkspaceWizardPage {
    private ProposalTextField m_pluginModelField;
    private IPluginModelBase m_pluginModel;
    private boolean m_projectIdFieldEnabled = true;

    public BundleImportWizardPage() {
        super(BundleImportWizardPage.class.getName());
        this.setTitle(Texts.get((String)"ImportScoutBundle"));
        this.setDescription(Texts.get((String)"BundleImportDesc"));
    }

    @Override
    protected void createContent(Composite parent) {
        IPluginModelBase[] workspaceModels = PluginRegistry.getWorkspaceModels();
        ArrayList<IPluginModelBase> proposals = new ArrayList<IPluginModelBase>();
        IPluginModelBase[] iPluginModelBaseArray = workspaceModels;
        int n = workspaceModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase pluginModel = iPluginModelBaseArray[n2];
            IProject p = pluginModel.getUnderlyingResource().getProject();
            if (ScoutSdkCore.getScoutWorkspace().getScoutBundle(p) == null) {
                proposals.add(pluginModel);
            }
            ++n2;
        }
        this.m_pluginModelField = this.getFieldToolkit().createProposalField(parent, Texts.get((String)"PluginToImport"));
        P_PluginDescLabelProvider labelProvider = new P_PluginDescLabelProvider();
        this.m_pluginModelField.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.m_pluginModelField.setContentProvider(new StaticContentProvider(proposals.toArray(new Object[proposals.size()]), (ILabelProvider)labelProvider));
        this.m_pluginModelField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    BundleImportWizardPage.this.setStateChanging(true);
                    BundleImportWizardPage.this.setPluginSelectionInternal((IPluginModelBase)event.proposal);
                }
                finally {
                    BundleImportWizardPage.this.setStateChanging(false);
                }
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_pluginModelField.setLayoutData(new GridData(768));
    }

    private void setPluginSelectionInternal(IPluginModelBase proposal) {
        this.m_pluginModel = proposal;
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        BundleImportOperation operation = new BundleImportOperation();
        operation.setPluginModel(this.getPluginModel());
        operation.run(monitor, workingCopyManager);
        ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox box = new MessageBox(ScoutSdkUi.getShell(), 34);
                box.setMessage(Texts.get((String)"BundleImportRestartMsg"));
                box.open();
            }
        });
        return true;
    }

    public void setPluginModel(IPluginModelBase pluginModel) {
        this.m_pluginModel = pluginModel;
    }

    public IPluginModelBase getPluginModel() {
        return this.m_pluginModel;
    }

    public boolean isProjectIdFieldEnabled() {
        return this.m_projectIdFieldEnabled;
    }

    private class P_PluginDescLabelProvider
    extends LabelProvider {
        private P_PluginDescLabelProvider() {
        }

        public String getText(Object element) {
            IPluginModelBase pluginModel = (IPluginModelBase)element;
            return pluginModel.getBundleDescription().getName();
        }

        public Image getImage(Object element) {
            return ScoutSdkUi.getImage("sharedBundle.png");
        }
    }
}

