/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.type;

import java.util.ArrayList;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.IPropertyBean;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public class PropertyBean
implements IPropertyBean {
    private IField m_field;
    private IMethod m_readMethod;
    private IMethod m_writeMethod;
    private String m_beanName;
    private final IType m_declaringType;

    public PropertyBean(IType declaringType, String beanName) {
        this.m_declaringType = declaringType;
        this.m_beanName = beanName;
    }

    @Override
    public IType getDeclaringType() {
        return this.m_declaringType;
    }

    @Override
    public IMember[] getAllMembers() {
        ArrayList<Object> members = new ArrayList<Object>();
        if (TypeUtility.exists((IJavaElement)this.m_field)) {
            members.add(this.m_field);
        }
        if (TypeUtility.exists((IJavaElement)this.m_readMethod)) {
            members.add(this.m_readMethod);
        }
        if (TypeUtility.exists((IJavaElement)this.m_writeMethod)) {
            members.add(this.m_writeMethod);
        }
        return members.toArray(new IMember[members.size()]);
    }

    public void setBeanName(String beanName) {
        this.m_beanName = beanName;
    }

    @Override
    public String getBeanName() {
        return this.m_beanName;
    }

    @Override
    public String getBeanSignature() {
        String beanSignature = null;
        if (TypeUtility.exists((IJavaElement)this.getReadMethod())) {
            try {
                String methodSig = this.getReadMethod().getSignature();
                beanSignature = Signature.getReturnType((String)methodSig);
                beanSignature = SignatureUtility.getQuallifiedSignature(beanSignature, this.getReadMethod().getDeclaringType());
                return beanSignature;
            }
            catch (JavaModelException e) {
                SdkUtilActivator.logWarning("could not parse signature of '" + this.getReadMethod().getElementName() + "' in type '" + this.getReadMethod().getDeclaringType().getFullyQualifiedName() + "'.", e);
            }
        }
        if (TypeUtility.exists((IJavaElement)this.getWriteMethod())) {
            try {
                String methodSig = this.getReadMethod().getSignature();
                String[] paramSignature = Signature.getParameterTypes((String)methodSig);
                if (paramSignature != null && paramSignature.length == 1) {
                    beanSignature = paramSignature[0];
                    beanSignature = SignatureUtility.getQuallifiedSignature(beanSignature, this.getWriteMethod().getDeclaringType());
                    return beanSignature;
                }
            }
            catch (JavaModelException e) {
                SdkUtilActivator.logWarning("could not parse signature of '" + this.getWriteMethod().getElementName() + "' in type '" + this.getWriteMethod().getDeclaringType().getFullyQualifiedName() + "'.", e);
            }
        }
        return null;
    }

    @Override
    public IField getField() {
        return this.m_field;
    }

    public void setField(IField field) {
        this.m_field = field;
    }

    @Override
    public IMethod getReadMethod() {
        return this.m_readMethod;
    }

    public void setReadMethod(IMethod readMethod) {
        this.m_readMethod = readMethod;
    }

    @Override
    public IMethod getWriteMethod() {
        return this.m_writeMethod;
    }

    public void setWriteMethod(IMethod writeMethod) {
        this.m_writeMethod = writeMethod;
    }
}

