/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.internal.typecache;

import java.util.EventListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.internal.typecache.TypeHierarchy;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;

public class CachedTypeHierarchy
extends TypeHierarchy
implements ICachedTypeHierarchy {
    private boolean m_created = false;
    private EventListenerList m_hierarchyListeners = new EventListenerList();

    CachedTypeHierarchy(IType type) {
        super(type);
    }

    @Override
    public void invalidate() {
        this.m_created = false;
    }

    void handleTypeAdding(IType type) {
        this.fireHierarchyChanged(3, type);
        this.invalidate();
        this.fireHierarchyChanged(4, type);
    }

    void handleTypeChanged(IType type) {
        this.fireHierarchyChanged(1, type);
        this.invalidate();
        this.fireHierarchyChanged(2, type);
    }

    void handleTypeRemoving(IType type) {
        this.fireHierarchyChanged(5, type);
        this.invalidate();
        this.fireHierarchyChanged(6, type);
    }

    private void fireHierarchyChanged(int type, IType affectedType) {
        ITypeHierarchyChangedListener[] iTypeHierarchyChangedListenerArray = (ITypeHierarchyChangedListener[])this.m_hierarchyListeners.getListeners(ITypeHierarchyChangedListener.class);
        int n = iTypeHierarchyChangedListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeHierarchyChangedListener l = iTypeHierarchyChangedListenerArray[n2];
            l.handleEvent(type, affectedType);
            ++n2;
        }
    }

    @Override
    public boolean isCreated() {
        return this.m_created;
    }

    @Override
    public void addHierarchyListener(ITypeHierarchyChangedListener listener) {
        this.m_hierarchyListeners.add(ITypeHierarchyChangedListener.class, (EventListener)listener);
    }

    @Override
    public void removeHierarchyListener(ITypeHierarchyChangedListener listener) {
        this.m_hierarchyListeners.remove(ITypeHierarchyChangedListener.class, (EventListener)listener);
    }

    @Override
    void revalidate(IProgressMonitor monitor) {
        if (!this.m_created) {
            if (!TypeUtility.exists((IJavaElement)this.getType()) || !this.getType().getJavaProject().exists()) {
                throw new IllegalArgumentException("type or project does not exist");
            }
            try {
                if (this.getJdtHierarchy() == null) {
                    this.setJdtHierarchy(this.getType().newTypeHierarchy(monitor));
                } else if (TypeUtility.exists((IJavaElement)this.getType()) && this.getType().getJavaProject().exists()) {
                    this.getJdtHierarchy().refresh(monitor);
                } else {
                    return;
                }
                this.m_created = true;
            }
            catch (JavaModelException e) {
                SdkUtilActivator.logError("Unable to refresh cached type hierarchy for type " + this.getType().getFullyQualifiedName(), e);
            }
        }
    }
}

