/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.log;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.util.log.LogStatus;
import org.osgi.framework.BundleContext;

public class SdkLogManager {
    private static final String LOG_LEVEL_SUFFIX = ".loglevel";
    private int m_loglevel;
    private final Plugin m_plugin;

    public SdkLogManager(Plugin p) {
        this(p, SdkLogManager.getLogLevelProperty(p));
    }

    public SdkLogManager(Plugin p, String logLevel) {
        this(p, SdkLogManager.parseLogLevel(logLevel));
    }

    public SdkLogManager(Plugin p, int logLevel) {
        this.m_plugin = p;
        this.m_loglevel = logLevel;
    }

    private LogStatus createLogStatus(int severity, String message, Throwable t) {
        return new LogStatus(this.m_plugin.getClass(), severity, this.m_plugin.getBundle().getSymbolicName(), message, t);
    }

    private LogStatus createLogStatus(IStatus log) {
        if (log instanceof LogStatus) {
            return (LogStatus)log;
        }
        return new LogStatus(this.m_plugin.getClass(), log.getSeverity(), log.getPlugin(), log.getMessage(), log.getException());
    }

    private void logImpl(LogStatus log) {
        if ((log.getSeverity() & this.m_loglevel) != 0) {
            this.m_plugin.getLog().log((IStatus)log);
        }
    }

    public void log(IStatus log) {
        this.logImpl(this.createLogStatus(log));
    }

    public void logInfo(Throwable t) {
        this.logInfo(null, t);
    }

    public void logInfo(String message) {
        this.logInfo(message, null);
    }

    public void logInfo(String message, Throwable t) {
        if (message == null) {
            message = "";
        }
        this.logImpl(this.createLogStatus(1, message, t));
    }

    public void logWarning(String message) {
        this.logWarning(message, null);
    }

    public void logWarning(Throwable t) {
        this.logWarning(null, t);
    }

    public void logWarning(String message, Throwable t) {
        if (message == null) {
            message = "";
        }
        this.logImpl(this.createLogStatus(2, message, t));
    }

    public void logError(Throwable t) {
        this.logError("", t);
    }

    public void logError(String message) {
        this.logError(message, null);
    }

    public void logError(String message, Throwable t) {
        if (message == null) {
            message = "";
        }
        this.logImpl(this.createLogStatus(4, message, t));
    }

    public void log(int logLevel, Throwable t) {
        this.log(logLevel, "", t);
    }

    public void log(int logLevel, String message) {
        this.log(logLevel, message, null);
    }

    public void log(int logLevel, String message, Throwable t) {
        if (message == null) {
            message = "";
        }
        this.logImpl(this.createLogStatus(logLevel, message, t));
    }

    private static String getLogLevelProperty(Plugin p) {
        if (p != null && p.getBundle() != null) {
            return SdkLogManager.getLogLevelProperty(p.getBundle().getBundleContext());
        }
        return null;
    }

    private static String getLogLevelProperty(BundleContext context) {
        if (context == null) {
            return null;
        }
        return context.getProperty(String.valueOf(context.getBundle().getSymbolicName()) + LOG_LEVEL_SUFFIX);
    }

    private static int parseLogLevel(String loglevel) {
        int level = 15;
        if (!StringUtility.isNullOrEmpty((String)loglevel)) {
            String lowerLoglevel = loglevel.toLowerCase();
            if (lowerLoglevel.equals("warning")) {
                level = 14;
            } else if (lowerLoglevel.equals("error")) {
                level = 12;
            } else if (lowerLoglevel.equals("cancel")) {
                level = 8;
            }
        }
        return level;
    }
}

