/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.operation.BuildJaxWsFileCreateOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;

public class BuildJaxWsEntryCreateOperation
implements IOperation {
    private IScoutBundle m_bundle;
    private String m_alias;
    private String m_wsdlFile;
    private Map<String, List<String>> m_buildProperties;
    private WebserviceEnum m_webserviceEnum;
    private BuildJaxWsBean m_createdBuildJaxWsBean;

    public BuildJaxWsEntryCreateOperation(WebserviceEnum webserviceEnum) {
        this.m_webserviceEnum = webserviceEnum;
    }

    public void validate() throws IllegalArgumentException {
        if (this.m_bundle == null) {
            throw new IllegalArgumentException("bundle not set");
        }
        if (!StringUtility.hasText((String)this.m_alias)) {
            throw new IllegalArgumentException("alias must not be empty");
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        XmlResource buildJaxWsResource = ResourceFactory.getBuildJaxWsResource(this.m_bundle);
        if (buildJaxWsResource.getFile() == null || !buildJaxWsResource.getFile().exists()) {
            BuildJaxWsFileCreateOperation op = new BuildJaxWsFileCreateOperation(this.m_bundle);
            op.run(monitor, workingCopyManager);
        }
        ScoutXmlDocument xmlDocument = buildJaxWsResource.loadXml();
        ScoutXmlDocument.ScoutXmlElement xml = this.m_webserviceEnum == WebserviceEnum.Provider ? xmlDocument.getRoot().addChild("provider") : xmlDocument.getRoot().addChild("consumer");
        BuildJaxWsBean bean = new BuildJaxWsBean(xml, this.m_webserviceEnum);
        bean.setAlias(this.m_alias);
        if (this.m_webserviceEnum == WebserviceEnum.Consumer) {
            bean.setWsdl(this.m_wsdlFile);
        }
        bean.setProperties(this.m_buildProperties);
        this.m_createdBuildJaxWsBean = bean;
        ResourceFactory.getBuildJaxWsResource(this.m_bundle).storeXml(this.m_createdBuildJaxWsBean.getXml().getDocument(), 4, monitor, this.m_alias);
    }

    public String getOperationName() {
        return BuildJaxWsEntryCreateOperation.class.getName();
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public String getAlias() {
        return this.m_alias;
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    public Map<String, List<String>> getBuildProperties() {
        return this.m_buildProperties;
    }

    public void setBuildProperties(Map<String, List<String>> buildProperties) {
        this.m_buildProperties = buildProperties;
    }

    public String getWsdlFile() {
        return this.m_wsdlFile;
    }

    public void setWsdlFile(String wsdlFile) {
        this.m_wsdlFile = wsdlFile;
    }

    public BuildJaxWsBean getCreatedBuildJaxWsBean() {
        return this.m_createdBuildJaxWsBean;
    }
}

