/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.SourceFormatOperation;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.text.edits.ReplaceEdit;

public class SourceRangeRemoveOperation
implements IOperation {
    private IType m_declaringType;
    private IAnnotation m_annotation;

    public void validate() throws IllegalArgumentException {
        if (this.m_declaringType == null) {
            throw new IllegalArgumentException("declaring must not be null");
        }
        if (this.m_annotation == null) {
            throw new IllegalArgumentException("annotation must not be null");
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        ICompilationUnit icu = this.m_declaringType.getCompilationUnit();
        String source = this.m_declaringType.getCompilationUnit().getBuffer().getContents();
        ISourceRange sourceRange = this.m_annotation.getSourceRange();
        Document icuDoc = new Document(source);
        ReplaceEdit edit = new ReplaceEdit(sourceRange.getOffset(), sourceRange.getLength(), "");
        try {
            edit.apply((IDocument)icuDoc);
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new ScoutStatus("Failed to remve annotation", (Throwable)e));
        }
        workingCopyManager.register(icu, monitor);
        SourceFormatOperation sourceFormatOp = new SourceFormatOperation(this.m_declaringType.getJavaProject(), icuDoc, null);
        sourceFormatOp.run(monitor, workingCopyManager);
        icu.getBuffer().setContents(ScoutUtility.cleanLineSeparator((String)icuDoc.get(), (Document)icuDoc));
    }

    public String getOperationName() {
        return SourceRangeRemoveOperation.class.getName();
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }

    public void setDeclaringType(IType declaringType) {
        this.m_declaringType = declaringType;
    }

    public IAnnotation getAnnotation() {
        return this.m_annotation;
    }

    public void setAnnotation(IAnnotation annotation) {
        this.m_annotation = annotation;
    }
}

