/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.operation.WsStubGenerationOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.ElementBean;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class WsFilesMoveOperation
implements IOperation {
    public static final int ID_WSDL_FILE = 2;
    public static final int ID_REF_WSDL = 4;
    public static final int ID_REF_XSD = 8;
    public static final int ID_WSDL_SUNJAXWS_REGISTRATION = 16;
    public static final int ID_WSDL_BUILDJAXWS_REGISTRATION = 32;
    public static final int ID_BINDING_FILE = 64;
    private IScoutBundle m_bundle;
    private SunJaxWsBean m_sunJaxWsBean;
    private BuildJaxWsBean m_buildJaxWsBean;
    private List<ElementBean> m_elements;
    private IFolder m_destination;

    public void validate() throws IllegalArgumentException {
        if (this.m_bundle == null) {
            throw new IllegalArgumentException("No bundle set");
        }
        if (this.m_buildJaxWsBean == null) {
            throw new IllegalArgumentException("No buildJaxWsBean set");
        }
        if (this.m_elements == null) {
            throw new IllegalArgumentException("No elements set");
        }
        if (this.m_destination == null) {
            throw new IllegalArgumentException("No destination path set");
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        JaxWsSdk.getDefault().getMarkerQueueManager().suspend();
        try {
            String wsdlFileName = null;
            for (ElementBean element : this.m_elements) {
                switch (element.getId()) {
                    case 2: 
                    case 4: 
                    case 8: {
                        this.moveFile((IFile)element.getResource(), this.m_destination, monitor);
                        break;
                    }
                    case 16: {
                        wsdlFileName = JaxWsSdkUtility.getFile(this.m_bundle, this.m_sunJaxWsBean.getWsdl(), false).getName();
                        this.m_sunJaxWsBean.setWsdl(JaxWsSdkUtility.normalizePath(this.m_destination.getProjectRelativePath().append(wsdlFileName).toPortableString(), JaxWsSdkUtility.SeparatorType.None));
                        ResourceFactory.getSunJaxWsResource(this.m_bundle).storeXml(this.m_sunJaxWsBean.getXml().getDocument(), 16, monitor, this.m_sunJaxWsBean.getAlias());
                        break;
                    }
                    case 32: {
                        wsdlFileName = JaxWsSdkUtility.getFile(this.m_bundle, this.m_buildJaxWsBean.getWsdl(), false).getName();
                        this.m_buildJaxWsBean.setWsdl(JaxWsSdkUtility.normalizePath(this.m_destination.getProjectRelativePath().append(wsdlFileName).toPortableString(), JaxWsSdkUtility.SeparatorType.None));
                        ResourceFactory.getBuildJaxWsResource(this.m_bundle).storeXml(this.m_buildJaxWsBean.getXml().getDocument(), 16, monitor, this.m_buildJaxWsBean.getAlias());
                        break;
                    }
                    case 64: {
                        IFile bindingFile = (IFile)element.getResource();
                        XmlResource xmlResource = new XmlResource(this.m_bundle);
                        xmlResource.setFile(bindingFile);
                        ScoutXmlDocument xmlDocument = xmlResource.loadXml();
                        String namespacePrefix = xmlDocument.getRoot().getNamePrefix();
                        ScoutXmlDocument.ScoutXmlElement xmlBindings = xmlDocument.getChild(StringUtility.join((String)":", (Object[])new Object[]{namespacePrefix, "bindings"}));
                        if (!xmlBindings.hasAttribute("wsdlLocation")) break;
                        xmlBindings.removeAttribute("wsdlLocation");
                        xmlBindings.setAttribute("wsdlLocation", (String)element.getData());
                        xmlResource.storeXml(xmlDocument, 1, monitor, new String[0]);
                    }
                }
            }
            if (wsdlFileName != null) {
                WsStubGenerationOperation op = new WsStubGenerationOperation();
                op.setBundle(this.m_bundle);
                op.setAlias(this.m_buildJaxWsBean.getAlias());
                op.setProperties(this.m_buildJaxWsBean.getPropertiers());
                op.setWsdlFileName(wsdlFileName);
                op.setWsdlFolder(this.m_destination);
                op.run(monitor, workingCopyManager);
            }
        }
        finally {
            JaxWsSdk.getDefault().getMarkerQueueManager().resume();
        }
    }

    private void moveFile(IFile file, IFolder destinationFolderPath, IProgressMonitor monitor) throws CoreException {
        if (file == null || !file.exists()) {
            return;
        }
        try {
            JaxWsSdkUtility.getFolder(this.m_bundle, destinationFolderPath.getProjectRelativePath().toPortableString(), true);
            file.move(destinationFolderPath.getFullPath().append(file.getName()), true, true, monitor);
        }
        catch (Exception e) {
            JaxWsSdk.logError(e);
        }
    }

    public String getOperationName() {
        return WsFilesMoveOperation.class.getName();
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public SunJaxWsBean getSunJaxWsBean() {
        return this.m_sunJaxWsBean;
    }

    public void setSunJaxWsBean(SunJaxWsBean sunJaxWsBean) {
        this.m_sunJaxWsBean = sunJaxWsBean;
    }

    public BuildJaxWsBean getBuildJaxWsBean() {
        return this.m_buildJaxWsBean;
    }

    public void setBuildJaxWsBean(BuildJaxWsBean buildJaxWsBean) {
        this.m_buildJaxWsBean = buildJaxWsBean;
    }

    public IFolder getDestination() {
        return this.m_destination;
    }

    public void setDestination(IFolder destination) {
        this.m_destination = destination;
    }

    public List<ElementBean> getElements() {
        return this.m_elements;
    }

    public void setElements(List<ElementBean> elements) {
        this.m_elements = elements;
    }
}

