/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public final class ResourceFactory {
    private static final Map<IScoutBundle, XmlResource> sm_sunJaxWsResourceMap = new HashMap<IScoutBundle, XmlResource>();
    private static final Map<IScoutBundle, XmlResource> sm_buildJaxWsResourceMap = new HashMap<IScoutBundle, XmlResource>();

    private ResourceFactory() {
    }

    public static synchronized XmlResource getSunJaxWsResource(IScoutBundle bundle) {
        return ResourceFactory.getSunJaxWsResource(bundle, false);
    }

    public static synchronized XmlResource getSunJaxWsResource(IScoutBundle bundle, boolean autoCreate) {
        if (!sm_sunJaxWsResourceMap.containsKey(bundle)) {
            XmlResource resource = new XmlResource(bundle);
            resource.setFile(JaxWsSdkUtility.getFile(bundle, "/WEB-INF/sun-jaxws.xml", autoCreate));
            sm_sunJaxWsResourceMap.put(bundle, resource);
        }
        XmlResource xmlResource = sm_sunJaxWsResourceMap.get(bundle);
        if (autoCreate && (xmlResource.getFile() == null || !xmlResource.existsFile())) {
            xmlResource.setFile(JaxWsSdkUtility.getFile(bundle, "/WEB-INF/sun-jaxws.xml", autoCreate));
        }
        return xmlResource;
    }

    public static synchronized XmlResource getBuildJaxWsResource(IScoutBundle bundle) {
        return ResourceFactory.getBuildJaxWsResource(bundle, false);
    }

    public static synchronized XmlResource getBuildJaxWsResource(IScoutBundle bundle, boolean autoCreate) {
        if (!sm_buildJaxWsResourceMap.containsKey(bundle)) {
            XmlResource resource = new XmlResource(bundle);
            resource.setFile(JaxWsSdkUtility.getFile(bundle, "/WEB-INF/build/build-jaxws.xml", autoCreate));
            sm_buildJaxWsResourceMap.put(bundle, resource);
        }
        XmlResource xmlResource = sm_buildJaxWsResourceMap.get(bundle);
        if (autoCreate && (xmlResource.getFile() == null || !xmlResource.existsFile())) {
            xmlResource.setFile(JaxWsSdkUtility.getFile(bundle, "/WEB-INF/build/build-jaxws.xml", autoCreate));
        }
        return xmlResource;
    }
}

