/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.action;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.AbstractLinkAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class FileOpenAction
extends AbstractLinkAction {
    private IFile m_file;
    private FileExtensionType m_extensionType;

    public FileOpenAction() {
        super("", null);
    }

    public void init(IFile file, String linkText, ImageDescriptor icon, FileExtensionType extensionType) {
        this.init(file, null, linkText, icon, extensionType);
    }

    public void init(IFile file, String leadingText, String linkText, ImageDescriptor icon, FileExtensionType extensionType) {
        this.setLeadingText(leadingText);
        this.setLinkText(linkText);
        this.setImage(icon);
        this.m_file = file;
        this.m_extensionType = extensionType;
    }

    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        try {
            if (this.m_extensionType == FileExtensionType.Auto) {
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)this.getFile(), (boolean)true);
            } else {
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(this.m_extensionType.getExtension());
                if (desc == null) {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)this.getFile(), (boolean)true);
                } else {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)this.getFile(), (String)desc.getId(), (boolean)true);
                }
            }
        }
        catch (PartInitException e) {
            JaxWsSdk.logError("could not open file '" + this.m_file + "'.", e);
        }
        return null;
    }

    private IFile getFile() {
        return this.m_file;
    }

    public static enum FileExtensionType {
        Auto,
        Xml("*.xml"),
        Txt("*.txt");

        private String m_extension;

        private FileExtensionType() {
        }

        private FileExtensionType(String extension) {
            this.m_extension = extension;
        }

        public String getExtension() {
            return this.m_extension;
        }
    }
}

